/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0003@ABB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016J \u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001eH\u0002J(\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J.\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u00072\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u00104\u001a\u00020\u0011H\u0002J\u0018\u00105\u001a\u00020\u00112\u0006\u0010)\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0002J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0018\u001a\u00020!2\u0006\u00106\u001a\u000207H\u0002J6\u0010:\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020#2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002070\u000e2\u0006\u0010<\u001a\u00020+H\u0002J \u0010=\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?H\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "mFormatStrings", "", "", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "mNotFormatStrings", "mIgnoreStrings", "", "mStringsFromPsiCache", "", "Lcom/android/tools/lint/checks/StringFormatDetector$FormatString;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "createLocationHandleForXmlDomElement", "afterCheckRootProject", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "crossCheckResources", "checkStringFormatCall", "calledMethod", "call", "argIndex", "", "resourceFormatString", "name", "item", "Lcom/android/ide/common/resources/ResourceItem;", "resources", "Lcom/android/ide/common/resources/ResourceRepository;", "visitResourceItems", "strings", "valueOnlyHandle", "isInStringExpression", "expression", "Lorg/jetbrains/uast/UExpression;", "getStringType", "Lcom/intellij/psi/PsiType;", "checkTrivialString", "args", "stringIndex", "checkArityAndTypes", "formatType", "Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;", "StringFormatType", "FormatString", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nStringFormatDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1580:1\n1563#2:1581\n1634#2,3:1582\n774#2:1585\n865#2,2:1586\n*S KotlinDebug\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector\n*L\n391#1:1581\n391#1:1582,3\n392#1:1585\n392#1:1586,2\n*E\n"})
public final class StringFormatDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Pair<Location.Handle, String>> mFormatStrings = new LinkedHashMap();
    @NotNull
    private final Map<String, Location.Handle> mNotFormatStrings = new LinkedHashMap();
    @NotNull
    private final Set<String> mIgnoreStrings = new HashSet();
    @NotNull
    private final Map<String, List<FormatString>> mStringsFromPsiCache = new LinkedHashMap();
    @NotNull
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    @NotNull
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA;
    @JvmField
    @NotNull
    public static final Issue INVALID;
    @JvmField
    @NotNull
    public static final Issue ARG_COUNT;
    @NotNull
    private static final Issue TRIVIAL;
    @JvmField
    @NotNull
    public static final Issue ARG_TYPES;
    @JvmField
    @NotNull
    public static final Issue POTENTIAL_PLURAL;
    @NotNull
    private static final String STRING_RESOURCE_METHOD = "stringResource";
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    @JvmField
    @NotNull
    public static final Pattern FORMAT;
    @NotNull
    private static final Companion.TypeTest isCharacterType;
    @NotNull
    private static final Companion.TypeTest isBooleanType;
    @NotNull
    private static final Companion.TypeTest isIntType;
    @NotNull
    private static final Companion.TypeTest isFloatType;
    @NotNull
    private static final Companion.TypeTest isNumericType;
    @NotNull
    private static final Companion.TypeTest isNumericOrBigNumberType;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"string");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        block10: {
            String text;
            block11: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    text = element.getTextContent();
                    Intrinsics.checkNotNull((Object)text);
                    if (((CharSequence)text).length() == 0) {
                        return;
                    }
                    if (!context2.getProject().getReportIssues()) {
                        return;
                    }
                    if (this.crossCheckResources(context2)) break block9;
                    StringFormatDetector.Companion.checkTextNode(context2, element, StringFormatDetector.Companion.stripQuotes(text));
                    break block10;
                }
                if (context2.getPhase() != 1) break block11;
                FolderConfiguration folderConfiguration = context2.getFolderConfiguration();
                boolean bl = folderConfiguration != null ? folderConfiguration.isDefault() : false;
                if (!bl) break block11;
                StringFormatType formatType = StringFormatDetector.Companion.checkTextNode(context2, element, StringFormatDetector.Companion.stripQuotes(text));
                this.checkArityAndTypes(context2, element, formatType);
                String name = element.getAttribute("name");
                switch (WhenMappings.$EnumSwitchMapping$0[formatType.ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)name);
                        this.mIgnoreStrings.add(name);
                        break block10;
                    }
                    case 2: {
                        this.mFormatStrings.put(name, (Pair<Location.Handle, String>)TuplesKt.to((Object)this.createLocationHandleForXmlDomElement(context2, element), (Object)text));
                        break block10;
                    }
                    case 3: {
                        this.mNotFormatStrings.put(name, this.createLocationHandleForXmlDomElement(context2, element));
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (context2.getPhase() == 2) {
                FolderConfiguration folderConfiguration = context2.getFolderConfiguration();
                boolean bl = folderConfiguration != null ? !folderConfiguration.isDefault() : false;
                if (bl) {
                    StringFormatType formatType = StringFormatDetector.Companion.checkTextNode(context2, element, StringFormatDetector.Companion.stripQuotes(text));
                    this.checkArityAndTypes(context2, element, formatType);
                }
            }
        }
    }

    private final Location.Handle createLocationHandleForXmlDomElement(XmlContext context2, Element element) {
        Location.Handle handle2 = context2.createLocationHandle(element);
        handle2.setClientData(element);
        return handle2;
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getPhase() == 1 && this.crossCheckResources(context2)) {
            context2.requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"format", "getString", STRING_RESOURCE_METHOD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block22: {
            block25: {
                JavaEvaluator evaluator;
                block24: {
                    String methodName;
                    block21: {
                        String cls;
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        if (context2.getPhase() != 1) {
                            return;
                        }
                        evaluator = context2.getEvaluator();
                        String string2 = method.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        methodName = string2;
                        if (!Intrinsics.areEqual((Object)methodName, (Object)"format")) break block21;
                        PsiClass psiClass = method.getContainingClass();
                        String string3 = cls = psiClass != null ? psiClass.getQualifiedName() : null;
                        if (cls == null) break block22;
                        int n = -1;
                        switch (cls.hashCode()) {
                            case -803949449: {
                                if (cls.equals("kotlin.text.StringsKt")) {
                                    n = 1;
                                }
                                break;
                            }
                            case 1195259493: {
                                if (cls.equals("java.lang.String")) {
                                    n = 2;
                                }
                                break;
                            }
                            case -1081060161: {
                                if (cls.equals("kotlin.text.StringsKt__StringsJVMKt")) {
                                    n = 1;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 2: {
                                this.checkStringFormatCall(context2, method, node, method.getParameterList().getParametersCount() == 3 ? 1 : 0);
                                break;
                            }
                            case 1: {
                                this.checkStringFormatCall(context2, method, node, method.getParameterList().getParametersCount() == 4 ? 1 : 0);
                            }
                        }
                        break block22;
                    }
                    if (!Intrinsics.areEqual((Object)methodName, (Object)STRING_RESOURCE_METHOD)) break block24;
                    if (method.getParameterList().getParametersCount() == 2) {
                        String name;
                        PsiClass psiClass = method.getContainingClass();
                        String string4 = name = psiClass != null ? psiClass.getQualifiedName() : null;
                        if (Intrinsics.areEqual((Object)name, (Object)"androidx.compose.ui.res.StringResources_androidKt")) {
                            this.checkStringFormatCall(context2, method, node, 0);
                        }
                    }
                    break block22;
                }
                if (method.getParameterList().getParametersCount() < 2) {
                    return;
                }
                if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.res.Resources", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Context", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Fragment", false)) break block25;
                PsiMember psiMember = (PsiMember)method;
                String string5 = AndroidXConstants.CLASS_V4_FRAGMENT.oldName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"oldName(...)");
                if (evaluator.isMemberInSubClassOf(psiMember, string5, false)) break block25;
                PsiMember psiMember2 = (PsiMember)method;
                String string6 = AndroidXConstants.CLASS_V4_FRAGMENT.newName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"newName(...)");
                if (!evaluator.isMemberInSubClassOf(psiMember2, string6, false)) break block22;
            }
            this.checkStringFormatCall(context2, method, node, 0);
        }
    }

    private final boolean crossCheckResources(Context context2) {
        return context2.isEnabled(ARG_COUNT) || context2.isEnabled(INVALID) || context2.isEnabled(ARG_TYPES);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkStringFormatCall(JavaContext context, PsiMethod calledMethod, UCallExpression call, int argIndex) {
        block46: {
            args = call.getValueArguments();
            if (args.size() <= argIndex) {
                return;
            }
            argument = (UExpression)args.get(argIndex);
            resource = ResourceEvaluator.getResource(context.getEvaluator(), (UElement)argument);
            if (resource == null || resource.isFramework() || resource.type != ResourceType.STRING) {
                this.checkTrivialString(context, calledMethod, call, args, argIndex);
                return;
            }
            name = resource.name;
            if (this.mIgnoreStrings.contains(name)) {
                return;
            }
            passingVarArgsArray = false;
            callCount = args.size() - 1 - argIndex;
            if (callCount == 1) {
                lastArg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(args.size() - 1)));
                v0 = calledMethod.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getParameterList(...)");
                parameterList = v0;
                parameterCount = parameterList.getParametersCount();
                if (parameterCount > 0 && parameterList.getParameters()[parameterCount - 1].isVarArgs()) {
                    knownArity = false;
                    argWasReference = false;
                    if (lastArg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lastArg).resolve()) instanceof PsiVariable) {
                        initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                        if (initializer != null) {
                            initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                        }
                        if (initializer != null && (UastExpressionUtils.isNewArray((UElement)((UElement)initializer)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)initializer)))) {
                            argWasReference = true;
                            lastArg = initializer;
                        }
                    }
                    if (lastArg != null && (UastExpressionUtils.isNewArray((UElement)((UElement)lastArg)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)lastArg)))) {
                        arrayInitializer = (UCallExpression)lastArg;
                        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)((UElement)lastArg)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)lastArg))) {
                            callCount = arrayInitializer.getValueArgumentCount();
                            knownArity = true;
                        } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)((UElement)lastArg)) && (arrayDimensions = arrayInitializer.getValueArguments()).size() == 1 && (first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arrayDimensions.get(0)))) instanceof ULiteralExpression && (o = ((ULiteralExpression)first).getValue()) instanceof Integer) {
                            callCount = ((Number)o).intValue();
                            knownArity = true;
                        }
                        if (!knownArity) {
                            if (!argWasReference) {
                                return;
                            }
                        } else {
                            passingVarArgsArray = true;
                        }
                    }
                }
            }
            alreadyVisited = this.mFormatStrings.containsKey(name) != false || this.mNotFormatStrings.containsKey(name) != false;
            valueOnlyHandle = alreadyVisited == false;
            client = context.getClient();
            if (this.mStringsFromPsiCache.get(name) == null) {
                full = context.isGlobalAnalysis();
                project = full != false ? context.getMainProject() : context.getProject();
                resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, name);
                Intrinsics.checkNotNull((Object)items);
                o = items;
                $i$f$map = false;
                var21_30 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var26_39 = (ResourceItem)item$iv$iv;
                    var36_44 = destination$iv$iv;
                    $i$a$-map-StringFormatDetector$checkStringFormatCall$formatStrings$1 = false;
                    Intrinsics.checkNotNull((Object)name);
                    Intrinsics.checkNotNull((Object)it);
                    var36_44.add(this.resourceFormatString(name, (ResourceItem)it, resources));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (FormatString)element$iv$iv;
                    $i$a$-filter-StringFormatDetector$checkStringFormatCall$formatStrings$2 = false;
                    if (!(it.getType() != StringFormatType.IGNORE)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                formatStrings = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, checkStringFormatCall$lambda$3(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)I)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, checkStringFormatCall$lambda$2(com.android.tools.lint.checks.StringFormatDetector$FormatString com.android.tools.lint.checks.StringFormatDetector$FormatString ), (Lcom/android/tools/lint/checks/StringFormatDetector$FormatString;Lcom/android/tools/lint/checks/StringFormatDetector$FormatString;)Ljava/lang/Integer;)()));
                this.mStringsFromPsiCache.put(name, formatStrings);
                if (!alreadyVisited) {
                    v1 = context;
                    Intrinsics.checkNotNull((Object)name);
                    this.visitResourceItems(v1, name, formatStrings, valueOnlyHandle);
                }
            }
            if ((project = (Collection)(list = this.mStringsFromPsiCache.get(name))) == null || project.isEmpty() != false) break block46;
            if (callCount > 0) {
                for (FormatString item : list) {
                    found = false;
                    if (item.getType() == StringFormatType.NOT_FORMATTED) {
                        Intrinsics.checkNotNull((Object)name);
                        com.android.tools.lint.checks.StringFormatDetector$Companion.access$checkNotFormattedHandle(StringFormatDetector.Companion, context, call, name, item.createResourceItemHandle(context, valueOnlyHandle));
                        found = true;
                    }
                    if (!found) continue;
                    return;
                }
            }
            reported = null;
            block10: for (FormatString formatString : list) {
                if (formatString.getType() != StringFormatType.FORMATTED) continue;
                Intrinsics.checkNotNull((Object)formatString.getValue());
                if (reported != null && reported.contains(s)) continue;
                count = StringFormatDetector.Companion.getFormatArgumentCount(s, null);
                if (count != callCount) {
                    location = context.getLocation((UElement)call);
                    Intrinsics.checkNotNull((Object)formatString.createResourceItemHandle(context, valueOnlyHandle));
                    secondary = handle.resolve();
                    var24_36 = Locale.US;
                    element$iv$iv = "This definition requires %1$d argument%2$s";
                    it /* !! */  = new Object[]{count, count != 1 ? "s" : ""};
                    v2 = String.format(var24_36, (String)element$iv$iv, Arrays.copyOf(it /* !! */ , it /* !! */ .length));
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"format(...)");
                    secondary.setMessage(v2);
                    location.setSecondary(secondary);
                    element$iv$iv = Locale.US;
                    it /* !! */  = "Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`";
                    $i$a$-filter-StringFormatDetector$checkStringFormatCall$formatStrings$2 = new Object[]{name, count, callCount};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format((Locale)element$iv$iv, (String)it /* !! */ , Arrays.copyOf($i$a$-filter-StringFormatDetector$checkStringFormatCall$formatStrings$2, $i$a$-filter-StringFormatDetector$checkStringFormatCall$formatStrings$2.length)), (String)"format(...)");
                    JavaContext.report$default(context, StringFormatDetector.ARG_TYPES, (UElement)call, location, message, null, 16, null);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    v3 = reported;
                    Intrinsics.checkNotNull((Object)v3);
                    v3.add(s);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                i = 1;
                if (i > count) continue;
                while (true) {
                    block47: {
                        argumentIndex = i + argIndex;
                        expression = (UExpression)args.get(argumentIndex);
                        type = expression.getExpressionType();
                        if (this.isInStringExpression(call, expression)) {
                            type = this.getStringType(context, expression);
                        }
                        if (type == null || UastLintUtilsKt.isErroneous(type)) break block47;
                        valid = true;
                        if (StringFormatDetector.Companion.getFormatArgumentType(s, i) == null) break block47;
                        last = formatType.charAt(formatType.length() - 1);
                        if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') break block47;
                        switch (last) {
                            case 'B': 
                            case 'b': {
                                valid = StringFormatDetector.isBooleanType.invoke(type);
                                ** GOTO lbl158
                            }
                            case 'A': 
                            case 'E': 
                            case 'G': 
                            case 'X': 
                            case 'a': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'o': 
                            case 'x': {
                                valid = StringFormatDetector.isNumericOrBigNumberType.invoke(type);
                                ** GOTO lbl158
                            }
                            case 'C': 
                            case 'c': {
                                valid = StringFormatDetector.isCharacterType.invoke(type);
                                ** GOTO lbl158
                            }
                            case 'H': 
                            case 'h': {
                                break;
                            }
                            case 'S': 
                            case 's': {
                                valid = StringFormatDetector.isBooleanType.invoke(type) == false && StringFormatDetector.isNumericType.invoke(type) == false;
                            }
lbl158:
                            // 5 sources

                            default: {
                                if (valid) break;
                                location = context.getLocation((UElement)args.get(argumentIndex));
                                Intrinsics.checkNotNull((Object)formatString.createResourceItemHandle(context, valueOnlyHandle));
                                secondary = handle.resolve();
                                secondary.setMessage("Conflicting argument declaration here");
                                location.setSecondary(secondary);
                                if (com.android.tools.lint.checks.StringFormatDetector$Companion.access$isSuppressed(StringFormatDetector.Companion, context, StringFormatDetector.ARG_TYPES, secondary)) break;
                                suggestion = null;
                                if (StringFormatDetector.isBooleanType.invoke(type).booleanValue()) {
                                    suggestion = "`b`";
                                } else if (StringFormatDetector.isCharacterType.invoke(type).booleanValue()) {
                                    suggestion = "'c'";
                                } else if (StringFormatDetector.isIntType.invoke(type).booleanValue()) {
                                    suggestion = "`d`, 'o' or `x`";
                                } else if (StringFormatDetector.isFloatType.invoke(type).booleanValue()) {
                                    suggestion = "`e`, 'f', 'g' or `a`";
                                } else if (type instanceof PsiClassType && Intrinsics.areEqual((Object)((PsiClassType)type).getCanonicalText(), (Object)"java.lang.Object")) {
                                    suggestion = "'s' or 'h'";
                                }
                                suggestion = suggestion != null ? " (Did you mean formatting character " + (String)suggestion + "?)" : "";
                                v4 = type.getCanonicalText();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getCanonicalText(...)");
                                canonicalText = v4;
                                v5 = canonicalText.substring(StringsKt.lastIndexOf$default((CharSequence)canonicalText, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                                canonicalText = v5;
                                var33_50 = Locale.US;
                                var34_51 = "Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)%6$s";
                                var35_52 = new Object[]{i, name, formatType, canonicalText, argumentIndex + 1, suggestion};
                                Intrinsics.checkNotNullExpressionValue((Object)String.format(var33_50, var34_51, Arrays.copyOf(var35_52, var35_52.length)), (String)"format(...)");
                                if ((last == 's' || last == 'S') && StringFormatDetector.isNumericType.invoke(type).booleanValue()) {
                                    var33_50 = Locale.US;
                                    var34_51 = "Suspicious argument type for formatting argument #%1$d in `%2$s`: conversion is `%3$s`, received `%4$s` (argument #%5$d in method call)%6$s";
                                    var35_52 = new Object[]{i, name, formatType, canonicalText, argumentIndex + 1, suggestion};
                                    v6 = String.format(var33_50, var34_51, Arrays.copyOf(var35_52, var35_52.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"format(...)");
                                    message = v6;
                                }
                                JavaContext.report$default(context, StringFormatDetector.ARG_TYPES, (UElement)call, location, message, null, 16, null);
                                if (reported == null) {
                                    reported = Sets.newHashSet();
                                }
                                v7 = reported;
                                Intrinsics.checkNotNull((Object)v7);
                                v7.add(s);
                            }
                        }
                    }
                    if (i == count) continue block10;
                    ++i;
                }
            }
        }
    }

    private final FormatString resourceFormatString(String name, ResourceItem item, ResourceRepository resources) {
        ResourceValue resourceValue = item.getResourceValue();
        if (resourceValue == null) {
            return new FormatString(name, StringFormatType.IGNORE, null, null, 12, null);
        }
        ResourceValue v = resourceValue;
        String string2 = v.getRawXmlValue();
        if (string2 == null) {
            return new FormatString(name, StringFormatType.IGNORE, null, null, 12, null);
        }
        String value = string2;
        if (StringFormatDetector.Companion.isReference(value)) {
            ResourceUrl url;
            for (int i = 0; i < 3 && (url = ResourceUrl.parse((String)value)) != null && !url.isFramework(); ++i) {
                List l = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
                Intrinsics.checkNotNull((Object)l);
                if (!(!((Collection)l).isEmpty()) || (v = ((ResourceItem)l.get(0)).getResourceValue()) == null || (value = v.getValue()) == null || !StringFormatDetector.Companion.isReference(value)) break;
            }
        }
        if (value != null && !StringFormatDetector.Companion.isReference(value)) {
            boolean isFormattingString = StringsKt.indexOf$default((CharSequence)value, (char)'%', (int)0, (boolean)false, (int)6, null) != -1;
            int m = value.length();
            block5: for (int j = 0; j < m && isFormattingString; ++j) {
                char c = value.charAt(j);
                switch (c) {
                    case '\\': {
                        ++j;
                        continue block5;
                    }
                    case '%': {
                        Matcher matcher = FORMAT.matcher(value);
                        if (!matcher.find(j)) {
                            isFormattingString = false;
                        } else {
                            String conversion = matcher.group(6);
                            int conversionClass = StringFormatDetector.Companion.getConversionClass(conversion.charAt(0));
                            if (conversionClass == 0 || matcher.group(5) != null) {
                                return new FormatString(name, StringFormatType.IGNORE, null, null, 12, null);
                            }
                        }
                        ++j;
                    }
                }
            }
            return isFormattingString ? new FormatString(name, StringFormatType.FORMATTED, item, value) : new FormatString(name, StringFormatType.NOT_FORMATTED, item, null, 8, null);
        }
        return new FormatString(name, StringFormatType.IGNORE, null, null, 12, null);
    }

    private final void visitResourceItems(Context context2, String name, List<FormatString> strings, boolean valueOnlyHandle) {
        ArrayList<Pair> list2 = new ArrayList<Pair>();
        for (FormatString formatString : strings) {
            Location.Handle handle2;
            if (formatString.getType() == StringFormatType.FORMATTED) {
                Location.ResourceItemHandle resourceItemHandle = formatString.createResourceItemHandle(context2, valueOnlyHandle);
                Intrinsics.checkNotNull((Object)resourceItemHandle);
                handle2 = resourceItemHandle;
                String string2 = formatString.getValue();
                Intrinsics.checkNotNull((Object)string2);
                list2.add(TuplesKt.to((Object)handle2, (Object)string2));
                continue;
            }
            if (formatString.getType() != StringFormatType.NOT_FORMATTED) continue;
            Location.ResourceItemHandle resourceItemHandle = formatString.createResourceItemHandle(context2, valueOnlyHandle);
            Intrinsics.checkNotNull((Object)resourceItemHandle);
            handle2 = resourceItemHandle;
            list2.add(TuplesKt.to((Object)handle2, (Object)name));
        }
        if (context2.isEnabled(ARG_COUNT)) {
            StringFormatDetector.Companion.checkArity(context2, name, list2);
        }
        if (context2.isEnabled(INVALID) || context2.isEnabled(ARG_TYPES)) {
            StringFormatDetector.Companion.checkTypes(context2, context2.isEnabled(StringFormatDetector.INVALID), context2.isEnabled(StringFormatDetector.ARG_TYPES), name, list2);
        }
    }

    private final boolean isInStringExpression(UCallExpression call2, UExpression expression) {
        PsiElement psiElement = expression.getSourcePsi();
        if (psiElement == null) {
            return false;
        }
        PsiElement sourcePsi = psiElement;
        PsiElement psiElement2 = sourcePsi.getParent();
        KtStringTemplateEntry ktStringTemplateEntry = psiElement2 instanceof KtStringTemplateEntry ? (KtStringTemplateEntry)psiElement2 : null;
        if (ktStringTemplateEntry == null) {
            return false;
        }
        KtStringTemplateEntry parent = ktStringTemplateEntry;
        PsiElement stringElement = parent.getParent();
        PsiElement callPsi = call2.getSourcePsi();
        if (callPsi instanceof KtCallExpression) {
            for (KtValueArgument argument : ((KtCallExpression)callPsi).getValueArguments()) {
                KtExpression valueExpression = argument.getArgumentExpression();
                if (valueExpression != stringElement) continue;
                return true;
            }
        }
        return false;
    }

    private final PsiType getStringType(JavaContext context2, UExpression expression) {
        PsiElement psiElement = expression.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiClass javaLangClass = facade.findClass("java.lang.String", element.getResolveScope());
        return javaLangClass != null ? (PsiType)context2.getEvaluator().getClassType(javaLangClass) : null;
    }

    private final void checkTrivialString(JavaContext context2, PsiMethod calledMethod, UCallExpression call2, List<? extends UExpression> args, int stringIndex) {
        String string2 = ConstantEvaluator.evaluateString(context2, (UElement)args.get(stringIndex), false);
        if (string2 == null) {
            return;
        }
        String s = string2;
        boolean uppercase = false;
        int i = 1;
        int count = Companion.getFormatArgumentCount(s, null);
        if (i <= count) {
            while (true) {
                int argumentIndex;
                if ((argumentIndex = i + stringIndex) >= args.size()) {
                    return;
                }
                PsiType type = args.get(argumentIndex).getExpressionType();
                if (type != null) {
                    String formatType;
                    if (Companion.getFormatArgumentType(s, i) == null) {
                        return;
                    }
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') {
                        return;
                    }
                    switch (last) {
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'H': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'o': 
                        case 'x': {
                            return;
                        }
                        case 'B': 
                        case 'b': {
                            Language language = calledMethod.getLanguage();
                            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                            if (!Lint.isKotlin(language)) break;
                            return;
                        }
                    }
                    if (Companion.hasFormatArgumentModifiers(s, i)) {
                        return;
                    }
                    if (Character.isUpperCase(last)) {
                        uppercase = true;
                    }
                }
                if (i == count) break;
                ++i;
            }
        }
        Object message = "This formatting string is trivial. Rather than using `String.format` to create your String, it will be more performant to concatenate your arguments with `+`. ";
        if (uppercase) {
            message = (String)message + "If uppercase formatting is necessary, use `String.toUpperCase()`.";
        }
        JavaContext.report$default(context2, TRIVIAL, (UElement)call2, context2.getLocation((UElement)args.get(stringIndex)), (String)message, null, 16, null);
    }

    private final void checkArityAndTypes(XmlContext context2, Element element, StringFormatType formatType) {
        if (formatType == StringFormatType.FORMATTED || formatType == StringFormatType.NOT_FORMATTED) {
            Location.Handle defaultNotFormat;
            String name = element.getAttribute("name");
            ArrayList<Object> list2 = new ArrayList<Object>();
            Pair<Location.Handle, String> defaultFormat = this.mFormatStrings.get(name);
            if (defaultFormat != null) {
                list2.add(defaultFormat);
            }
            if ((defaultNotFormat = this.mNotFormatStrings.get(name)) != null) {
                list2.add(TuplesKt.to((Object)defaultNotFormat, (Object)name));
            }
            if (formatType == StringFormatType.FORMATTED) {
                list2.add(TuplesKt.to((Object)this.createLocationHandleForXmlDomElement(context2, element), (Object)element.getTextContent()));
            }
            if (formatType == StringFormatType.NOT_FORMATTED) {
                list2.add(TuplesKt.to((Object)this.createLocationHandleForXmlDomElement(context2, element), (Object)name));
            }
            if (context2.isEnabled(ARG_COUNT)) {
                Context context3 = context2;
                Intrinsics.checkNotNull((Object)name);
                StringFormatDetector.Companion.checkArity(context3, name, list2);
            }
            if (context2.isEnabled(INVALID) || context2.isEnabled(ARG_TYPES)) {
                Context context4 = context2;
                boolean bl = context2.isEnabled(INVALID);
                boolean bl2 = context2.isEnabled(ARG_TYPES);
                Intrinsics.checkNotNull((Object)name);
                StringFormatDetector.Companion.checkTypes(context4, bl, bl2, name, list2);
            }
        }
    }

    private static final int checkStringFormatCall$lambda$2(FormatString h1, FormatString h2) {
        Intrinsics.checkNotNullParameter((Object)h1, (String)"h1");
        Intrinsics.checkNotNullParameter((Object)h2, (String)"h2");
        ResourceItem resourceItem = h1.getResourceItem();
        Intrinsics.checkNotNull((Object)resourceItem);
        ResourceItem item1 = resourceItem;
        ResourceItem resourceItem2 = h2.getResourceItem();
        Intrinsics.checkNotNull((Object)resourceItem2);
        ResourceItem item2 = resourceItem2;
        FolderConfiguration f1 = item1.getConfiguration();
        FolderConfiguration f2 = item2.getConfiguration();
        int delta = f1.compareTo(f2);
        return delta != 0 ? delta : item1.toString().compareTo(item2.toString());
    }

    private static final int checkStringFormatCall$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @JvmStatic
    @NotNull
    public static final String stripQuotes(@NotNull String s) {
        return Companion.stripQuotes(s);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final String getFormatArgumentType(@NotNull String s, int argument) {
        return Companion.getFormatArgumentType(s, argument);
    }

    @JvmStatic
    public static final int getFormatArgumentCount(@NotNull String s, @Nullable Set<Integer> seenArguments) {
        return Companion.getFormatArgumentCount(s, seenArguments);
    }

    @JvmStatic
    public static final boolean isLocaleSpecific(@NotNull String format) {
        return Companion.isLocaleSpecific(format);
    }

    static {
        Object[] objectArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION_XML_AND_JAVA = new Implementation((Class<? extends Detector>)StringFormatDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.JAVA_FILE), (EnumSet<Scope>[])objectArray);
        INVALID = Issue.Companion.create("StringFormatInvalid", "Invalid format string", "\n          If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\n          This lint warning checks for two related problems:\n          (1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n          (2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\n          NOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.\n          ", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
        ARG_COUNT = Issue.Companion.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "\n          When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\n          There are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.\n          ", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
        TRIVIAL = Issue.Companion.create("StringFormatTrivial", "`String.format` string only contains trivial conversions", "Every call to `String.format` creates a new `Formatter` instance, which will decrease the performance of your app. `String.format` should only be used when necessary--if the formatted string contains only trivial conversions (e.g. `b`, `s`, `c`) and there are no translation concerns, it will be more efficient to replace them and concatenate with `+`.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION_XML_AND_JAVA).setAndroidSpecific(true).setEnabledByDefault(false);
        ARG_TYPES = Issue.Companion.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "\n          This lint check ensures the following:\n          (1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n          (2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.\n          ", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
        POTENTIAL_PLURAL = Issue.Companion.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n```xml\n  <string name=\"try_again\">Try again in %d seconds.</string>\n```\nyou should be using a plural:\n```xml\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\n```\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("https://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
        Pattern pattern = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        FORMAT = pattern;
        isCharacterType = new Companion.TypeTest(CollectionsKt.listOf((Object)PsiTypes.charType()), CollectionsKt.listOf((Object)"java.lang.Character"));
        isBooleanType = new Companion.TypeTest(CollectionsKt.listOf((Object)PsiTypes.booleanType()), CollectionsKt.listOf((Object)"java.lang.Boolean"));
        objectArray = new PsiPrimitiveType[]{PsiTypes.intType(), PsiTypes.longType(), PsiTypes.byteType(), PsiTypes.shortType()};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.Integer", "java.lang.Long", "java.lang.Byte", "java.lang.Short"};
        isIntType = new Companion.TypeTest(list2, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new PsiPrimitiveType[]{PsiTypes.floatType(), PsiTypes.doubleType()};
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.Float", "java.lang.Double"};
        isFloatType = new Companion.TypeTest(list3, CollectionsKt.listOf((Object[])objectArray));
        isNumericType = isIntType.or(isFloatType);
        objectArray = new String[]{"java.math.BigInteger", "java.math.BigDecimal"};
        isNumericOrBigNumberType = isNumericType.or(new Companion.TypeTest(CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\\B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J(\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002JB\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00102\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00100-0,H\u0002J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u000200H\u0002J0\u0010>\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001eH\u0002J4\u0010B\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00102\u001a\u0010+\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00100-\u0018\u00010,H\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\"\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020G0-0F2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001a\u0010I\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u001eH\u0007J \u0010K\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00102\u000e\u0010L\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010MH\u0007J\u0016\u0010N\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u001eJ\u0010\u0010O\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0010H\u0007J*\u0010Q\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\u0006\u0010*\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020D8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION_XML", "Lcom/android/tools/lint/detector/api/Implementation;", "IMPLEMENTATION_XML_AND_JAVA", "INVALID", "Lcom/android/tools/lint/detector/api/Issue;", "ARG_COUNT", "TRIVIAL", "getTRIVIAL", "()Lcom/android/tools/lint/detector/api/Issue;", "ARG_TYPES", "POTENTIAL_PLURAL", "STRING_RESOURCE_METHOD", "", "stripQuotes", "s", "isReference", "", "text", "checkTextNode", "Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "checkPotentialPlural", "wordBegin", "", "isSuppressed", "Lcom/android/tools/lint/detector/api/Context;", "issue", "source", "location", "Lcom/android/tools/lint/detector/api/Location;", "handle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "checkTypes", "", "checkValid", "name", "list", "", "Lkotlin/Pair;", "isIncompatible", "conversion1", "", "conversion2", "CONVERSION_CLASS_UNKNOWN", "CONVERSION_CLASS_STRING", "CONVERSION_CLASS_CHARACTER", "CONVERSION_CLASS_INTEGER", "CONVERSION_CLASS_FLOAT", "CONVERSION_CLASS_BOOLEAN", "CONVERSION_CLASS_HASHCODE", "CONVERSION_CLASS_PERCENT", "CONVERSION_CLASS_NEWLINE", "CONVERSION_CLASS_DATETIME", "getConversionClass", "conversion", "refineLocation", "formatString", "substringStart", "substringEnd", "checkArity", "FORMAT", "Ljava/util/regex/Pattern;", "getFormatArgumentSequence", "Lkotlin/sequences/Sequence;", "Ljava/util/regex/MatchResult;", "getFormatArgumentSequenceWithIndex", "getFormatArgumentType", "argument", "getFormatArgumentCount", "seenArguments", "", "hasFormatArgumentModifiers", "isLocaleSpecific", "format", "checkNotFormattedHandle", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "isCharacterType", "Lcom/android/tools/lint/checks/StringFormatDetector$Companion$TypeTest;", "isBooleanType", "isIntType", "isFloatType", "isNumericType", "isNumericOrBigNumberType", "TypeTest", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nStringFormatDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1580:1\n1179#2,2:1581\n1#3:1583\n1255#4,2:1584\n*S KotlinDebug\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector$Companion\n*L\n981#1:1581,2\n1509#1:1584,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getTRIVIAL() {
            return TRIVIAL;
        }

        @JvmStatic
        @NotNull
        public final String stripQuotes(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            StringBuilder sb = new StringBuilder();
            boolean isEscaped = false;
            boolean isQuotedBlock = false;
            CharSequence $this$forEach$iv = s;
            boolean $i$f$forEach = false;
            block4: for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char current = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                if (isEscaped) {
                    sb.append(current);
                    isEscaped = false;
                    continue;
                }
                isEscaped = current == '\\';
                switch (current) {
                    case '\"': {
                        isQuotedBlock = !isQuotedBlock;
                        break;
                    }
                    case '\'': {
                        if (!isQuotedBlock) continue block4;
                        sb.append(current);
                        break;
                    }
                    default: {
                        sb.append(current);
                    }
                }
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final boolean isReference(String text) {
            boolean bl;
            Character c;
            block3: {
                CharSequence charSequence = text;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char c2;
                    char it = c2 = charSequence.charAt(i);
                    boolean bl2 = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c = Character.valueOf(c2);
                    break block3;
                }
                c = null;
            }
            if (c != null) {
                char it = c.charValue();
                boolean bl3 = false;
                bl = it == '@' || it == '?';
            } else {
                bl = false;
            }
            return bl;
        }

        private final StringFormatType checkTextNode(XmlContext context2, Element element, String text) {
            boolean found = false;
            boolean foundPlural = false;
            int m = text.length();
            for (int j = 0; j < m; ++j) {
                char c = text.charAt(j);
                if (c == '\\') {
                    ++j;
                }
                if (c != '%') continue;
                String formatted = element.getAttribute("formatted");
                Intrinsics.checkNotNull((Object)formatted);
                if (((CharSequence)formatted).length() > 0 && !Boolean.parseBoolean(formatted)) {
                    return StringFormatType.NOT_FORMATTED;
                }
                Matcher matcher = FORMAT.matcher(text);
                if (!matcher.find(j)) {
                    return StringFormatType.NOT_FORMATTED;
                }
                String conversion = matcher.group(6);
                int conversionClass = this.getConversionClass(conversion.charAt(0));
                if (conversionClass == 0 || matcher.group(5) != null) {
                    return StringFormatType.IGNORE;
                }
                if (conversionClass == 3 && !foundPlural) {
                    for (int k = matcher.end(); k < m; ++k) {
                        char nc = text.charAt(k);
                        if (Character.isWhitespace(nc)) continue;
                        if (!Character.isLetter(nc)) break;
                        foundPlural = this.checkPotentialPlural(context2, element, text, k);
                        break;
                    }
                }
                found = true;
                ++j;
            }
            return found ? StringFormatType.FORMATTED : (!this.isReference(text) ? StringFormatType.NOT_FORMATTED : StringFormatType.IGNORE);
        }

        private final boolean checkPotentialPlural(XmlContext context2, Element element, String text, int wordBegin) {
            int wordEnd;
            boolean bl = Character.isLetter(text.charAt(wordBegin));
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
            }
            if (wordEnd - wordBegin <= 2) {
                return false;
            }
            boolean hasVowel = false;
            int n = wordEnd;
            for (int i = wordBegin; i < n; ++i) {
                char c = text.charAt(i);
                if (i > wordBegin && Character.isUpperCase(c)) {
                    return false;
                }
                switch (c) {
                    case 'a': 
                    case 'e': 
                    case 'i': 
                    case 'o': 
                    case 'u': 
                    case 'y': {
                        hasVowel = true;
                    }
                }
            }
            if (!hasVowel) {
                return false;
            }
            String string3 = text.substring(wordBegin, wordEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String word = string3;
            if (Intrinsics.areEqual((Object)word, (Object)"min")) {
                return false;
            }
            if (Lint.isEnglishResource(context2, true)) {
                String string4 = "Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string";
                Object[] objectArray = new Object[]{word};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                String message = string5;
                XmlContext.report$default(context2, POTENTIAL_PLURAL, element, context2.getLocation(element), message, null, 16, null);
                return true;
            }
            return false;
        }

        private final boolean isSuppressed(Context context2, Issue issue, Object source) {
            return source instanceof Node ? context2.getDriver().isSuppressed(null, issue, (Node)source) : false;
        }

        private final boolean isSuppressed(Context context2, Issue issue, Location location) {
            Object source = location.getSource();
            return this.isSuppressed(context2, issue, source);
        }

        private final boolean isSuppressed(Context context2, Issue issue, Location.Handle handle2) {
            Location.Handle handle3 = handle2;
            Intrinsics.checkNotNull((Object)handle3);
            Object source = handle3.getClientData();
            return this.isSuppressed(context2, issue, source) || handle2.isSuppressed(context2.getDriver(), issue);
        }

        private final void checkTypes(Context context2, boolean checkValid, boolean checkTypes, String name, List<? extends Pair<? extends Location.Handle, String>> list2) {
            Map types = new HashMap();
            Map typeDefinition = new HashMap();
            block0: for (Pair<? extends Location.Handle, String> pair2 : list2) {
                Location.Handle handle2 = (Location.Handle)pair2.component1();
                String formatString = (String)pair2.component2();
                for (Pair pair3 : this.getFormatArgumentSequenceWithIndex(formatString)) {
                    String message;
                    char last;
                    String str;
                    int number = ((Number)pair3.component1()).intValue();
                    MatchResult matcher = (MatchResult)pair3.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)formatString.substring(matcher.start(), matcher.end()), (String)"substring(...)");
                    if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                        String message2;
                        if (this.isSuppressed(context2, INVALID, handle2)) {
                            return;
                        }
                        Location location = handle2.resolve();
                        String string2 = "Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`'?";
                        Object[] objectArray = new Object[]{name, str};
                        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                        Context.report$default(context2, INVALID, location, message2, null, 8, null);
                        continue;
                    }
                    if (!checkTypes) continue;
                    String format = matcher.group(6);
                    String currentFormat = (String)types.get(number);
                    if (currentFormat == null) {
                        types.put(number, format);
                        typeDefinition.put(number, handle2);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)currentFormat, (Object)format) || !this.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                    if (this.isSuppressed(context2, ARG_TYPES, handle2)) {
                        return;
                    }
                    Location location = handle2.resolve();
                    if (this.isSuppressed(context2, ARG_TYPES, location)) {
                        return;
                    }
                    location = this.refineLocation(context2, location, formatString, matcher.start(), matcher.end());
                    Object v = typeDefinition.get(number);
                    Intrinsics.checkNotNull(v);
                    Location otherLocation = ((Location.Handle)v).resolve();
                    otherLocation.setMessage("Conflicting argument type (`" + currentFormat + "') here");
                    location.setSecondary(otherLocation);
                    File f = otherLocation.getFile();
                    Locale locale = Locale.US;
                    String string3 = "Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' here and '`%5$s`' in %6$s";
                    Object[] objectArray = new Object[]{number, name, str, format, currentFormat, Lint.getFileNameWithParent(context2.getClient(), f)};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                    Context.report$default(context2, ARG_TYPES, location, message, null, 8, null);
                    continue block0;
                }
            }
        }

        private final boolean isIncompatible(char conversion1, char conversion2) {
            int class2;
            int class1 = this.getConversionClass(conversion1);
            return class1 != (class2 = this.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
        }

        private final int getConversionClass(char conversion) {
            switch (conversion) {
                case 'T': 
                case 't': {
                    return 9;
                }
                case 'S': 
                case 's': {
                    return 1;
                }
                case 'C': 
                case 'c': {
                    return 2;
                }
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return 3;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return 4;
                }
                case 'B': 
                case 'b': {
                    return 5;
                }
                case 'H': 
                case 'h': {
                    return 6;
                }
                case '%': {
                    return 7;
                }
                case 'n': {
                    return 8;
                }
            }
            return 0;
        }

        private final Location refineLocation(Context context2, Location location, String formatString, int substringStart, int substringEnd) {
            Position startLocation = location.getStart();
            Position endLocation = location.getEnd();
            if (startLocation != null && endLocation != null) {
                int formatOffset;
                CharSequence contents;
                int startOffset = startLocation.getOffset();
                int endOffset = endLocation.getOffset();
                if (startOffset >= 0 && endOffset <= (contents = context2.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = CharSequences.indexOf((CharSequence)contents, (CharSequence)formatString, (int)startOffset)) != -1 && formatOffset <= endOffset) {
                    return Location.Companion.create(location.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
                }
            }
            return location;
        }

        private final void checkArity(Context context2, String name, List<? extends Pair<? extends Location.Handle, String>> list2) {
            int prevCount = -1;
            List<? extends Pair<? extends Location.Handle, String>> list3 = list2;
            Intrinsics.checkNotNull(list3);
            for (Pair<? extends Location.Handle, String> pair2 : list3) {
                Object[] objectArray;
                String string2;
                Set indices = new HashSet();
                int count = this.getFormatArgumentCount((String)pair2.getSecond(), indices);
                Location.Handle handle2 = (Location.Handle)pair2.getFirst();
                if (prevCount != -1 && prevCount != count) {
                    if (this.isSuppressed(context2, ARG_COUNT, handle2)) {
                        return;
                    }
                    Location location = handle2.resolve();
                    if (this.isSuppressed(context2, ARG_COUNT, location)) {
                        return;
                    }
                    Location secondary = ((Location.Handle)list2.get(0).getFirst()).resolve();
                    if (this.isSuppressed(context2, ARG_COUNT, secondary)) {
                        return;
                    }
                    secondary.setMessage("Conflicting number of arguments (" + prevCount + ") here");
                    location.setSecondary(secondary);
                    String path = Lint.getFileNameWithParent(context2.getClient(), secondary.getFile());
                    Locale locale = Locale.US;
                    string2 = "Inconsistent number of arguments in formatting string `%1$s`; found both %2$d here and %3$d in %4$s";
                    objectArray = new Object[]{name, count, prevCount, path};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    String message = string3;
                    Context.report$default(context2, ARG_COUNT, location, message, null, 8, null);
                    break;
                }
                int i = 1;
                if (i <= count) {
                    while (true) {
                        if (!indices.contains(i)) {
                            String message;
                            if (this.isSuppressed(context2, ARG_COUNT, handle2)) {
                                return;
                            }
                            Set all2 = new HashSet();
                            for (int j = 1; j < count; ++j) {
                                all2.add(j);
                            }
                            all2.removeAll(indices);
                            List sorted = CollectionsKt.sorted((Iterable)new ArrayList(all2));
                            Location location = handle2.resolve();
                            string2 = "Formatting string '`%1$s`' is not referencing numbered arguments %2$s";
                            objectArray = new Object[]{name, sorted};
                            Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                            Context.report$default(context2, ARG_COUNT, location, message, null, 8, null);
                            break;
                        }
                        if (i == count) break;
                        ++i;
                    }
                }
                prevCount = count;
            }
        }

        private final Sequence<MatchResult> getFormatArgumentSequence(String s) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MatchResult>, Continuation<? super Unit>, Object>(s, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            matcher = StringFormatDetector.FORMAT.matcher(this.$s);
                            index = 0;
lbl8:
                            // 2 sources

                            while (matcher.find(index)) {
                                it = matcher.group(6);
                                $i$a$-let-StringFormatDetector$Companion$getFormatArgumentSequence$1$1 = false;
                                v0 = Intrinsics.areEqual((Object)it, (Object)"%") || Intrinsics.areEqual((Object)it, (Object)"n");
                                if (!v0) ** GOTO lbl16
                                v1 = matcher.end();
                                ** GOTO lbl41
lbl16:
                                // 1 sources

                                if (0 > matcher.start() - 1 || this.$s.charAt(matcher.start() - 1) != '\\') ** GOTO lbl19
                                v1 = matcher.start() + 1;
                                ** GOTO lbl41
lbl19:
                                // 1 sources

                                var5_6 = Boxing.boxInt((int)matcher.end());
                                ((Number)var5_6).intValue();
                                $i$a$-also-StringFormatDetector$Companion$getFormatArgumentSequence$1$2 = false;
                                Intrinsics.checkNotNull((Object)matcher);
                                this.L$0 = $this$sequence;
                                this.L$1 = matcher;
                                this.L$2 = var5_6;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)matcher, (Continuation)this);
                                if (v2 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl40
                            }
                            break;
                        }
                        case 1: {
                            $i$a$-also-StringFormatDetector$Companion$getFormatArgumentSequence$1$2 = false;
                            var5_6 = (Integer)this.L$2;
                            matcher = (Matcher)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl40:
                            // 2 sources

                            v1 = ((Number)var5_6).intValue();
lbl41:
                            // 3 sources

                            index = v1;
                            ** GOTO lbl8
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super MatchResult> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final Sequence<Pair<Integer, MatchResult>> getFormatArgumentSequenceWithIndex(String s) {
            Ref.IntRef nextNumber = new Ref.IntRef();
            nextNumber.element = 1;
            return SequencesKt.map(this.getFormatArgumentSequence(s), arg_0 -> Companion.getFormatArgumentSequenceWithIndex$lambda$4(nextNumber, arg_0));
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final String getFormatArgumentType(@NotNull String s, int argument) {
            String string2;
            Object v0;
            Pair pair2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                pair2 = this.getFormatArgumentSequenceWithIndex(s);
                for (Object e : pair2) {
                    Pair pair3 = (Pair)e;
                    boolean bl = false;
                    int number = ((Number)pair3.component1()).intValue();
                    if (!(number == argument)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            Pair pair4 = v0;
            if (pair4 != null) {
                pair2 = pair4;
                boolean bl = false;
                MatchResult matcher = (MatchResult)pair2.component2();
                string2 = matcher.group(6);
            } else {
                string2 = null;
            }
            return string2;
        }

        @JvmStatic
        public final int getFormatArgumentCount(@NotNull String s, @Nullable Set<Integer> seenArguments) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map(this.getFormatArgumentSequenceWithIndex(s), Companion::getFormatArgumentCount$lambda$7), arg_0 -> Companion.getFormatArgumentCount$lambda$8(seenArguments, arg_0)));
            return n != null ? n : 0;
        }

        public final boolean hasFormatArgumentModifiers(@NotNull String s, int argument) {
            boolean bl;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                Sequence<Pair<Integer, MatchResult>> sequence2 = this.getFormatArgumentSequenceWithIndex(s);
                for (Object e : sequence2) {
                    Pair pair2 = (Pair)e;
                    boolean bl2 = false;
                    int number = ((Number)pair2.component1()).intValue();
                    if (!(number == argument)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            Pair pair3 = v0;
            if (pair3 != null) {
                Iterator iterator = pair3;
                boolean bl3 = false;
                MatchResult matcher = (MatchResult)iterator.component2();
                CharSequence charSequence = matcher.group(2);
                bl = !((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)matcher.group(3)) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)matcher.group(4)) == null || charSequence.length() == 0));
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isLocaleSpecific(@NotNull String format) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Sequence<MatchResult> $this$any$iv = this.getFormatArgumentSequence(format);
            boolean $i$f$any = false;
            Iterator iterator = $this$any$iv.iterator();
            do {
                Character c;
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                MatchResult matcher = (MatchResult)element$iv;
                boolean bl2 = false;
                String string2 = matcher.group(6);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                Character c2 = c = StringsKt.firstOrNull((CharSequence)string2);
                char c3 = 'd';
                if (c2 != null) {
                    if (c2.charValue() == c3) return true;
                }
                Character c4 = c;
                c3 = 'e';
                if (c4 != null) {
                    if (c4.charValue() == c3) return true;
                }
                Character c5 = c;
                c3 = 'E';
                if (c5 != null) {
                    if (c5.charValue() == c3) return true;
                }
                Character c6 = c;
                c3 = 'f';
                if (c6 != null) {
                    if (c6.charValue() == c3) return true;
                }
                Character c7 = c;
                c3 = 'g';
                if (c7 != null) {
                    if (c7.charValue() == c3) return true;
                }
                Character c8 = c;
                c3 = 'G';
                if (c8 != null) {
                    if (c8.charValue() == c3) return true;
                }
                Character c9 = c;
                c3 = 't';
                if (c9 != null) {
                    if (c9.charValue() == c3) return true;
                }
                Character c10 = c;
                c3 = 'T';
                if (c10 != null && c10.charValue() == c3) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final void checkNotFormattedHandle(JavaContext context2, UCallExpression call2, String name, Location.Handle handle2) {
            if (this.isSuppressed((Context)context2, INVALID, handle2)) {
                return;
            }
            Location location = context2.getLocation((UElement)call2);
            Location.Handle handle3 = handle2;
            Intrinsics.checkNotNull((Object)handle3);
            Location secondary = handle3.resolve();
            secondary.setMessage("This definition does not require arguments");
            location.setSecondary(secondary);
            String string2 = "Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`";
            Object[] objectArray = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String message = string3;
            JavaContext.report$default(context2, INVALID, (UElement)call2, location, message, null, 16, null);
        }

        private static final Pair getFormatArgumentSequenceWithIndex$lambda$4(Ref.IntRef $nextNumber, MatchResult matcher) {
            int n;
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            String numberString = matcher.group(1);
            if (numberString == null) {
                var4_3 = $nextNumber.element;
                $nextNumber.element = var4_3 + 1;
                n = var4_3;
            } else {
                String string2 = numberString.substring(0, numberString.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int it = var4_3 = Integer.parseInt(string2);
                boolean bl = false;
                $nextNumber.element = it + 1;
                n = var4_3;
            }
            int number = n;
            return TuplesKt.to((Object)number, (Object)matcher);
        }

        private static final int getFormatArgumentCount$lambda$7(Pair pair2) {
            Intrinsics.checkNotNullParameter((Object)pair2, (String)"<destruct>");
            int number = ((Number)pair2.component1()).intValue();
            return number;
        }

        private static final Unit getFormatArgumentCount$lambda$8(Set $seenArguments, int it) {
            block0: {
                Set set2 = $seenArguments;
                if (set2 == null) break block0;
                set2.add(it);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$checkNotFormattedHandle(Companion $this, JavaContext context2, UCallExpression call2, String name, Location.Handle handle2) {
            $this.checkNotFormattedHandle(context2, call2, name, handle2);
        }

        public static final /* synthetic */ boolean access$isSuppressed(Companion $this, Context context2, Issue issue, Location location) {
            return $this.isSuppressed(context2, issue, location);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$Companion$TypeTest;", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiType;", "", "prims", "", "tags", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "invoke", "t", "(Lcom/intellij/psi/PsiType;)Ljava/lang/Boolean;", "or", "that", "android.sdktools.lint-checks"})
        private static final class TypeTest
        implements Function1<PsiType, Boolean> {
            @NotNull
            private final List<PsiType> prims;
            @NotNull
            private final List<String> tags;

            public TypeTest(@NotNull List<? extends PsiType> prims, @NotNull List<String> tags) {
                Intrinsics.checkNotNullParameter(prims, (String)"prims");
                Intrinsics.checkNotNullParameter(tags, (String)"tags");
                this.prims = prims;
                this.tags = tags;
            }

            @NotNull
            public Boolean invoke(@NotNull PsiType t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return this.prims.contains(t) || t instanceof PsiClassType && this.tags.contains(t.getCanonicalText());
            }

            @NotNull
            public final TypeTest or(@NotNull TypeTest that) {
                Intrinsics.checkNotNullParameter((Object)that, (String)"that");
                return new TypeTest(CollectionsKt.plus((Collection)this.prims, (Iterable)that.prims), CollectionsKt.plus((Collection)this.tags, (Iterable)that.tags));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$FormatString;", "", "name", "", "type", "Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;", "resourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "value", "<init>", "(Ljava/lang/String;Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;Lcom/android/ide/common/resources/ResourceItem;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;", "getResourceItem", "()Lcom/android/ide/common/resources/ResourceItem;", "getValue", "createResourceItemHandle", "Lcom/android/tools/lint/detector/api/Location$ResourceItemHandle;", "context", "Lcom/android/tools/lint/detector/api/Context;", "valueOnly", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
    public static final class FormatString {
        @NotNull
        private final String name;
        @NotNull
        private final StringFormatType type;
        @Nullable
        private final ResourceItem resourceItem;
        @Nullable
        private final String value;

        public FormatString(@NotNull String name, @NotNull StringFormatType type, @Nullable ResourceItem resourceItem, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.name = name;
            this.type = type;
            this.resourceItem = resourceItem;
            this.value = value;
        }

        public /* synthetic */ FormatString(String string2, StringFormatType stringFormatType, ResourceItem resourceItem, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                resourceItem = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(string2, stringFormatType, resourceItem, string3);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final StringFormatType getType() {
            return this.type;
        }

        @Nullable
        public final ResourceItem getResourceItem() {
            return this.resourceItem;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final Location.ResourceItemHandle createResourceItemHandle(@NotNull Context context2, boolean valueOnly) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.resourceItem != null ? context2.getClient().createResourceItemHandle(this.resourceItem, false, valueOnly) : null;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final StringFormatType component2() {
            return this.type;
        }

        @Nullable
        public final ResourceItem component3() {
            return this.resourceItem;
        }

        @Nullable
        public final String component4() {
            return this.value;
        }

        @NotNull
        public final FormatString copy(@NotNull String name, @NotNull StringFormatType type, @Nullable ResourceItem resourceItem, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new FormatString(name, type, resourceItem, value);
        }

        public static /* synthetic */ FormatString copy$default(FormatString formatString, String string2, StringFormatType stringFormatType, ResourceItem resourceItem, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = formatString.name;
            }
            if ((n & 2) != 0) {
                stringFormatType = formatString.type;
            }
            if ((n & 4) != 0) {
                resourceItem = formatString.resourceItem;
            }
            if ((n & 8) != 0) {
                string3 = formatString.value;
            }
            return formatString.copy(string2, stringFormatType, resourceItem, string3);
        }

        @NotNull
        public String toString() {
            return "FormatString(name=" + this.name + ", type=" + this.type + ", resourceItem=" + this.resourceItem + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + (this.resourceItem == null ? 0 : this.resourceItem.hashCode());
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FormatString)) {
                return false;
            }
            FormatString formatString = (FormatString)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)formatString.name)) {
                return false;
            }
            if (this.type != formatString.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.resourceItem, (Object)formatString.resourceItem)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)formatString.value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$StringFormatType;", "", "<init>", "(Ljava/lang/String;I)V", "FORMATTED", "NOT_FORMATTED", "IGNORE", "android.sdktools.lint-checks"})
    public static final class StringFormatType
    extends Enum<StringFormatType> {
        public static final /* enum */ StringFormatType FORMATTED = new StringFormatType();
        public static final /* enum */ StringFormatType NOT_FORMATTED = new StringFormatType();
        public static final /* enum */ StringFormatType IGNORE = new StringFormatType();
        private static final /* synthetic */ StringFormatType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StringFormatType[] values() {
            return (StringFormatType[])$VALUES.clone();
        }

        public static StringFormatType valueOf(String value) {
            return Enum.valueOf(StringFormatType.class, value);
        }

        @NotNull
        public static EnumEntries<StringFormatType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stringFormatTypeArray = new StringFormatType[]{StringFormatType.FORMATTED, StringFormatType.NOT_FORMATTED, StringFormatType.IGNORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StringFormatType.values().length];
            try {
                nArray[StringFormatType.IGNORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringFormatType.FORMATTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringFormatType.NOT_FORMATTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

