/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class StateListDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("StateListReachable", "Unreachable state in a `<selector>`", "In a selector, only the last child in the state list should omit a state qualifier. If not, all subsequent items in the list will be ignored since the given item will match all.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(StateListDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String STATE_PREFIX = "state_";

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.DRAWABLE;
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        Element root2 = document.getDocumentElement();
        if (root2 != null && root2.getTagName().equals("selector")) {
            List<Element> children = Lint.getChildren(root2);
            HashMap states = Maps.newHashMapWithExpectedSize((int)children.size());
            for (Element child : children) {
                NamedNodeMap attributes = child.getAttributes();
                HashSet<CallSite> stateNames = new HashSet<CallSite>(attributes.getLength());
                states.put(child, stateNames);
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Attr attribute = (Attr)attributes.item(j);
                    String name = attribute.getLocalName();
                    if (name == null) continue;
                    if (name.startsWith(STATE_PREFIX)) {
                        stateNames.add((CallSite)((Object)(name + "=" + attribute.getValue())));
                        continue;
                    }
                    String namespaceUri = attribute.getNamespaceURI();
                    if (namespaceUri == null || namespaceUri.isEmpty() || "http://schemas.android.com/apk/res/android".equals(namespaceUri)) continue;
                    stateNames.add((CallSite)((Object)(attribute.getName() + "=" + attribute.getValue())));
                }
            }
            for (int i = 0; i < children.size() - 1; ++i) {
                Element prev = children.get(i);
                Set prevStates = (Set)states.get(prev);
                assert (prevStates != null) : prev;
                for (int j = i + 1; j < children.size(); ++j) {
                    Element current = children.get(j);
                    Set currentStates = (Set)states.get(current);
                    assert (currentStates != null) : current;
                    if (!currentStates.containsAll(prevStates)) continue;
                    Location location = context2.getLocation(current);
                    Location secondary = context2.getLocation(prev);
                    secondary.setMessage("Earlier item which masks item");
                    location.setSecondary(secondary);
                    context2.report(ISSUE, current, location, String.format("This item is unreachable because a previous item (item #%1$d) is a more general match than this one", i + 1));
                    return;
                }
            }
        }
    }
}

