/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/ServiceCastDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkWifiService", "call", "checkContextReference", "", "element", "Lorg/jetbrains/uast/UElement;", "checkWifiContextType", "type", "Lcom/intellij/psi/PsiType;", "flagPlainContext", "reportWifiServiceLeak", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isClipboard", "cls", "stripPackage", "fqcn", "Companion", "android.sdktools.lint-checks"})
public final class ServiceCastDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ServiceCastDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final Issue WIFI_MANAGER;
    @JvmField
    @NotNull
    public static final Issue WIFI_MANAGER_UNCERTAIN;
    @NotNull
    private static final String GET_APPLICATION_CONTEXT = "getApplicationContext";
    @NotNull
    private static final String WIFI_SERVICE = "WIFI_SERVICE";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getSystemService");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        UElement parent;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List args = node.getValueArguments();
        if (args.size() != 1) {
            return;
        }
        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)));
        UReferenceExpression uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
        if (uReferenceExpression == null) {
            return;
        }
        UReferenceExpression argument = uReferenceExpression;
        PsiElement psiElement = argument.resolve();
        PsiField psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
        if (psiField == null) {
            return;
        }
        PsiField resolvedServiceConst = psiField;
        String string2 = resolvedServiceConst.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        if (Intrinsics.areEqual((Object)WIFI_SERVICE, (Object)name)) {
            this.checkWifiService(context2, node);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)node)).getUastParent())) != null && UastExpressionUtils.isTypeCast((UElement)parent)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)parent;
            String expectedClass = Companion.getExpectedType(name);
            if (expectedClass != null) {
                String string3 = cast.getType().getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalText(...)");
                String castType = string3;
                if (StringsKt.indexOf$default((CharSequence)castType, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                    expectedClass = this.stripPackage(expectedClass);
                }
                if (!Intrinsics.areEqual((Object)castType, (Object)expectedClass)) {
                    String expected;
                    if (this.isClipboard(castType) && this.isClipboard(expectedClass)) {
                        return;
                    }
                    String actual = this.stripPackage(castType);
                    if (Intrinsics.areEqual((Object)actual, (Object)(expected = this.stripPackage(expectedClass))) && StringsKt.contains$default((CharSequence)expectedClass, (CharSequence)".", (boolean)false, (int)2, null)) {
                        actual = castType;
                        expected = expectedClass;
                    }
                    String message = "Suspicious cast to `" + actual + "` for a `" + name + "`: expected `" + expected + "`";
                    JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)cast), message, null, 16, null);
                }
            }
        }
    }

    private final void checkWifiService(JavaContext context2, UCallExpression call2) {
        JavaEvaluator evaluator = context2.getEvaluator();
        UExpression qualifier = call2.getReceiver();
        PsiMethod resolvedMethod = call2.resolve();
        if (resolvedMethod != null && (evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.app.Activity", false) || evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.view.View", false))) {
            this.reportWifiServiceLeak(WIFI_MANAGER, context2, call2);
            return;
        }
        if (qualifier == null) {
            PsiMethod currentMethod;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)call2), UMethod.class, (boolean)true);
            Object object = currentMethod = uMethod != null ? uMethod.getJavaPsi() : null;
            if (currentMethod != null && !evaluator.isMemberInSubClassOf((PsiMember)currentMethod, "android.app.Application", true)) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call2);
            }
        } else {
            this.checkContextReference(context2, (UElement)qualifier, call2);
        }
    }

    private final boolean checkContextReference(JavaContext context2, UElement element, UCallExpression call2) {
        if (element == null) {
            return false;
        }
        if (element instanceof UCallExpression) {
            PsiMethod resolvedMethod = ((UCallExpression)element).resolve();
            if (resolvedMethod != null && !Intrinsics.areEqual((Object)GET_APPLICATION_CONTEXT, (Object)resolvedMethod.getName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call2);
                return true;
            }
        } else if (element instanceof UQualifiedReferenceExpression) {
            PsiElement resolved = ((UQualifiedReferenceExpression)element).resolve();
            if (resolved instanceof PsiMethod && !Intrinsics.areEqual((Object)GET_APPLICATION_CONTEXT, (Object)((UQualifiedReferenceExpression)element).getResolvedName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call2);
                return true;
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiField) {
                PsiType psiType = ((PsiField)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                return this.checkWifiContextType(context2, call2, type, true);
            }
            if (resolved instanceof PsiParameter) {
                PsiType psiType = ((PsiParameter)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                return this.checkWifiContextType(context2, call2, type, true);
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiType psiType = ((PsiLocalVariable)resolved).getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                if (!type.isValid()) {
                    return false;
                }
                if (this.checkWifiContextType(context2, call2, type, false)) {
                    return true;
                }
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)call2);
                if (lastAssignment != null) {
                    return this.checkContextReference(context2, (UElement)lastAssignment, call2);
                }
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.checkContextReference(context2, (UElement)((UParenthesizedExpression)element).getExpression(), call2);
        }
        return false;
    }

    private final boolean checkWifiContextType(JavaContext context2, UCallExpression call2, PsiType type, boolean flagPlainContext) {
        PsiClass psiClass;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (type instanceof PsiClassType && evaluator.extendsClass(psiClass = ((PsiClassType)type).resolve(), "android.app.Application", false)) {
            return false;
        }
        if (evaluator.typeMatches(type, "android.content.Context")) {
            if (flagPlainContext) {
                this.reportWifiServiceLeak(WIFI_MANAGER_UNCERTAIN, context2, call2);
                return true;
            }
            return false;
        }
        this.reportWifiServiceLeak(WIFI_MANAGER, context2, call2);
        return true;
    }

    private final void reportWifiServiceLeak(Issue issue, JavaContext context2, UCallExpression call2) {
        if (context2.getProject().getMinSdk() >= 24) {
            return;
        }
        Object message = "The WIFI_SERVICE must be looked up on the Application context or memory will leak on devices < Android N. ";
        LintFix fix2 = null;
        if (call2.getReceiver() != null) {
            UExpression uExpression = call2.getReceiver();
            Intrinsics.checkNotNull((Object)uExpression);
            qualifier = uExpression.asSourceString();
            message = (String)message + "Try changing `" + qualifier + "` to `" + qualifier + ".getApplicationContext()`";
            fix2 = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with(qualifier + ".getApplicationContext()").build();
        } else {
            qualifier = Lint.getMethodName(call2);
            message = (String)message + "Try changing `" + qualifier + "` to `getApplicationContext()." + qualifier + "`";
            fix2 = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with("getApplicationContext()." + qualifier).build();
        }
        Incident incident = new Incident(issue, call2, context2.getLocation((UElement)call2), (String)message, fix2);
        context2.report(incident, Constraints.minSdkLessThan(24));
    }

    private final boolean isClipboard(String cls) {
        return Intrinsics.areEqual((Object)cls, (Object)"android.content.ClipboardManager") || Intrinsics.areEqual((Object)cls, (Object)"android.text.ClipboardManager");
    }

    private final String stripPackage(String fqcn) {
        return StringsKt.substringAfterLast$default((String)fqcn, (char)'.', null, (int)2, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "ServiceCast", "Wrong system service casts", "\n          When you call `Context#getSystemService()`, the result is typically cast to \\\n          a specific interface. This lint check ensures that the cast is compatible with \\\n          the expected type of the return value.\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        WIFI_MANAGER = Issue.Companion.create$default(companion, "WifiManagerLeak", "WifiManager Leak", "\n          On versions prior to Android N (24), initializing the `WifiManager` via \\\n          `Context#getSystemService` can cause a memory leak if the context is not \\\n          the application context. Change `context.getSystemService(...)` to \\\n          `context.getApplicationContext().getSystemService(...)`.\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        WIFI_MANAGER_UNCERTAIN = Issue.Companion.create$default(companion, "WifiManagerPotentialLeak", "WifiManager Potential Leak", "\n          On versions prior to Android N (24), initializing the `WifiManager` \\\n          via `Context#getSystemService` can cause a memory leak if the context \\\n          is not the application context.\n\n          In many cases, it's not obvious from the code where the `Context` is \\\n          coming from (e.g. it might be a parameter to a method, or a field \\\n          initialized from various method calls). It's possible that the context \\\n          being passed in is the application context, but to be on the safe side, \\\n          you should consider changing `context.getSystemService(...)` to \\\n          `context.getApplicationContext().getSystemService(...)`.\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/ServiceCastDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WIFI_MANAGER", "WIFI_MANAGER_UNCERTAIN", "GET_APPLICATION_CONTEXT", "", "WIFI_SERVICE", "getExpectedType", "value", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @VisibleForTesting
        @Nullable
        public final String getExpectedType(@Nullable String value) {
            if (value == null) {
                return null;
            }
            return switch (value) {
                case "ACCESSIBILITY_SERVICE" -> "android.view.accessibility.AccessibilityManager";
                case "ACCOUNT_SERVICE" -> "android.accounts.AccountManager";
                case "ACTIVITY_SERVICE" -> "android.app.ActivityManager";
                case "ALARM_SERVICE" -> "android.app.AlarmManager";
                case "APPWIDGET_SERVICE" -> "android.appwidget.AppWidgetManager";
                case "APP_OPS_SERVICE" -> "android.app.AppOpsManager";
                case "APP_SEARCH_SERVICE" -> "android.app.appsearch.AppSearchManager";
                case "AUDIO_SERVICE" -> "android.media.AudioManager";
                case "BATTERY_SERVICE" -> "android.os.BatteryManager";
                case "BIOMETRIC_SERVICE" -> "android.hardware.biometrics.BiometricManager";
                case "BLOB_STORE_SERVICE" -> "android.app.blob.BlobStoreManager";
                case "BLUETOOTH_SERVICE" -> "android.bluetooth.BluetoothManager";
                case "CAMERA_SERVICE" -> "android.hardware.camera2.CameraManager";
                case "CAPTIONING_SERVICE" -> "android.view.accessibility.CaptioningManager";
                case "CARRIER_CONFIG_SERVICE" -> "android.telephony.CarrierConfigManager";
                case "CLIPBOARD_SERVICE" -> "android.text.ClipboardManager";
                case "COMPANION_DEVICE_SERVICE" -> "android.companion.CompanionDeviceManager";
                case "CONNECTIVITY_DIAGNOSTICS_SERVICE" -> "android.net.ConnectivityDiagnosticsManager";
                case "CONNECTIVITY_SERVICE" -> "android.net.ConnectivityManager";
                case "CONSUMER_IR_SERVICE" -> "android.hardware.ConsumerIrManager";
                case "CONTACT_KEYS_SERVICE" -> "android.provider.E2eeContactKeysManager";
                case "CREDENTIAL_SERVICE" -> "android.credentials.CredentialManager";
                case "CROSS_PROFILE_APPS_SERVICE" -> "android.content.pm.CrossProfileApps";
                case "DEVICE_LOCK_SERVICE" -> "android.devicelock.DeviceLockManager";
                case "DEVICE_POLICY_SERVICE" -> "android.app.admin.DevicePolicyManager";
                case "DISPLAY_HASH_SERVICE" -> "android.view.displayhash.DisplayHashManager";
                case "DISPLAY_SERVICE" -> "android.hardware.display.DisplayManager";
                case "DOMAIN_VERIFICATION_SERVICE" -> "android.content.pm.verify.domain.DomainVerificationManager";
                case "DOWNLOAD_SERVICE" -> "android.app.DownloadManager";
                case "DROPBOX_SERVICE" -> "android.os.DropBoxManager";
                case "EUICC_SERVICE" -> "android.telephony.euicc.EuiccManager";
                case "FILE_INTEGRITY_SERVICE" -> "android.security.FileIntegrityManager";
                case "FINGERPRINT_SERVICE" -> "android.hardware.fingerprint.FingerprintManager";
                case "GAME_SERVICE" -> "android.app.GameManager";
                case "GRAMMATICAL_INFLECTION_SERVICE" -> "android.app.GrammaticalInflectionManager";
                case "HARDWARE_PROPERTIES_SERVICE" -> "android.os.HardwarePropertiesManager";
                case "HEALTHCONNECT_SERVICE" -> "android.health.connect.HealthConnectManager";
                case "INPUT_METHOD_SERVICE" -> "android.view.inputmethod.InputMethodManager";
                case "INPUT_SERVICE" -> "android.hardware.input.InputManager";
                case "IPSEC_SERVICE" -> "android.net.IpSecManager";
                case "JOB_SCHEDULER_SERVICE" -> "android.app.job.JobScheduler";
                case "KEYGUARD_SERVICE" -> "android.app.KeyguardManager";
                case "LAUNCHER_APPS_SERVICE" -> "android.content.pm.LauncherApps";
                case "LAYOUT_INFLATER_SERVICE" -> "android.view.LayoutInflater";
                case "LOCALE_SERVICE" -> "android.app.LocaleManager";
                case "LOCATION_SERVICE" -> "android.location.LocationManager";
                case "MEDIA_COMMUNICATION_SERVICE" -> "android.media.MediaCommunicationManager";
                case "MEDIA_METRICS_SERVICE" -> "android.media.metrics.MediaMetricsManager";
                case "MEDIA_PROJECTION_SERVICE" -> "android.media.projection.MediaProjectionManager";
                case "MEDIA_ROUTER_SERVICE" -> "android.media.MediaRouter";
                case "MEDIA_SESSION_SERVICE" -> "android.media.session.MediaSessionManager";
                case "MIDI_SERVICE" -> "android.media.midi.MidiManager";
                case "NETWORK_STATS_SERVICE" -> "android.app.usage.NetworkStatsManager";
                case "NFC_SERVICE" -> "android.nfc.NfcManager";
                case "NOTIFICATION_SERVICE" -> "android.app.NotificationManager";
                case "NSD_SERVICE" -> "android.net.nsd.NsdManager";
                case "OVERLAY_SERVICE" -> "android.content.om.OverlayManager";
                case "PEOPLE_SERVICE" -> "android.app.people.PeopleManager";
                case "PERFORMANCE_HINT_SERVICE" -> "android.os.PerformanceHintManager";
                case "PERSISTENT_DATA_BLOCK_SERVICE" -> "android.service.persistentdata.PersistentDataBlockManager";
                case "POWER_SERVICE" -> "android.os.PowerManager";
                case "PRINT_SERVICE" -> "android.print.PrintManager";
                case "PROFILING_SERVICE" -> "android.os.ProfilingManager";
                case "RESTRICTIONS_SERVICE" -> "android.content.RestrictionsManager";
                case "ROLE_SERVICE" -> "android.app.role.RoleManager";
                case "SEARCH_SERVICE" -> "android.app.SearchManager";
                case "SECURITY_STATE_SERVICE" -> "android.os.SecurityStateManager";
                case "SENSOR_SERVICE" -> "android.hardware.SensorManager";
                case "SHORTCUT_SERVICE" -> "android.content.pm.ShortcutManager";
                case "STATUS_BAR_SERVICE" -> "android.app.StatusBarManager";
                case "STORAGE_SERVICE" -> "android.os.storage.StorageManager";
                case "STORAGE_STATS_SERVICE" -> "android.app.usage.StorageStatsManager";
                case "SYSTEM_HEALTH_SERVICE" -> "android.os.health.SystemHealthManager";
                case "TELECOM_SERVICE" -> "android.telecom.TelecomManager";
                case "TELEPHONY_IMS_SERVICE" -> "android.telephony.ims.ImsManager";
                case "TELEPHONY_SERVICE" -> "android.telephony.TelephonyManager";
                case "TELEPHONY_SUBSCRIPTION_SERVICE" -> "android.telephony.SubscriptionManager";
                case "TEXT_CLASSIFICATION_SERVICE" -> "android.view.textclassifier.TextClassificationManager";
                case "TEXT_SERVICES_MANAGER_SERVICE" -> "android.view.textservice.TextServicesManager";
                case "TV_AD_SERVICE" -> "android.media.tv.ad.TvAdManager";
                case "TV_INPUT_SERVICE" -> "android.media.tv.TvInputManager";
                case "TV_INTERACTIVE_APP_SERVICE" -> "android.media.tv.interactive.TvInteractiveAppManager";
                case "UI_MODE_SERVICE" -> "android.app.UiModeManager";
                case "USAGE_STATS_SERVICE" -> "android.app.usage.UsageStatsManager";
                case "USB_SERVICE" -> "android.hardware.usb.UsbManager";
                case "USER_SERVICE" -> "android.os.UserManager";
                case "VIBRATOR_MANAGER_SERVICE" -> "android.os.VibratorManager";
                case "VIBRATOR_SERVICE" -> "android.os.Vibrator";
                case "VIRTUAL_DEVICE_SERVICE" -> "android.companion.virtual.VirtualDeviceManager";
                case "VPN_MANAGEMENT_SERVICE" -> "android.net.VpnManager";
                case "WALLPAPER_SERVICE" -> "android.app.WallpaperManager";
                case "WIFI_AWARE_SERVICE" -> "android.net.wifi.aware.WifiAwareManager";
                case "WIFI_P2P_SERVICE" -> "android.net.wifi.p2p.WifiP2pManager";
                case "WIFI_RTT_RANGING_SERVICE" -> "android.net.wifi.rtt.WifiRttManager";
                case ServiceCastDetector.WIFI_SERVICE -> "android.net.wifi.WifiManager";
                case "WINDOW_SERVICE" -> "android.view.WindowManager";
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

