/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/HighSensorSamplingRateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class HighSensorSamplingRateDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HIGHER_SENSOR_SAMPLING_RATE = "android.permission.HIGH_SAMPLING_RATE_SENSORS";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("HighSamplingRate", "High sensor sampling rate", "\n                Most apps don't need access to high sensor sampling rate. Double check your use \\\n                case to ensure your app absolutely needs access to sensor sampling rate > 200Hz. \\\n                Be prepared for your app to be rejected from listing on Play Store until your use \\\n                case for high sensor sampling rate has been reviewed and validated by the policy \\\n                team.\n            ", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(HighSensorSamplingRateDetector.class, Scope.MANIFEST_SCOPE));

    @NotNull
    public Set<String> getApplicableElements() {
        return SetsKt.setOf((Object)"uses-permission");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (!Intrinsics.areEqual((Object)name, (Object)HIGHER_SENSOR_SAMPLING_RATE)) {
            return;
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"getAttributeNodeNS(...)");
        context2.report(new Incident(ISSUE, context2.getValueLocation(attr), "Most apps don't need access to high sensor sampling rate."), Constraints.targetSdkAtLeast(31));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/HighSensorSamplingRateDetector$Companion;", "", "<init>", "()V", "HIGHER_SENSOR_SAMPLING_RATE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

