/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/CustomViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class CustomViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    @NotNull
    private static final String WITH_STYLED_ATTRIBUTES = "withStyledAttributes";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{OBTAIN_STYLED_ATTRIBUTES, WITH_STYLED_ATTRIBUTES};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List arguments = node.getValueArguments();
        int size = arguments.size();
        int parameterIndex = 0;
        if (Intrinsics.areEqual((Object)method.getName(), (Object)OBTAIN_STYLED_ATTRIBUTES)) {
            if (!context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.content.Context", false)) {
                return;
            }
            parameterIndex = size == 1 ? 0 : 1;
        } else {
            if (!context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, "androidx.core.content.ContextKt", false)) {
                return;
            }
            parameterIndex = 2;
        }
        UExpression uExpression = node.getArgumentForParameter(parameterIndex);
        if (uExpression == null) {
            return;
        }
        UExpression expression = uExpression;
        ResourceReference reference = ResourceReference.Companion.get((UElement)expression);
        if (reference == null || reference.getType() != ResourceType.STYLEABLE) {
            return;
        }
        UClass uClass = (UClass)UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)false);
        if (uClass == null) {
            return;
        }
        UClass cls = uClass;
        String className = cls.getName();
        String styleableName = reference.getName();
        PsiClass psiClass = cls.getJavaPsi();
        if (context2.getEvaluator().extendsClass(psiClass, "android.view.View", false)) {
            if (!Intrinsics.areEqual((Object)styleableName, (Object)className)) {
                String message = "By convention, the custom view (`" + className + "`) and the declare-styleable (`" + styleableName + "`) should have the same name (various editor features rely on this convention)";
                JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)expression), message, null, 16, null);
            }
        } else if (context2.getEvaluator().extendsClass(psiClass, "android.view.ViewGroup.LayoutParams", false)) {
            UClass uClass2 = (UClass)UastUtils.getParentOfType((UElement)((UElement)cls), UClass.class, (boolean)true);
            if (uClass2 == null) {
                return;
            }
            UClass outer = uClass2;
            String layoutClassName = outer.getName();
            String expectedName = layoutClassName + "_Layout";
            if (!Intrinsics.areEqual((Object)styleableName, (Object)expectedName)) {
                String message = "By convention, the declare-styleable (`" + styleableName + "`) for a layout parameter class (`" + className + "`) is expected to be the surrounding class (`" + layoutClassName + "`) plus \"`_Layout`\", e.g. `" + expectedName + "`. (Various editor features rely on this convention.)";
                JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)expression), message, null, 16, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "CustomViewStyleable", "Mismatched Styleable/Custom View Name", "\n          The convention for custom views is to use a `declare-styleable` whose \\\n          name matches the custom view class name. The IDE relies on this convention \\\n          such that for example code completion can be offered for attributes \\\n          in a custom view in layout XML resource files.\n\n          (Similarly, layout parameter classes should use the suffix `_Layout`.)\n          ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/CustomViewDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "OBTAIN_STYLED_ATTRIBUTES", "", "WITH_STYLED_ATTRIBUTES", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

