/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.parser;

import com.android.tools.leakcanarylib.data.LeakTraceNodeType;
import com.android.tools.leakcanarylib.data.LeakingStatus;
import com.android.tools.leakcanarylib.data.Node;
import com.android.tools.leakcanarylib.parser.ReferencingFieldParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/leakcanarylib/parser/NodeParser;", "", "<init>", "()V", "Companion", "android.sdktools.leakcanarylib"})
public final class NodeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex leakingStatusRegex = new Regex("Leaking: (YES|NO|UNKNOWN)(?: \\((.*)\\))?");
    @NotNull
    private static final Regex leakingStatusMultiLineRegex = new Regex("Leaking:\\s*(YES|NO|UNKNOWN)\\s*\\((.*)");
    @NotNull
    private static final Regex retainingRegex = new Regex("Retaining (\\d+(?:\\.\\d+)?)\\s*(\\w+)?B? in (\\d+) objects");

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ,\u0010\u0011\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/leakcanarylib/parser/NodeParser$Companion;", "", "<init>", "()V", "leakingStatusRegex", "Lkotlin/text/Regex;", "leakingStatusMultiLineRegex", "retainingRegex", "parse", "Lcom/android/tools/leakcanarylib/data/Node;", "inputLines", "", "", "firstLinePrefix", "additionalLinesPrefix", "multiLinePrefix", "referenceLinePrefix", "parseLeakNode", "isClassTypeExist", "", "line", "getByteSize", "", "size", "unit", "android.sdktools.leakcanarylib"})
    @SourceDebugExtension(value={"SMAP\nNodeParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeParser.kt\ncom/android/tools/leakcanarylib/parser/NodeParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1563#2:213\n1634#2,3:214\n360#2,7:217\n1#3:224\n*S KotlinDebug\n*F\n+ 1 NodeParser.kt\ncom/android/tools/leakcanarylib/parser/NodeParser$Companion\n*L\n54#1:213\n54#1:214,3\n56#1:217,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Node parse(@NotNull List<String> inputLines, @NotNull String firstLinePrefix, @NotNull String additionalLinesPrefix, @NotNull String multiLinePrefix, @NotNull String referenceLinePrefix) {
            int n;
            List lines;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(inputLines, (String)"inputLines");
                Intrinsics.checkNotNullParameter((Object)firstLinePrefix, (String)"firstLinePrefix");
                Intrinsics.checkNotNullParameter((Object)additionalLinesPrefix, (String)"additionalLinesPrefix");
                Intrinsics.checkNotNullParameter((Object)multiLinePrefix, (String)"multiLinePrefix");
                Intrinsics.checkNotNullParameter((Object)referenceLinePrefix, (String)"referenceLinePrefix");
                Iterable $this$map$iv = inputLines;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                List $this$indexOfFirst$iv = lines = (List)destination$iv$iv;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)referenceLinePrefix, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int firstReferenceLineIndex = n;
            Pair pair2 = firstReferenceLineIndex == -1 ? new Pair((Object)lines, (Object)CollectionsKt.emptyList()) : new Pair(lines.subList(0, firstReferenceLineIndex), lines.subList(firstReferenceLineIndex, lines.size()));
            List objectLines = (List)pair2.component1();
            List referenceLines = (List)pair2.component2();
            Node leakingNode = this.parseLeakNode(objectLines, firstLinePrefix, multiLinePrefix, additionalLinesPrefix);
            leakingNode.setReferencingField(ReferencingFieldParser.Companion.parseReferencingField(referenceLines, additionalLinesPrefix));
            return leakingNode;
        }

        @NotNull
        public final Node parseLeakNode(@NotNull List<String> inputLines, @NotNull String firstLinePrefix, @NotNull String multiLinePrefix, @NotNull String additionalLinesPrefix) {
            Intrinsics.checkNotNullParameter(inputLines, (String)"inputLines");
            Intrinsics.checkNotNullParameter((Object)firstLinePrefix, (String)"firstLinePrefix");
            Intrinsics.checkNotNullParameter((Object)multiLinePrefix, (String)"multiLinePrefix");
            Intrinsics.checkNotNullParameter((Object)additionalLinesPrefix, (String)"additionalLinesPrefix");
            Object className = null;
            LeakTraceNodeType type = null;
            LeakingStatus leakingStatus = null;
            String leakingStatusReason = "";
            Integer retainedHeapByteSize = null;
            Integer retainedObjectCount = null;
            boolean leakingMultiLine = false;
            boolean isClassTypeFound = false;
            StringBuilder leakingStatusReasonBuilder = new StringBuilder();
            List notes = new ArrayList();
            for (String line : inputLines) {
                MatchResult matchResult;
                Object it;
                List parts;
                Object object;
                String formattedLine;
                if (StringsKt.startsWith$default((String)line, (String)firstLinePrefix, (boolean)false, (int)2, null)) {
                    formattedLine = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)firstLinePrefix))).toString();
                    isClassTypeFound = this.isClassTypeExist(formattedLine);
                    if (isClassTypeFound) {
                        LeakTraceNodeType leakTraceNodeType;
                        object = new String[]{" "};
                        parts = StringsKt.split$default((CharSequence)formattedLine, (String[])object, (boolean)false, (int)0, (int)6, null);
                        className = (String)CollectionsKt.getOrNull((List)parts, (int)0);
                        if ((Object)CollectionsKt.lastOrNull((List)parts) != null) {
                            boolean bl = false;
                            String string2 = ((String)it).toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                            leakTraceNodeType = LeakTraceNodeType.valueOf(string2);
                        } else {
                            leakTraceNodeType = null;
                        }
                        type = leakTraceNodeType;
                        continue;
                    }
                    className = formattedLine;
                    continue;
                }
                if (!isClassTypeFound) {
                    formattedLine = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)multiLinePrefix))).toString();
                    isClassTypeFound = this.isClassTypeExist(formattedLine);
                    if (isClassTypeFound) {
                        LeakTraceNodeType leakTraceNodeType;
                        object = new String[]{" "};
                        parts = StringsKt.split$default((CharSequence)formattedLine, (String[])object, (boolean)false, (int)0, (int)6, null);
                        className = (String)className + (parts.size() > 1 ? (String)parts.get(0) : "");
                        object = (String)CollectionsKt.lastOrNull((List)parts);
                        if (object != null) {
                            it = object;
                            boolean bl = false;
                            String string3 = ((String)it).toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                            leakTraceNodeType = LeakTraceNodeType.valueOf(string3);
                        } else {
                            leakTraceNodeType = null;
                        }
                        type = leakTraceNodeType;
                        continue;
                    }
                    className = (String)className + formattedLine;
                    continue;
                }
                if (leakingStatusRegex.matches((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix))) {
                    Intrinsics.checkNotNull((Object)Regex.find$default((Regex)leakingStatusRegex, (CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix), (int)0, (int)2, null));
                    leakingStatus = LeakingStatus.Companion.fromString((String)matchResult.getGroupValues().get(1));
                    leakingStatusReason = (String)matchResult.getGroupValues().get(2);
                    continue;
                }
                if (leakingStatusMultiLineRegex.matches((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix))) {
                    Intrinsics.checkNotNull((Object)Regex.find$default((Regex)leakingStatusMultiLineRegex, (CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix), (int)0, (int)2, null));
                    leakingStatus = LeakingStatus.Companion.fromString((String)matchResult.getGroupValues().get(1));
                    leakingStatusReasonBuilder.append(((Object)StringsKt.trim((CharSequence)((String)matchResult.getGroupValues().get(2)))).toString());
                    leakingMultiLine = true;
                    continue;
                }
                if (leakingMultiLine) {
                    leakingStatusReasonBuilder.append(" ").append(StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix));
                    leakingMultiLine = !StringsKt.endsWith$default((String)line, (String)")", (boolean)false, (int)2, null);
                    if (leakingMultiLine) continue;
                    String string4 = leakingStatusReasonBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    leakingStatusReason = StringsKt.dropLast((String)((Object)StringsKt.trimEnd((CharSequence)string4)).toString(), (int)1);
                    continue;
                }
                if (retainingRegex.matches((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix))) {
                    Intrinsics.checkNotNull((Object)Regex.find$default((Regex)retainingRegex, (CharSequence)StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix), (int)0, (int)2, null));
                    MatchResult.Destructured destructured = matchResult.getDestructured();
                    String sizeString = (String)destructured.getMatch().getGroupValues().get(1);
                    String unit = (String)destructured.getMatch().getGroupValues().get(2);
                    String countString = (String)destructured.getMatch().getGroupValues().get(3);
                    retainedHeapByteSize = (int)this.getByteSize(Double.parseDouble(sizeString), unit);
                    retainedObjectCount = Integer.parseInt(countString);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line, (String)additionalLinesPrefix, (boolean)false, (int)2, null)) continue;
                notes.add(StringsKt.removePrefix((String)line, (CharSequence)additionalLinesPrefix));
            }
            if (type == null) {
                boolean $i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$62 = false;
                String $i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$62 = "Invalid object type";
                throw new IllegalArgumentException($i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$62.toString());
            }
            if (className == null) {
                boolean $i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$72 = false;
                String $i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$72 = "Class name not found";
                throw new IllegalArgumentException($i$a$-requireNotNull-NodeParser$Companion$parseLeakNode$72.toString());
            }
            if (leakingStatus == null) {
                boolean bl = false;
                String string5 = "Leaking status not found";
                throw new IllegalArgumentException(string5.toString());
            }
            return new Node(type, (String)className, leakingStatus, leakingStatusReason, retainedHeapByteSize, retainedObjectCount, notes, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isClassTypeExist(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (((CharSequence)line).length() == 0) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Object object = CollectionsKt.last((List)parts);
            String string2 = "INSTANCE".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)object, (Object)string2)) return true;
            Object object2 = CollectionsKt.last((List)parts);
            String string3 = "CLASS".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)object2, (Object)string3)) return true;
            Object object3 = CollectionsKt.last((List)parts);
            String string4 = "ARRAY".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)object3, (Object)string4)) return false;
            return true;
        }

        private final double getByteSize(double size, String unit) {
            String string2 = unit.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return size * (switch (string2) {
                case "KB" -> 1000.0;
                case "MB" -> 1000000.0;
                case "GB" -> 1.0E9;
                case "TB" -> 1.0E12;
                case "PB" -> 1.0E15;
                default -> 1.0;
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

