/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.parser;

import com.android.tools.leakcanarylib.data.GcRootType;
import com.android.tools.leakcanarylib.data.LeakTrace;
import com.android.tools.leakcanarylib.data.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/leakcanarylib/parser/LeakTraceParser;", "", "<init>", "()V", "Companion", "android.sdktools.leakcanarylib"})
public final class LeakTraceParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GC_ROOT_PREFIX = "GC Root:";
    @NotNull
    private static final String REFERENCE_PREFIX = "\u251c\u2500 ";
    @NotNull
    private static final String LEAKING_OBJECT_PREFIX = "Leaking Object";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J&\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/leakcanarylib/parser/LeakTraceParser$Companion;", "", "<init>", "()V", "GC_ROOT_PREFIX", "", "REFERENCE_PREFIX", "LEAKING_OBJECT_PREFIX", "parseLeakTrace", "Lcom/android/tools/leakcanarylib/data/LeakTrace;", "lines", "", "prefixReferencePath", "prefixLeakingObject", "parseLeakTraces", "Lkotlin/Pair;", "", "leakLines", "parseTraceCount", "line", "extractGcRootType", "Lcom/android/tools/leakcanarylib/data/GcRootType;", "extractReferencePathLines", "pathPrefix", "objectPrefix", "extractLeakingObjectLines", "parseReferenceNodes", "Lcom/android/tools/leakcanarylib/data/Node;", "prefix", "android.sdktools.leakcanarylib"})
    @SourceDebugExtension(value={"SMAP\nLeakTraceParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakTraceParser.kt\ncom/android/tools/leakcanarylib/parser/LeakTraceParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n360#2,7:178\n360#2,7:185\n360#2,7:192\n360#2,7:199\n967#2,7:206\n756#2,10:213\n*S KotlinDebug\n*F\n+ 1 LeakTraceParser.kt\ncom/android/tools/leakcanarylib/parser/LeakTraceParser$Companion\n*L\n103#1:178,7\n124#1:185,7\n125#1:192,7\n140#1:199,7\n142#1:206,7\n144#1:213,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LeakTrace parseLeakTrace(@NotNull List<String> lines, @NotNull String prefixReferencePath, @NotNull String prefixLeakingObject) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)prefixReferencePath, (String)"prefixReferencePath");
            Intrinsics.checkNotNullParameter((Object)prefixLeakingObject, (String)"prefixLeakingObject");
            GcRootType gcRootType = this.extractGcRootType(lines);
            List nodes = new ArrayList();
            List<String> referenceLines = this.extractReferencePathLines(lines, prefixReferencePath, prefixLeakingObject);
            nodes.addAll((Collection)this.parseReferenceNodes(referenceLines, prefixReferencePath));
            List<String> objectLines = this.extractLeakingObjectLines(lines, prefixLeakingObject);
            nodes.add(Node.Companion.fromString(CollectionsKt.joinToString$default((Iterable)objectLines, (CharSequence)"\n", null, null, (int)0, null, Companion::parseLeakTrace$lambda$0, (int)30, null)));
            return new LeakTrace(gcRootType, nodes);
        }

        @NotNull
        public final Pair<List<LeakTrace>, Integer> parseLeakTraces(@NotNull List<String> leakLines) {
            Object v1;
            List<String> list2;
            int leakTraceCount;
            List leakTraces;
            block4: {
                Object object;
                Object object22;
                block3: {
                    Intrinsics.checkNotNullParameter(leakLines, (String)"leakLines");
                    leakTraces = new ArrayList();
                    Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)leakLines);
                    for (Object object22 : iterable) {
                        int it = ((Number)object22).intValue();
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)leakLines.get(it), (String)"Displaying only", (boolean)false, (int)2, null)) continue;
                        object = object22;
                        break block3;
                    }
                    object = null;
                }
                Integer lineCount = (Integer)object;
                leakTraceCount = lineCount == null ? 1 : this.parseTraceCount(leakLines.get(lineCount));
                object22 = (Iterable)CollectionsKt.getIndices((Collection)leakLines);
                list2 = leakLines;
                Object object3 = object22;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    int it = ((Number)t).intValue();
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)leakLines.get(it), (String)"Signature:", (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            Integer n = v1;
            List<String> lines = list2.subList(n != null ? n : 0, leakLines.size());
            if (lines.isEmpty()) {
                return new Pair((Object)leakTraces, (Object)leakTraceCount);
            }
            LeakTrace leakTrace = LeakTrace.Companion.fromString(CollectionsKt.joinToString$default((Iterable)lines.subList(1, lines.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            leakTraces.add(leakTrace);
            return new Pair((Object)leakTraces, (Object)leakTraceCount);
        }

        private final int parseTraceCount(String line) {
            Regex regex = new Regex("Displaying only 1 leak trace out of (\\d+) with the same signature");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null);
            Object object = matchResult;
            if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return 0;
            }
            return (Integer)object;
        }

        private final GcRootType extractGcRootType(List<String> lines) {
            int gcRootIndex;
            block3: {
                int n;
                List<String> $this$indexOfFirst$iv = lines;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String item$iv;
                    String it = item$iv = iterator.next();
                    boolean bl = false;
                    if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (CharSequence)LeakTraceParser.GC_ROOT_PREFIX, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = gcRootIndex = -1;
            }
            if (gcRootIndex == -1) {
                throw new IllegalArgumentException("Invalid leak trace format: GC Root not found");
            }
            String gcRootDescription = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)lines.get(gcRootIndex), (String)":", null, (int)2, null))).toString();
            return GcRootType.Companion.fromDescription(gcRootDescription);
        }

        private final List<String> extractReferencePathLines(List<String> lines, String pathPrefix, String objectPrefix) {
            int endIndex;
            int startIndex;
            block5: {
                int n;
                int n2;
                block4: {
                    List<String> $this$indexOfFirst$iv = lines;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        String item$iv;
                        String it = item$iv = iterator.next();
                        boolean bl = false;
                        if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (CharSequence)pathPrefix, (boolean)false, (int)2, null)) {
                            n2 = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                startIndex = n2;
                List<String> $this$indexOfFirst$iv = lines;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String item$iv;
                    String it = item$iv = iterator.next();
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)objectPrefix, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = endIndex = -1;
            }
            return (0 <= startIndex ? startIndex < endIndex : false) ? lines.subList(startIndex, endIndex) : CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> extractLeakingObjectLines(List<String> lines, String objectPrefix) {
            void $this$dropWhile$iv;
            int n;
            block5: {
                List<String> $this$indexOfFirst$iv = lines;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String it = string2 = iterator.next();
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)objectPrefix, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int referencePathEndIndex = n;
            List<String> linesAfterReferences = lines.subList(referencePathEndIndex, lines.size());
            Iterable $this$takeWhile$iv = linesAfterReferences;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                String line = (String)item$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)LeakTraceParser.REFERENCE_PREFIX, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)LeakTraceParser.GC_ROOT_PREFIX, (boolean)false, (int)2, null))) break;
                list$iv.add(item$iv);
            }
            $this$takeWhile$iv = list$iv;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList arrayList = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    arrayList.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() == 0) continue;
                arrayList.add(item$iv);
                yielding$iv = true;
            }
            return arrayList;
        }

        private final List<Node> parseReferenceNodes(List<String> lines, String prefix) {
            List referenceNodes = new ArrayList();
            List currentReferenceLines = new ArrayList();
            for (String line : lines) {
                if (StringsKt.startsWith$default((String)line, (String)prefix, (boolean)false, (int)2, null) && !((Collection)currentReferenceLines).isEmpty()) {
                    referenceNodes.add(Node.Companion.fromString(CollectionsKt.joinToString$default((Iterable)currentReferenceLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
                    currentReferenceLines.clear();
                }
                currentReferenceLines.add(((Object)StringsKt.trimStart((CharSequence)line)).toString());
            }
            if (!((Collection)currentReferenceLines).isEmpty()) {
                referenceNodes.add(Node.Companion.fromString(CollectionsKt.joinToString$default((Iterable)currentReferenceLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
            }
            return referenceNodes;
        }

        private static final CharSequence parseLeakTrace$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)StringsKt.trim((CharSequence)it)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

