/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.Installer;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LiveUpdateDeployer {
    private final ILogger logger;

    public LiveUpdateDeployer(ILogger logger) {
        this.logger = logger;
    }

    public List<UpdateLiveEditError> updateLiveLiteral(Installer installer, AdbClient adb, String packageName, Collection<UpdateLiveLiteralParam> params) {
        List<Integer> pids = adb.getPids(packageName);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveLiteralUpdateRequest.Builder requestBuilder = Deploy.LiveLiteralUpdateRequest.newBuilder();
        for (UpdateLiveLiteralParam param : params) {
            requestBuilder.addUpdates(Deploy.LiveLiteral.newBuilder().setKey(param.key).setOffset(param.offset).setHelperClass(param.helper).setType(param.type).setValue(param.value));
        }
        requestBuilder.setPackageName(packageName);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.LiveLiteralUpdateRequest request2 = requestBuilder.build();
        LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
        try {
            Deploy.LiveLiteralUpdateResponse response = installer.updateLiveLiterals(request2);
            for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                errors.add(new UpdateLiveEditError(failure.getLiveLiteralResponse().getExtra()));
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, Arrays.toString(errors.toArray()), new Object[0]);
        }
        return errors;
    }

    public UpdateLiveEditResult updateLiveEdit(Installer installer, AdbClient adb, String packageName, UpdateLiveEditsParam param) {
        ByteString data;
        List<Integer> pids = adb.getPids(packageName);
        if (pids.isEmpty()) {
            System.out.println("Cancelling LiveEdit request(No target pids)");
            LinkedList<UpdateLiveEditError> error2 = new LinkedList<UpdateLiveEditError>();
            error2.add(new UpdateLiveEditError("No target pids to Live Edit"));
            return new UpdateLiveEditResult(error2);
        }
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveEditRequest.Builder requestBuilder = Deploy.LiveEditRequest.newBuilder();
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        requestBuilder.setPackageName(packageName);
        requestBuilder.setInvalidateMode(param.invalidateMode);
        requestBuilder.addAllGroupIds(param.groupIds);
        for (String name : param.classes.keySet()) {
            data = ByteString.copyFrom((byte[])param.classes.get(name));
            requestBuilder.addTargetClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        for (String name : param.classes.keySet()) {
            data = ByteString.copyFrom((byte[])param.classes.get(name));
            requestBuilder.addTargetClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        requestBuilder.addAllGroupIds(param.groupIds);
        for (String name : param.classes.keySet()) {
            data = ByteString.copyFrom((byte[])param.classes.get(name));
            requestBuilder.addTargetClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        for (String name : param.supportClasses.keySet()) {
            data = ByteString.copyFrom((byte[])param.supportClasses.get(name));
            requestBuilder.addSupportClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        requestBuilder.setDebugModeEnabled(param.debugModeEnabled);
        requestBuilder.setStructuralRedefinition(param.useStructuralRedefinition);
        Deploy.LiveEditRequest request2 = requestBuilder.build();
        UpdateLiveEditResult result2 = null;
        try {
            LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
            Deploy.LiveEditResponse response = installer.liveEdit(request2);
            Deploy.AgentLiveEditResponse.RecomposeType recomposeType = Deploy.AgentLiveEditResponse.RecomposeType.NONE;
            if (response.getStatus() == Deploy.LiveEditResponse.Status.AGENT_ERROR) {
                for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                    failure.getLeResponse().getErrorsList().forEach(error -> errors.add(new UpdateLiveEditError((Deploy.UnsupportedChange)error)));
                }
            }
            if (response.getStatus() == Deploy.LiveEditResponse.Status.OK) {
                for (Deploy.AgentResponse success : response.getSuccessAgentsList()) {
                    if (!success.hasLeResponse()) {
                        throw new RuntimeException("Live Edit response does not contain agent response object");
                    }
                    Deploy.AgentLiveEditResponse ler = success.getLeResponse();
                    recomposeType = ler.getRecomposeType();
                }
            } else {
                errors.add(new UpdateLiveEditError(response.getStatus().toString()));
            }
            result2 = new UpdateLiveEditResult(errors, recomposeType);
        }
        catch (IOException e) {
            result2 = new UpdateLiveEditResult(Collections.singletonList(new UpdateLiveEditError(e)), Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }
        return result2;
    }

    public List<Deploy.ComposeException> retrieveComposeStatus(Installer installer, AdbClient adb, String appId) throws IOException {
        List<Integer> pids = adb.getPids(appId);
        Deploy.Arch arch = adb.getArch(pids);
        if (arch == Deploy.Arch.ARCH_UNKNOWN) {
            return new ArrayList<Deploy.ComposeException>();
        }
        Deploy.ComposeStatusRequest.Builder requestBuilder = Deploy.ComposeStatusRequest.newBuilder();
        requestBuilder.setApplicationId(appId);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.ComposeStatusRequest request2 = requestBuilder.build();
        Deploy.ComposeStatusResponse response = installer.composeStatus(request2);
        return response.getExceptionsList();
    }

    public static class UpdateLiveLiteralParam {
        final String key;
        final String type;
        final String value;
        final int offset;
        final String helper;

        public UpdateLiveLiteralParam(String key, int offset, String helper, String type, String value) {
            this.key = key;
            this.offset = offset;
            this.helper = helper;
            this.type = type;
            this.value = value;
        }
    }

    public static class UpdateLiveEditError {
        private static final String APP_RESTART_STR = "Rerun app to apply changes.";
        private static final String ADDED_CLASS_STR = "Unsupported addition of new class:<br>'%s' in file '%s'.";
        private static final String ADDED_METHOD_STR = "Unsupported addition of new method:<br>'%s.%s' in file '%s', line %d.";
        private static final String REMOVED_METHOD_STR = "Unsupported deletion of method:<br>'%s.%s' in file '%s'.";
        private static final String ADDED_FIELD_STR = "Unsupported addition of field:<br>'%s' in class '%s' in file '%s'.";
        private static final String REMOVED_FIELD_STR = "Unsupported deletion of field:<br>'%s' in class '%s' in file '%s'.";
        private static final String MODIFIED_FIELD_STR = "Unsupported change to field:<br>'%s' in class '%s' in file '%s'.";
        private static final String MODIFIED_SUPER_STR = "Unsupported change to superclass of class:<br>'%s' in file '%s'.";
        private static final String ADDED_INTERFACE_STR = "Unsupported change to interfaces of class:<br>'%s' in file '%s'.";
        private static final String REMOVED_INTERFACE_STR = "Unsupported change to interfaces of class:<br>'%s' in file '%s'.";
        private static final String UNSUPPORTED_COMPOSE_VERSION = "Update Compose runtime and compiler versions 1.3.0 or higher in order to view the latest Live Edit changes.";
        private final String msg;
        private final Deploy.UnsupportedChange.Type type;

        public UpdateLiveEditError(Exception e) {
            this.msg = e.getMessage();
            this.type = Deploy.UnsupportedChange.Type.UNKNOWN;
        }

        public UpdateLiveEditError(String msg) {
            this.msg = msg;
            this.type = Deploy.UnsupportedChange.Type.UNKNOWN;
        }

        public UpdateLiveEditError(Deploy.UnsupportedChange error) {
            this.type = error.getType();
            switch (error.getType()) {
                case ADDED_CLASS: {
                    this.msg = String.format(Locale.US, ADDED_CLASS_STR, error.getClassName(), error.getFileName());
                    break;
                }
                case ADDED_METHOD: {
                    this.msg = String.format(Locale.US, ADDED_METHOD_STR, error.getClassName(), error.getTargetName(), error.getFileName(), error.getLineNumber());
                    break;
                }
                case REMOVED_METHOD: {
                    this.msg = String.format(Locale.US, REMOVED_METHOD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case ADDED_FIELD: {
                    this.msg = String.format(Locale.US, ADDED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case REMOVED_FIELD: {
                    this.msg = String.format(Locale.US, REMOVED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case MODIFIED_FIELD: {
                    this.msg = String.format(Locale.US, MODIFIED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case MODIFIED_SUPER: {
                    this.msg = String.format(Locale.US, MODIFIED_SUPER_STR, error.getClassName(), error.getFileName());
                    break;
                }
                case ADDED_INTERFACE: {
                    this.msg = String.format(Locale.US, "Unsupported change to interfaces of class:<br>'%s' in file '%s'.", error.getClassName(), error.getFileName());
                    break;
                }
                case REMOVED_INTERFACE: {
                    this.msg = String.format(Locale.US, "Unsupported change to interfaces of class:<br>'%s' in file '%s'.", error.getClassName(), error.getFileName());
                    break;
                }
                case UNSUPPORTED_COMPOSE_VERSION: {
                    this.msg = UNSUPPORTED_COMPOSE_VERSION;
                    break;
                }
                default: {
                    this.msg = "Unknown error.";
                }
            }
        }

        public String getMessage() {
            if (this.type == Deploy.UnsupportedChange.Type.UNSUPPORTED_COMPOSE_VERSION) {
                return this.msg;
            }
            return String.format("%s<br>%s", this.msg, APP_RESTART_STR);
        }

        public Deploy.UnsupportedChange.Type getType() {
            return this.type;
        }
    }

    public static final class UpdateLiveEditResult {
        public final List<UpdateLiveEditError> errors;
        public final Deploy.AgentLiveEditResponse.RecomposeType recomposeType;

        public UpdateLiveEditResult() {
            this(new ArrayList<UpdateLiveEditError>(), Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }

        public UpdateLiveEditResult(List<UpdateLiveEditError> errors) {
            this(errors, Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }

        public UpdateLiveEditResult(List<UpdateLiveEditError> errors, Deploy.AgentLiveEditResponse.RecomposeType type) {
            this.errors = errors;
            this.recomposeType = type;
        }
    }

    public static class UpdateLiveEditsParam {
        public final Deploy.LiveEditRequest.InvalidateMode invalidateMode;
        public final Set<Integer> groupIds;
        public final Map<String, byte[]> classes;
        public final Map<String, byte[]> supportClasses;
        final boolean debugModeEnabled;
        final boolean useStructuralRedefinition;

        public UpdateLiveEditsParam(Map<String, byte[]> classes, Map<String, byte[]> supportClasses, Set<Integer> groupIds, Deploy.LiveEditRequest.InvalidateMode invalidateMode, boolean debugModeEnabled, boolean useStructuralRedefinition) {
            this.classes = classes;
            this.supportClasses = supportClasses;
            this.groupIds = groupIds;
            this.invalidateMode = invalidateMode;
            this.debugModeEnabled = debugModeEnabled;
            this.useStructuralRedefinition = useStructuralRedefinition;
        }
    }
}

