/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.PatchSet;
import com.android.tools.deployer.PatchSetGenerator;
import com.android.tools.deployer.model.DeploymentPlan;
import com.android.tools.deployer.model.FileDiff;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;

class RootPushApkInstaller {
    private final AdbClient adb;
    private final Installer installer;
    private final ILogger logger;

    public RootPushApkInstaller(AdbClient adb, Installer installer, ILogger logger) {
        this.adb = adb;
        this.installer = installer;
        this.logger = logger;
    }

    public boolean install(DeploymentPlan plan) {
        Deploy.RootPushInstallResponse res;
        ApplicationDumper.Dump dump;
        if (!this.adb.getVersion().isAtLeast(AndroidVersion.BINDER_CMD_AVAILABLE.getApiLevel())) {
            this.logger.warning("RootPush: CMD service not available on target device", new Object[0]);
            return false;
        }
        try {
            if (!this.adb.getDevice().isRoot() && !this.adb.getDevice().root()) {
                this.logger.warning("RootPush: Could not elevate to root", new Object[0]);
                return false;
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ex) {
            this.logger.warning("RootPush: Elevation to root threw exception: " + String.valueOf(ex), new Object[0]);
            return false;
        }
        try {
            dump = new ApplicationDumper(this.installer).dump(plan.getApksForPackageManager());
            if (dump.apks.isEmpty()) {
                this.logger.warning("RootPush: No APKs in dump", new Object[0]);
                return false;
            }
            for (FileDiff fileDiff : new ApkDiffer().diff(dump.apks, plan.getApksForPackageManager())) {
                if (fileDiff.oldFile == null || !fileDiff.oldFile.getName().equals("AndroidManifest.xml")) continue;
                this.logger.info("RootPush: Manifest changes require pm install", new Object[0]);
                return false;
            }
        }
        catch (DeployerException e) {
            this.logger.warning("RootPush: " + String.valueOf(e), new Object[0]);
            return false;
        }
        String installDir = Paths.get(dump.apks.get((int)0).path, new String[0]).getParent().toString();
        Deploy.RootPushInstallRequest.Builder request2 = Deploy.RootPushInstallRequest.newBuilder().setInstallDir(installDir);
        PatchSet patchSet = new PatchSetGenerator(PatchSetGenerator.WhenNoChanges.GENERATE_EMPTY_PATCH, this.logger).generateFromApks(plan.getApksForPackageManager(), dump.apks);
        if (patchSet.getStatus() == PatchSet.Status.NoChanges) {
            return true;
        }
        if (patchSet.getStatus() != PatchSet.Status.Ok) {
            this.logger.warning("RootPush: Bad patchset status '%s'", new Object[]{patchSet.getStatus()});
            return false;
        }
        List<Deploy.PatchInstruction> patches = patchSet.getPatches();
        request2.getInstallInfoBuilder().addAllPatchInstructions(patches).setPackageName(plan.getApp().getAppId());
        if (request2.getInstallInfo().getSerializedSize() > 0x2800000) {
            this.logger.warning("RootPush: Patch too large", new Object[0]);
            return false;
        }
        try {
            res = this.installer.rootPushInstall(request2.build());
        }
        catch (IOException e) {
            this.logger.warning("RootPush: " + String.valueOf(e), new Object[0]);
            return false;
        }
        return res.getStatus() == Deploy.RootPushInstallResponse.Status.OK;
    }
}

