/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

class OverlayDiffer {
    private final EnumSet<ChangeType> supportedChanges;

    public OverlayDiffer(EnumSet<ChangeType> supportedChanges) {
        this.supportedChanges = supportedChanges;
    }

    public Result diff(List<Apk> newApks, OverlayId overlayId) throws DeployerException {
        List<ApkEntry> filesToAdd = this.getFilesToAdd(newApks, overlayId.getInstalledApks(), overlayId.getOverlayContents());
        Set<String> filesToRemove = OverlayDiffer.getFilesToRemove(newApks, filesToAdd, overlayId.getOverlayContents());
        return new Result(filesToAdd, filesToRemove);
    }

    private List<ApkEntry> getFilesToAdd(List<Apk> newApks, List<Apk> installedApks, OverlayId.Contents overlayContents) throws DeployerException {
        ArrayList<ApkEntry> files = new ArrayList<ApkEntry>();
        for (FileDiff diff : new ApkDiffer().diff(installedApks, newApks)) {
            ChangeType type = ChangeType.getType(diff);
            if (!this.supportedChanges.contains((Object)type)) {
                throw DeployerException.changeNotSupportedByIWI(type);
            }
            if (diff.status == FileDiff.Status.DELETED) {
                throw DeployerException.deleteInstalledFileNotSupported();
            }
            String qualifiedPath = diff.newFile.getQualifiedPath();
            if (diff.newFile.getChecksum() == overlayContents.getFileChecksum(qualifiedPath).longValue()) continue;
            files.add(diff.newFile);
        }
        return files;
    }

    private static Set<String> getFilesToRemove(List<Apk> newApks, List<ApkEntry> filesToAdd, OverlayId.Contents overlayContents) {
        HashSet<String> filesToDelete = new HashSet<String>(overlayContents.allFiles());
        Predicate<ApkEntry> matchesOverlay = entry -> entry.getChecksum() == overlayContents.getFileChecksum(entry.getQualifiedPath()).longValue();
        newApks.stream().flatMap(apk -> apk.apkEntries.values().stream()).filter(matchesOverlay).forEach(entry -> filesToDelete.remove(entry.getQualifiedPath()));
        filesToAdd.stream().map(ApkEntry::getQualifiedPath).forEach(filesToDelete::remove);
        return filesToDelete;
    }

    public static class Result {
        public final Collection<ApkEntry> filesToAdd;
        public final Collection<String> filesToRemove;

        private Result(Collection<ApkEntry> filesToAdd, Collection<String> filesToRemove) {
            this.filesToAdd = filesToAdd;
            this.filesToRemove = filesToRemove;
        }
    }
}

