/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkEntryExtractor;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OverlayDiffer;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.App;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;

class OptimisticApkInstaller {
    private static final String DUMP_METRIC = "IWI_INSTALL_DUMP";
    private static final String DIFF_METRIC = "IWI_INSTALL_DIFF";
    private static final String EXTRACT_METRIC = "IWI_INSTALL_EXTRACT";
    private static final String UPDATE_METRIC = "IWI_INSTALL_UPDATE_OVERLAYS";
    private final Installer installer;
    private final AdbClient adb;
    private final DeploymentCacheDatabase cache;
    private final MetricsRecorder metrics;
    private final DeployerOption options;
    private final ILogger logger;

    public OptimisticApkInstaller(Installer installer, AdbClient adb, DeploymentCacheDatabase cache2, MetricsRecorder metrics, DeployerOption options, ILogger logger) {
        this.installer = installer;
        this.adb = adb;
        this.cache = cache2;
        this.metrics = metrics;
        this.options = options;
        this.logger = logger;
    }

    public OverlayId install(App app, List<String> userFlags) throws DeployerException {
        if (OptimisticApkInstaller.hasInstrumentedTests(app.getApks())) {
            throw DeployerException.runTestsNotSupported();
        }
        if (OptimisticApkInstaller.hasSdkLibrary(app.getApks())) {
            throw DeployerException.sdksNotSupported();
        }
        if (!userFlags.isEmpty()) {
            throw DeployerException.pmFlagsNotSupported();
        }
        try {
            return this.tracedInstall(app);
        }
        catch (DeployerException ex) {
            this.metrics.finish(ex.getError());
            throw ex;
        }
        catch (Exception ex) {
            DeployerException wrapper = DeployerException.runtimeException(ex);
            this.metrics.finish(wrapper.getError());
            throw wrapper;
        }
    }

    private OverlayId tracedInstall(App app) throws DeployerException {
        Deploy.OverlayInstallResponse overlayInstallResponse;
        String deviceSerial = this.adb.getSerial();
        String targetAbi = this.adb.getAbiForApks(app.getApks());
        Deploy.Arch targetArch = AdbClient.getArchForAbi(targetAbi);
        this.metrics.start(DUMP_METRIC);
        DeploymentCacheDatabase.Entry entry = this.cache.get(deviceSerial, app.getAppId());
        if (entry == null || entry.getOverlayId().isBaseInstall()) {
            ApplicationDumper dumper = new ApplicationDumper(this.installer);
            List<Apk> deviceApks = dumper.dump(app.getApks()).apks;
            this.cache.store(deviceSerial, app.getAppId(), deviceApks, new OverlayId(deviceApks));
            entry = this.cache.get(deviceSerial, app.getAppId());
        }
        this.metrics.finish();
        this.metrics.start(DIFF_METRIC);
        OverlayId overlayId = entry.getOverlayId();
        OverlayDiffer.Result diff = new OverlayDiffer(this.options.optimisticInstallSupport).diff(app.getApks(), overlayId);
        this.metrics.finish();
        this.metrics.start(EXTRACT_METRIC);
        List<ApkEntry> filesToAdd = OptimisticApkInstaller.filterIncompatibleNativeLibraries(targetAbi, diff.filesToAdd);
        SortedMap<ApkEntry, ByteString> overlayFiles = new ApkEntryExtractor().extractFromEntries(filesToAdd);
        this.metrics.finish();
        this.metrics.start(UPDATE_METRIC);
        OverlayId.Builder nextIdBuilder = OverlayId.builder(overlayId);
        Deploy.OverlayInstallRequest.Builder request2 = Deploy.OverlayInstallRequest.newBuilder().setPackageName(app.getAppId()).setArch(targetArch).setExpectedOverlayId(overlayId.isBaseInstall() ? "" : overlayId.getSha());
        for (Map.Entry entry2 : overlayFiles.entrySet()) {
            request2.addOverlayFiles(Deploy.OverlayFile.newBuilder().setPath(((ApkEntry)entry2.getKey()).getQualifiedPath()).setContent((ByteString)entry2.getValue()));
            nextIdBuilder.addOverlayFile(((ApkEntry)entry2.getKey()).getQualifiedPath(), ((ApkEntry)entry2.getKey()).getChecksum());
        }
        for (String string2 : diff.filesToRemove) {
            request2.addDeletedFiles(string2);
            nextIdBuilder.removeOverlayFile(string2);
        }
        OverlayId nextOverlayId = nextIdBuilder.build();
        request2.setOverlayId(nextOverlayId.getSha());
        try {
            overlayInstallResponse = this.installer.overlayInstall(request2.build());
        }
        catch (IOException ex) {
            throw DeployerException.installerIoException(ex);
        }
        if (overlayInstallResponse.getStatus() != Deploy.OverlayInstallResponse.Status.OK) {
            throw DeployerException.installFailed(overlayInstallResponse.getStatus(), "Overlay update failed");
        }
        this.metrics.finish();
        this.metrics.add(overlayInstallResponse.getAgentLogsList());
        return nextOverlayId;
    }

    private static boolean hasInstrumentedTests(List<Apk> apks) {
        return apks.stream().anyMatch(apk -> !apk.targetPackages.isEmpty());
    }

    private static boolean hasSdkLibrary(List<Apk> apks) {
        return apks.stream().anyMatch(apk -> !apk.sdkLibraries.isEmpty());
    }

    private static List<ApkEntry> filterIncompatibleNativeLibraries(String targetAbi, Collection<ApkEntry> entries) {
        return entries.stream().filter(entry -> {
            Path overlayPath = Paths.get(entry.getName(), new String[0]);
            if (overlayPath.startsWith("lib")) {
                String abi = overlayPath.getParent().getFileName().toString();
                return targetAbi.equals(abi);
            }
            return true;
        }).collect(Collectors.toList());
    }
}

