/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.adblib.AdbSession;
import com.android.adblib.tools.AdbLibSessionFactoryKt;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Activator;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployRunnerParameters;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeployerRunnerLoggerFactory;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.LoggerReceiver;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.ApkParserException;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;

public class DeployerRunner {
    private static final int SUCCESS = 0;
    private static final int ERR_SPECIFIED_DEVICE_NOT_FOUND = 1002;
    private static final int ERR_NO_MATCHING_DEVICE = 1003;
    private static final int ERR_BAD_ARGS = 1004;
    private static final String DEX_DB_PATH = "/tmp/studio_dex.db";
    private static final String DEPLOY_DB_PATH = "/tmp/studio_deploy.db";
    private final InstallOptions defaultInstallOptions;
    private final DeploymentCacheDatabase cacheDb;
    private final SqlApkFileDatabase dexDb;
    private final MetricsRecorder metrics;
    private final UIService service;
    private long deviceWaitTimeoutMs = TimeUnit.SECONDS.toMillis(30L);

    public static void main(String[] args) {
        Trace.start();
        Trace.begin("main");
        DeployerRunner runner = new DeployerRunner(InstallOptions.MOBILE_INSTALL_DEFAULTS, new File(DEPLOY_DB_PATH), new File(DEX_DB_PATH), new AlwaysYesService());
        String[] parameters = Arrays.copyOf(args, args.length + 1);
        parameters[args.length] = "--create_adblib_session";
        int errorCode = runner.run(parameters);
        Trace.end();
        Trace.flush();
        System.exit(errorCode);
    }

    public DeployerRunner(File deployCacheFile, File databaseFile, UIService service) {
        this(InstallOptions.STUDIO_DEFAULTS, deployCacheFile, databaseFile, service);
    }

    private DeployerRunner(InstallOptions defaultInstallOptions, File deployCacheFile, File databaseFile, UIService service) {
        this.defaultInstallOptions = defaultInstallOptions;
        this.cacheDb = new DeploymentCacheDatabase(deployCacheFile);
        this.dexDb = new SqlApkFileDatabase(databaseFile, null);
        this.service = service;
        this.metrics = new MetricsRecorder();
    }

    @VisibleForTesting
    public DeployerRunner(DeploymentCacheDatabase cacheDb, SqlApkFileDatabase dexDb, UIService service) {
        this.defaultInstallOptions = InstallOptions.STUDIO_DEFAULTS;
        this.cacheDb = cacheDb;
        this.dexDb = dexDb;
        this.service = service;
        this.metrics = new MetricsRecorder();
    }

    @VisibleForTesting
    public void setDeviceWaitTimeout(long duration, TimeUnit unit) {
        this.deviceWaitTimeoutMs = unit.toMillis(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: {install | codeswap | fullswap} [--device=<serial>] [--user=<user id>|all|current] [--adb=<path>] packageName baseApk [splitApk1, splitApk2, ...]");
            return 1004;
        }
        try {
            DeployRunnerParameters parameters = DeployRunnerParameters.parse(args);
            StdLogger logger = new StdLogger(parameters.getLogLevel());
            Map<String, IDevice> devices2 = this.waitForDevices(parameters.getAdbExecutablePath(), parameters.getTargetDevices(), parameters.getJdwpClientSupport(), (ILogger)logger);
            if (devices2.isEmpty()) {
                logger.error(null, "No device connected to ddmlib", new Object[0]);
                int n = 1003;
                return n;
            }
            for (String expectedDevice : parameters.getTargetDevices()) {
                if (devices2.containsKey(expectedDevice)) continue;
                logger.error(null, "Could not find specified device: %s", new Object[]{expectedDevice});
                int n = 1002;
                return n;
            }
            for (IDevice device2 : devices2.values()) {
                int status2 = this.run(device2, parameters, (ILogger)logger);
                if (status2 == 0) continue;
                logger.error(null, "Error deploying to device: %s", new Object[]{device2.getName()});
                int n = status2;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    public int run(IDevice device2, String[] args, ILogger logger) {
        return this.run(device2, DeployRunnerParameters.parse(args), logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(IDevice device2, DeployRunnerParameters parameters, ILogger logger) {
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (parameters.isOptimisticInstall()) {
            optimisticInstallSupport.add(ChangeType.DEX);
            optimisticInstallSupport.add(ChangeType.NATIVE_LIBRARY);
        }
        this.metrics.getDeployMetrics().clear();
        AdbSession session2 = null;
        if (parameters.getCreateAdblibSession()) {
            session2 = AdbLibSessionFactoryKt.createSocketConnectSession((Function0<? extends InetSocketAddress>)((Function0)AndroidDebugBridge::getSocketAddress), new DeployerRunnerLoggerFactory(parameters.getLogLevel()));
        }
        AdbClient adb = new AdbClient(device2, logger, session2);
        AdbInstaller installer = new AdbInstaller(parameters.getInstallersPath(), adb, this.metrics.getDeployMetrics(), logger);
        ExecutorService service = Executors.newFixedThreadPool(5);
        TaskRunner runner = new TaskRunner(service);
        DeployerOption deployerOption = new DeployerOption.Builder().setUseOptimisticSwap(true).setUseOptimisticResourceSwap(true).setUseStructuralRedefinition(true).setUseVariableReinitialization(true).setFastRestartOnSwapFail(false).setOptimisticInstallSupport(optimisticInstallSupport).enableCoroutineDebugger(true).setAllowAssumeVerified(device2.getVersion().isAtLeast(35)).skipPostInstallTasks(parameters.getSkipPostInstallTasks()).useRootPushInstall(parameters.getUseRootPushInstall()).build();
        Deployer deployer = new Deployer(adb, this.cacheDb, this.dexDb, runner, installer, this.service, this.metrics, logger, deployerOption);
        try {
            Deployer.Result deployResult;
            App app;
            App app2 = app = parameters.hasStrategyJson() ? DeployerRunner.getAppToInstall(parameters.getStrategyJson(), logger) : DeployerRunner.getAppToInstall(parameters.getApplicationId(), parameters.getApks());
            if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.INSTALL)) {
                InstallOptions.Builder options = this.defaultInstallOptions.toBuilder();
                if (device2.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
                    options.setGrantAllPermissions();
                }
                Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
                if (parameters.isForceFullInstall()) {
                    installMode = Deployer.InstallMode.FULL;
                }
                if (parameters.getTargetUserId() != null) {
                    options.setInstallOnUser(parameters.getTargetUserId());
                }
                options.setShouldUseAssumeVerified(deployerOption.allowAssumeVerified);
                options.setUserInstallOptions(parameters.getUserInstallFlags());
                deployResult = deployer.install(app, options.build(), installMode);
            } else if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.FULLSWAP)) {
                deployResult = deployer.fullSwap(app, Canceller.NO_OP);
            } else if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.CODESWAP)) {
                deployResult = deployer.codeSwap(app, (Map<Integer, ClassRedefiner>)ImmutableMap.of(), Canceller.NO_OP);
            } else {
                throw new RuntimeException("UNKNOWN command");
            }
            runner.run(Canceller.NO_OP);
            if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.ACTIVATE)) {
                DeployRunnerParameters.Component component = parameters.getComponentToActivate();
                assert (component != null);
                Activator activator = new Activator(deployResult.app, logger);
                activator.activate(component.type, component.name, new LoggerReceiver(logger), device2);
            }
        }
        catch (DeployerException e) {
            String commands = parameters.getCommands().stream().map(String::valueOf).map(String::toLowerCase).collect(Collectors.joining(","));
            logger.error((Throwable)e, "Not possible to execute " + commands, new Object[0]);
            logger.warning(e.getDetails(), new Object[0]);
            int n = e.getError().ordinal();
            return n;
        }
        finally {
            service.shutdown();
        }
        return 0;
    }

    public List<DeployMetric> getMetrics() {
        return this.metrics.getDeployMetrics();
    }

    public static App getAppToInstall(String appId, List<Path> apks) throws DeployerException {
        try {
            return App.fromPaths(appId, apks);
        }
        catch (ApkParserException e) {
            throw DeployerException.parseFailed(e.getMessage());
        }
    }

    public static App getAppToInstall(String strategyJson, ILogger logger) throws DeployerException {
        try {
            Path path = Paths.get(strategyJson, new String[0]);
            return App.fromStrategy(path, logger);
        }
        catch (ApkParserException e) {
            throw DeployerException.parseFailed(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IDevice> waitForDevices(String adbExecutablePath, final List<String> deviceSerials, boolean jdwpClientSupport, final ILogger logger) {
        try (Trace unused = Trace.begin("waitForDevices()");){
            Map<String, IDevice> map2;
            AndroidDebugBridge.IDeviceChangeListener listener2;
            block19: {
                int expectedDevices = deviceSerials.isEmpty() ? 1 : deviceSerials.size();
                final CountDownLatch latch = new CountDownLatch(expectedDevices);
                final ConcurrentHashMap<String, IDevice> devices2 = new ConcurrentHashMap<String, IDevice>();
                listener2 = new AndroidDebugBridge.IDeviceChangeListener(){

                    @Override
                    public void deviceConnected(IDevice device2) {
                        String serial = device2.getSerialNumber();
                        logger.info("Found device with serial: %s", new Object[]{serial});
                        if (deviceSerials.isEmpty() || deviceSerials.contains(serial)) {
                            devices2.put(serial, device2);
                            latch.countDown();
                        }
                    }

                    @Override
                    public void deviceDisconnected(IDevice device2) {
                    }

                    @Override
                    public void deviceChanged(IDevice device2, int changeMask) {
                    }
                };
                if (jdwpClientSupport) {
                    AndroidDebugBridge.init(AdbInitOptions.DEFAULT);
                } else {
                    AndroidDebugBridge.init(AdbInitOptions.builder().setClientSupportEnabled(false).useJdwpProxyService(false).build());
                }
                AndroidDebugBridge.addDeviceChangeListener(listener2);
                AndroidDebugBridge bridge = adbExecutablePath == null ? AndroidDebugBridge.createBridge(5L, TimeUnit.SECONDS) : AndroidDebugBridge.createBridge(adbExecutablePath, true, 5L, TimeUnit.SECONDS);
                if (bridge == null) {
                    logger.error(null, "Could not create debug bridge", new Object[0]);
                    Map<String, IDevice> map3 = Collections.emptyMap();
                    return map3;
                }
                if (!latch.await(this.deviceWaitTimeoutMs, TimeUnit.MILLISECONDS)) break block19;
                ConcurrentHashMap<String, IDevice> concurrentHashMap = devices2;
                AndroidDebugBridge.removeDeviceChangeListener(listener2);
                return concurrentHashMap;
            }
            try {
                map2 = Collections.emptyMap();
            }
            catch (InterruptedException e) {
                Map<String, IDevice> map4;
                try {
                    map4 = Collections.emptyMap();
                }
                catch (Throwable throwable) {
                    AndroidDebugBridge.removeDeviceChangeListener(listener2);
                    throw throwable;
                }
                AndroidDebugBridge.removeDeviceChangeListener(listener2);
                if (unused != null) {
                    unused.close();
                }
                return map4;
            }
            AndroidDebugBridge.removeDeviceChangeListener(listener2);
            return map2;
        }
    }

    static class AlwaysYesService
    implements UIService {
        AlwaysYesService() {
        }

        @Override
        public boolean prompt(String result2) {
            return true;
        }

        @Override
        public void message(String message) {
        }
    }
}

