/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbSession;
import com.android.adblib.DeviceSelector;
import com.android.adblib.tools.InstallException;
import com.android.adblib.tools.InstallMetrics;
import com.android.adblib.tools.InstallerKt;
import com.android.adblib.tools.JavaBridge;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SimpleConnectedSocket;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkVerifierTracker;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallStatus;
import com.android.tools.deployer.Timeouts;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.DeploymentPlan;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.coroutines.Continuation;

public class AdbClient {
    private static final Map<String, Deploy.Arch> ABI_MAP = ImmutableMap.of((Object)"arm64-v8a", (Object)Deploy.Arch.ARCH_64_BIT, (Object)"armeabi-v7a", (Object)Deploy.Arch.ARCH_32_BIT, (Object)"x86_64", (Object)Deploy.Arch.ARCH_64_BIT, (Object)"x86", (Object)Deploy.Arch.ARCH_32_BIT);
    private final IDevice device;
    private final ILogger logger;
    private final Optional<AdbSession> adbSession;

    public AdbClient(IDevice device2, ILogger logger) {
        this(device2, logger, null);
    }

    public AdbClient(IDevice device2, ILogger logger, AdbSession adbSession) {
        this.device = device2;
        this.logger = logger;
        this.adbSession = Optional.ofNullable(adbSession);
    }

    public SimpleConnectedSocket rawExec(String executable, String[] parameters) throws AdbCommandRejectedException, IOException, TimeoutException {
        return this.device.rawExec2(executable, parameters);
    }

    public byte[] shell(String[] parameters, long timeOutmS) throws IOException {
        return this.shell(parameters, null, timeOutmS);
    }

    public byte[] shell(String[] parameters, InputStream input, long timeOutmS) throws IOException {
        return this.shell(parameters, input, timeOutmS, TimeUnit.MILLISECONDS);
    }

    public byte[] shell(String[] parameters, InputStream input, long maxTimeOutMs, TimeUnit timeUnit) throws IOException {
        Trace ignored = Trace.begin("adb shell" + Arrays.toString(parameters));
        try {
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver(this);
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)receiver, maxTimeOutMs, timeUnit, input);
            byte[] byArray = receiver.toByteArray();
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
                throw new IOException(e);
            }
        }
    }

    public byte[] binder(String[] parameters, InputStream input) throws IOException {
        this.logger.info("BINDER: " + String.join((CharSequence)" ", parameters), new Object[0]);
        Trace ignored = Trace.begin("binder" + Arrays.toString(parameters));
        try {
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver(this);
            this.device.executeBinderCommand(parameters, receiver, 5L, TimeUnit.MINUTES, input);
            byte[] byArray = receiver.toByteArray();
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
                throw new IOException(e);
            }
        }
    }

    public InstallResult install(DeploymentPlan plan, List<String> options, boolean reinstall) {
        InstallResult ir;
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.addAll(plan.getApksForPackageManager().stream().map(apk -> Paths.get(apk.path, new String[0])).collect(Collectors.toList()));
        List<Path> bps = plan.getApp().getBaselineProfile(this.device.getVersion().getApiLevel());
        paths.addAll(bps);
        this.logger.info("Installing:", new Object[0]);
        for (Path p : paths) {
            this.logger.info("    " + String.valueOf(p.getFileName()), new Object[0]);
        }
        if (this.adbSession.isPresent()) {
            this.logger.info("Installing with adblib", new Object[0]);
            ir = this.installWithAdbLib(paths, options, reinstall);
        } else {
            this.logger.info("Installing with ddmlib", new Object[0]);
            ir = this.installWithDdmLib(paths, options, reinstall);
        }
        if (!bps.isEmpty() && this.baselineInstallationStatusSupported()) {
            String[] cmd = new String[]{"pm", "art", "dump", plan.getApp().getAppId()};
            byte[] rawResult = new byte[]{};
            try {
                rawResult = this.shell(cmd, Timeouts.SHELL_BASELINE_PROFILE_STATUS);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Unable to retrieve baseline profile status", new Object[0]);
            }
            String result2 = new String(rawResult);
            if (!result2.contains("status=speed-profile")) {
                return new InstallResult(InstallStatus.INSTALL_BASELINE_PROFILE_FAILED, "Baseline profile did not install: " + result2);
            }
            this.logger.info(result2, new Object[0]);
            return ir;
        }
        return ir;
    }

    private boolean baselineInstallationStatusSupported() {
        return this.device.getVersion().getApiLevel() > 33;
    }

    private InstallResult makeInstallResult(String code, String message, Throwable t) {
        if (code != null) {
            try {
                return ApkInstaller.toInstallerResult(code, message);
            }
            catch (IllegalArgumentException | NullPointerException ignored) {
                this.logger.warning("Unrecognized Installation Failure: %s\n%s\n", new Object[]{code, message});
            }
        } else {
            if (t instanceof ShellCommandUnresponsiveException) {
                return new InstallResult(InstallStatus.SHELL_UNRESPONSIVE, message);
            }
            this.logger.warning("Installation Failure: %s\n", new Object[]{message});
            return new InstallResult(InstallStatus.UNKNOWN_ERROR, message, null);
        }
        return new InstallResult(InstallStatus.UNKNOWN_ERROR, "Unknown Error");
    }

    private static long toNanos(Instant instant) {
        return TimeUnit.MILLISECONDS.toNanos(instant.toEpochMilli()) + (long)instant.getNano();
    }

    private InstallResult installWithAdbLib(List<Path> paths, List<String> options, boolean reinstall) {
        try {
            if (reinstall) {
                options.add("-r");
            }
            DeviceSelector deviceSelector = DeviceSelector.fromSerialNumber(this.device.getSerialNumber());
            Duration timeout = Duration.of(Timeouts.CMD_OINSTALL_MS, ChronoUnit.MILLIS);
            AdbDeviceServices deviceServices = this.adbSession.get().getDeviceServices();
            long startNanos = System.nanoTime();
            InstallMetrics metrics = (InstallMetrics)JavaBridge.runBlocking(deviceServices.getSession(), c -> InstallerKt.install(deviceServices, deviceSelector, paths, options, timeout, (Continuation<? super InstallMetrics>)c));
            long installStartTimeNs = AdbClient.toNanos(metrics.getStartTime());
            long installEndTimeNs = installStartTimeNs + metrics.getDuration().toNanos();
            long pushStartTimeNs = AdbClient.toNanos(metrics.getUploadStartTime());
            long pushEndTimeNs = pushStartTimeNs + metrics.getUploadDuration().toNanos();
            long timeDiff = startNanos - installStartTimeNs;
            com.android.ddmlib.InstallMetrics ddmMetrics = new com.android.ddmlib.InstallMetrics(pushStartTimeNs += timeDiff, pushEndTimeNs += timeDiff, installStartTimeNs += timeDiff, installEndTimeNs += timeDiff);
            return new InstallResult(InstallStatus.OK, null, ddmMetrics);
        }
        catch (InstallException e) {
            String code = e.getErrorCode();
            String message = e.getMessage();
            return this.makeInstallResult(code, message, e);
        }
    }

    private InstallResult installWithDdmLib(List<Path> paths, List<String> options, boolean reinstall) {
        List<File> files = paths.stream().map(Path::toFile).collect(Collectors.toList());
        try {
            if (this.device.getVersion().isAtLeast(21)) {
                this.device.installPackages(files, reinstall, options, 5L, TimeUnit.MINUTES);
                return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
            }
            if (files.size() != 1) {
                return new InstallResult(InstallStatus.MULTI_APKS_NO_SUPPORTED_BELOW21, "Splits are not supported below API 21");
            }
            this.device.installPackage(files.get(0).getAbsolutePath(), reinstall, options.toArray(new String[0]));
            return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
        }
        catch (com.android.ddmlib.InstallException e) {
            String code = e.getErrorCode();
            String message = e.getMessage();
            return this.makeInstallResult(code, message, e);
        }
    }

    public boolean uninstall(String packageName) {
        try {
            this.device.uninstallPackage(packageName);
            return true;
        }
        catch (com.android.ddmlib.InstallException installException) {
            return false;
        }
    }

    public List<String> getAbis() {
        return this.device.getAbis();
    }

    public List<Integer> getPids(String packageName) {
        if (!this.device.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            throw new IllegalStateException(String.format("Device %s, do not support REAL_PKG_NAME", this.device.getSerialNumber()));
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Client client : this.device.getClients()) {
            if (!packageName.equals(client.getClientData().getPackageName())) continue;
            results.add(client.getClientData().getPid());
        }
        return results;
    }

    public Deploy.Arch getArch(List<Integer> pids) {
        Deploy.Arch result2 = Deploy.Arch.ARCH_UNKNOWN;
        for (int pid : pids) {
            Deploy.Arch curProc = this.getArch(pid);
            if (result2 == Deploy.Arch.ARCH_UNKNOWN) {
                result2 = curProc;
                continue;
            }
            if (curProc == Deploy.Arch.ARCH_UNKNOWN || result2 == curProc) continue;
            this.logger.warning("Mixed ABIs detected: %s and %s", new Object[]{result2, curProc});
        }
        return result2;
    }

    public String getAbiForApks(List<Apk> apks) throws DeployerException {
        HashSet<String> appSupported = new HashSet<String>();
        for (Apk apk : apks) {
            appSupported.addAll(apk.libraryAbis);
        }
        List<String> deviceSupported = this.getAbis();
        if (deviceSupported.isEmpty()) {
            throw DeployerException.unsupportedArch();
        }
        if (appSupported.isEmpty()) {
            String abi = deviceSupported.get(0);
            return abi;
        }
        for (String abi : deviceSupported) {
            if (!appSupported.contains(abi)) continue;
            return abi;
        }
        throw DeployerException.unsupportedArch();
    }

    public static Deploy.Arch getArchForAbi(String abi) {
        return ABI_MAP.get(abi);
    }

    private Deploy.Arch getArch(int pid) {
        for (Client client : this.device.getClients()) {
            if (client.getClientData().getPid() != pid) continue;
            return AdbClient.getArchFromDdmClient(client.getClientData());
        }
        return Deploy.Arch.ARCH_UNKNOWN;
    }

    @VisibleForTesting
    static Deploy.Arch getArchFromDdmClient(ClientData clientData) {
        String abi = clientData.getAbi();
        if (abi == null) {
            return Deploy.Arch.ARCH_UNKNOWN;
        }
        if (abi.startsWith("32-bit")) {
            return Deploy.Arch.ARCH_32_BIT;
        }
        if (abi.startsWith("64-bit")) {
            return Deploy.Arch.ARCH_64_BIT;
        }
        Deploy.Arch fromMapping = AdbClient.getArchForAbi(abi);
        if (fromMapping == null) {
            return Deploy.Arch.ARCH_UNKNOWN;
        }
        return fromMapping;
    }

    public void push(String from, String to) throws IOException {
        try (Trace ignored = Trace.begin("adb push");){
            this.device.pushFile(from, to);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    public String getName() {
        return this.device.getName();
    }

    public String getSerial() {
        return this.device.getSerialNumber();
    }

    public String abortSession(String sessionId) {
        String response;
        String prefix = this.device.getVersion().isAtLeast(24) ? "cmd package" : "pm";
        String[] command = new String[]{prefix, "install-abandon", sessionId};
        try {
            byte[] bytes = this.shell(command, Timeouts.SHELL_ABORT_INSTALL_MS);
            response = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            response = e.getMessage();
        }
        return response;
    }

    public String getSkipVerificationOption(String packageName) {
        return ApkVerifierTracker.getSkipVerificationInstallationFlag(this.device, packageName);
    }

    public IDevice getDevice() {
        return this.device;
    }

    private class ByteArrayOutputReceiver
    implements IShellOutputReceiver {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private ByteArrayOutputReceiver(AdbClient adbClient) {
        }

        @Override
        public void addOutput(byte[] data, int offset, int length) {
            this.stream.write(data, offset, length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }

    public static class InstallResult {
        public final InstallStatus status;
        public final String reason;
        public final com.android.ddmlib.InstallMetrics metrics;

        InstallResult(InstallStatus status2, String reason) {
            this.status = status2;
            this.reason = reason;
            this.metrics = null;
        }

        InstallResult(InstallStatus status2, String reason, com.android.ddmlib.InstallMetrics metrics) {
            this.status = status2;
            this.reason = reason;
            this.metrics = metrics;
        }
    }
}

