/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.Activity;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.Complication;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.deployer.model.component.Tile;
import com.android.tools.deployer.model.component.WatchFace;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;
import java.util.Optional;

public class Activator {
    static final String NO_FLAGS = "";
    private final App app;
    private final ILogger logger;

    public Activator(App app, ILogger logger) {
        this.app = app;
        this.logger = logger;
    }

    public void activate(ComponentType type, String componentName, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        this.activate(type, componentName, NO_FLAGS, AppComponent.Mode.RUN, receiver, device2);
    }

    public void activate(ComponentType type, String componentName, String extraFlags, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        this.activate(type, componentName, extraFlags, AppComponent.Mode.RUN, receiver, device2);
    }

    public void activate(ComponentType type, String componentName, AppComponent.Mode mode, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        this.activate(type, componentName, NO_FLAGS, mode, receiver, device2);
    }

    public void activate(ComponentType type, String componentName, String extraFlags, AppComponent.Mode mode, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        String qualifiedName = componentName.startsWith(".") ? this.app.getAppId() + componentName : componentName;
        AppComponent component = this.getComponent(type, qualifiedName);
        component.activate(extraFlags, mode, receiver, device2);
    }

    private AppComponent getComponent(ComponentType type, String qualifiedName) throws DeployerException {
        AppComponent component = null;
        switch (type) {
            case ACTIVITY: {
                Optional<ManifestActivityInfo> optionalActivity = this.getActivity(qualifiedName);
                if (!optionalActivity.isPresent()) break;
                component = new Activity(optionalActivity.get(), this.app.getAppId(), this.logger);
                break;
            }
            case WATCH_FACE: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new WatchFace(optionalService.get(), this.app.getAppId(), this.logger);
                break;
            }
            case TILE: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new Tile(optionalService.get(), this.app.getAppId(), this.logger);
                break;
            }
            case COMPLICATION: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new Complication(optionalService.get(), this.app.getAppId(), this.logger);
                break;
            }
            default: {
                throw DeployerException.componentActivationException("Unsupported app component type " + String.valueOf((Object)type));
            }
        }
        if (component == null) {
            throw DeployerException.componentActivationException(String.format("'%s' with name '%s' is not found in '%s'", new Object[]{type, qualifiedName, this.app.getAppId()}));
        }
        return component;
    }

    public void forceStop(IDevice device2) {
        device2.forceStop(this.app.getAppId());
    }

    private Optional<ManifestActivityInfo> getActivity(String qualifiedName) {
        for (Apk apk : this.app.getApks()) {
            Optional<ManifestActivityInfo> optionalActivity = apk.activities.stream().filter(a -> a.getQualifiedName().equals(qualifiedName)).findAny();
            if (!optionalActivity.isPresent()) continue;
            return optionalActivity;
        }
        return Optional.empty();
    }

    private Optional<ManifestServiceInfo> getService(String qualifiedName) {
        for (Apk apk : this.app.getApks()) {
            Optional<ManifestServiceInfo> optionalService = apk.services.stream().filter(a -> a.getQualifiedName().equals(qualifiedName)).findAny();
            if (!optionalService.isPresent()) continue;
            return optionalService;
        }
        return Optional.empty();
    }
}

