/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApkEntry {
    @Nullable
    public static ApkEntry fromNode(@Nullable Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ApkEntry)) {
            return null;
        }
        return (ApkEntry)userObject;
    }

    public static void sort(@NotNull DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            children.add((DefaultMutableTreeNode)node.getChildAt(i));
        }
        Collections.sort(children, (o1, o2) -> {
            ApkEntry entry1 = ApkEntry.fromNode(o1);
            ApkEntry entry2 = ApkEntry.fromNode(o2);
            if (entry1 == null || entry2 == null) {
                return 0;
            }
            return Long.compare(entry2.getSize(), entry1.getSize());
        });
        node.removeAllChildren();
        for (DefaultMutableTreeNode child : children) {
            node.add(child);
        }
    }

    @NotNull
    public String getName();

    @NotNull
    public Path getPath();

    public long getSize();
}

