/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationInfo {
    public static final AndroidApplicationInfo UNKNOWN = new AndroidApplicationInfo("unknown", "unknown", 0L, false);
    @NotNull
    public final String packageId;
    @NotNull
    public final String versionName;
    public final long versionCode;
    public final Boolean extractNativeLibs;
    private final Map<String, String> usesFeature;
    private final Set<String> usesFeatureNotRequired;
    private static final Pattern impliedFeaturePattern = Pattern.compile("uses-implied-feature: name='(.+)' reason='(.+)'");
    private static final Pattern packagePattern = Pattern.compile("package: name='(.*)' versionCode='(.*)' versionName='(.*)' platformBuildVersionName='(.*)'");
    private final Set<String> permissions;

    public AndroidApplicationInfo(@NotNull String packageId, @NotNull String versionName, long versionCode, Boolean extractNativeLibs) {
        this.packageId = packageId;
        this.versionName = versionName;
        this.versionCode = versionCode;
        this.extractNativeLibs = extractNativeLibs;
        this.usesFeature = ImmutableMap.of();
        this.usesFeatureNotRequired = ImmutableSet.of();
        this.permissions = ImmutableSet.of();
    }

    public AndroidApplicationInfo(@NotNull String packageId, @NotNull String versionName, long versionCode, Boolean extractNativeLibs, Map<String, String> usesFeature, Set<String> usesFeatureNotRequired, Set<String> permissions) {
        this.packageId = packageId;
        this.versionName = versionName;
        this.versionCode = versionCode;
        this.extractNativeLibs = extractNativeLibs;
        this.usesFeature = usesFeature;
        this.usesFeatureNotRequired = usesFeatureNotRequired;
        this.permissions = permissions;
    }

    @NotNull
    public static AndroidApplicationInfo parse(@NotNull List<String> output) {
        String packageId = null;
        long versionCode = 0L;
        String versionName = null;
        Boolean extractNativeLibs = null;
        for (String line : output) {
            int endParen;
            int eqIndex;
            if ((line = line.trim()).startsWith("A: android:versionCode")) {
                int endParenthesis;
                eqIndex = line.indexOf("=(type 0x10)");
                if (eqIndex > 0 && (endParenthesis = line.indexOf(41, eqIndex + 2)) > 0) {
                    String versionCodeStr = line.substring(endParenthesis + 1);
                    try {
                        versionCode = Long.decode(versionCodeStr);
                    }
                    catch (NumberFormatException e) {
                        versionCode = 0L;
                    }
                }
            } else if (line.startsWith("A: android:versionName")) {
                eqIndex = line.indexOf(61);
                if (eqIndex > 0 && (endQuote = line.indexOf(34, eqIndex + 2)) > 0) {
                    versionName = line.substring(eqIndex + 2, endQuote);
                }
            } else if (line.startsWith("A: package=")) {
                eqIndex = line.indexOf(61);
                if (eqIndex > 0 && (endQuote = line.indexOf(34, eqIndex + 2)) > 0) {
                    packageId = line.substring(eqIndex + 2, endQuote);
                }
            } else if (line.startsWith("A: android:extractNativeLibs") && (eqIndex = line.indexOf(61)) > 0 && (endParen = line.indexOf(41, eqIndex + 2)) > 0) {
                String value = line.substring(endParen + 1);
                extractNativeLibs = value.equals("0x1");
            }
            if (packageId == null || versionName == null || versionCode == 0L || extractNativeLibs == null) continue;
            break;
        }
        return new AndroidApplicationInfo(packageId == null ? "unknown" : packageId, versionName == null ? "?" : versionName, versionCode, extractNativeLibs);
    }

    public static AndroidApplicationInfo parseBadging(@NotNull List<String> output) {
        Builder builder = new Builder();
        for (String line : output) {
            String name;
            Matcher matcher;
            if ((line = line.trim()).startsWith("package:")) {
                matcher = packagePattern.matcher(line);
                if (!matcher.matches()) continue;
                builder.setPackageId(matcher.group(1));
                try {
                    builder.setVersionCode(Long.decode(matcher.group(2)));
                }
                catch (NumberFormatException e) {
                    builder.setVersionCode(0L);
                }
                builder.setVersionName(matcher.group(3));
                continue;
            }
            if (line.startsWith("uses-feature:")) {
                name = line.substring("uses-feature: name='".length(), line.length() - 1);
                builder.addFeature(name);
                continue;
            }
            if (line.startsWith("uses-implied-feature:")) {
                matcher = impliedFeaturePattern.matcher(line);
                if (!matcher.matches()) continue;
                builder.addImpliedFeature(matcher.group(1), matcher.group(2));
                continue;
            }
            if (line.startsWith("uses-feature-not-required:")) {
                name = line.substring("uses-feature-not-required: name='".length(), line.length() - 1);
                builder.addFeatureNotRequired(name);
                continue;
            }
            if (!line.startsWith("uses-permission:")) continue;
            name = line.substring("uses-permission: name='".length(), line.length() - 1);
            builder.addPermission(name);
        }
        return builder.build();
    }

    public Map<String, String> getUsesFeature() {
        return this.usesFeature;
    }

    public Set<String> getUsesFeatureNotRequired() {
        return this.usesFeatureNotRequired;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    private static class Builder {
        public String packageId;
        public String versionName;
        public long versionCode;
        private final Map<String, String> usesFeature = new HashMap<String, String>();
        private final Set<String> usesFeatureNotRequired = new HashSet<String>();
        private final Set<String> permissions = new HashSet<String>();

        private Builder() {
        }

        public void setPackageId(@NotNull String packageId) {
            this.packageId = packageId;
        }

        public void setVersionName(@NotNull String versionName) {
            this.versionName = versionName;
        }

        public void setVersionCode(long versionCode) {
            this.versionCode = versionCode;
        }

        public void addFeature(@NotNull String name) {
            if (!this.usesFeature.containsKey(name)) {
                this.usesFeature.put(name, null);
            }
        }

        public void addImpliedFeature(@NotNull String name, @NotNull String reason) {
            this.usesFeature.put(name, reason);
        }

        public void addFeatureNotRequired(@NotNull String name) {
            this.usesFeatureNotRequired.add(name);
        }

        public AndroidApplicationInfo build() {
            return new AndroidApplicationInfo(this.packageId == null ? "unknown" : this.packageId, this.versionName == null ? "?" : this.versionName, this.versionCode, false, Collections.unmodifiableMap(this.usesFeature), Collections.unmodifiableSet(this.usesFeatureNotRequired), Collections.unmodifiableSet(this.permissions));
        }

        public void addPermission(String name) {
            this.permissions.add(name);
        }
    }
}

