/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

public final class ResourceUrlParser {
    private String resourceUrl = "";
    private int colonPos;
    private int slashPos;
    private int typeStart;
    private int namespacePrefixStart;
    private int nameStart;

    /*
     * Enabled aggressive block sorting
     */
    public void parseResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        this.colonPos = -1;
        this.slashPos = -1;
        this.typeStart = -1;
        this.namespacePrefixStart = -1;
        int prefixEnd = resourceUrl.startsWith("@") ? (resourceUrl.startsWith("@+") ? 2 : 1) : (resourceUrl.startsWith("?") ? 1 : 0);
        if (resourceUrl.startsWith("*", prefixEnd)) {
            ++prefixEnd;
        }
        int len = resourceUrl.length();
        int start2 = prefixEnd;
        block4: for (int i = prefixEnd; i < len; ++i) {
            char c = resourceUrl.charAt(i);
            switch (c) {
                case '/': {
                    if (this.slashPos >= 0) break;
                    this.slashPos = i;
                    this.typeStart = start2;
                    start2 = i + 1;
                    if (this.colonPos < 0) break;
                    break block4;
                }
                case ':': {
                    if (this.colonPos >= 0) break;
                    this.colonPos = i;
                    this.namespacePrefixStart = start2;
                    start2 = i + 1;
                    if (this.slashPos >= 0) break block4;
                }
            }
        }
        this.nameStart = start2;
    }

    public String getNamespacePrefix() {
        return this.colonPos >= 0 ? this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos) : null;
    }

    public String getType() {
        return this.slashPos >= 0 ? this.resourceUrl.substring(this.typeStart, this.slashPos) : null;
    }

    public String getName() {
        return this.resourceUrl.substring(this.nameStart);
    }

    public String getQualifiedName() {
        if (this.colonPos < 0) {
            return this.getName();
        }
        if (this.nameStart == this.colonPos + 1) {
            return this.resourceUrl.substring(this.namespacePrefixStart);
        }
        return this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos + 1) + this.getName();
    }

    public boolean hasType(String type) {
        if (this.slashPos < 0) {
            return false;
        }
        return this.slashPos == this.typeStart + type.length() && this.resourceUrl.startsWith(type, this.typeStart);
    }

    public boolean hasNamespacePrefix(String namespacePrefix) {
        if (this.colonPos < 0) {
            return false;
        }
        return this.colonPos == this.namespacePrefixStart + namespacePrefix.length() && this.resourceUrl.startsWith(namespacePrefix, this.namespacePrefixStart);
    }
}

