/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ProgressManagerAdapter;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ResourceSerializationUtil {
    private static final Logger LOG = Logger.getInstance(ResourceSerializationUtil.class);

    public static void createPersistentCache(Path cacheFile, byte[] fileHeader, Base128StreamWriter contentWriter) {
        Path tempFile;
        try {
            Files.deleteIfExists(cacheFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to delete " + cacheFile.toString(), (Throwable)e);
        }
        try {
            cacheFile.getParent().toFile().mkdirs();
            tempFile = Files.createTempFile(cacheFile.getParent().toAbsolutePath(), cacheFile.getFileName().toString(), ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Unable to create a temporary file in " + cacheFile.getParent().toString(), (Throwable)e);
            return;
        }
        try (Base128OutputStream stream = new Base128OutputStream(tempFile);){
            stream.write(fileHeader);
            contentWriter.write(stream);
        }
        catch (Throwable e) {
            LOG.error("Unable to create cache file " + tempFile.toString(), e);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
            return;
        }
        try {
            Files.move(tempFile, cacheFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            LOG.error("Unable to create cache file " + cacheFile.toString(), (Throwable)e);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
        }
    }

    public static void writeResourcesToStream(Map<ResourceType, ListMultimap<String, ResourceItem>> resources, Base128OutputStream stream, Predicate<FolderConfiguration> configFilter) throws IOException {
        FolderConfiguration configuration;
        Object2IntOpenHashMap qualifierStringIndexes = new Object2IntOpenHashMap();
        qualifierStringIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap sourceFileIndexes = new Object2IntOpenHashMap();
        sourceFileIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap namespaceResolverIndexes = new Object2IntOpenHashMap();
        namespaceResolverIndexes.defaultReturnValue(-1);
        int itemCount = 0;
        Collection<ListMultimap<String, ResourceItem>> resourceMaps = resources.values();
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                ResourceSourceFile sourceFile;
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                String qualifier = configuration.getQualifierString();
                if (!qualifierStringIndexes.containsKey((Object)qualifier)) {
                    qualifierStringIndexes.put((Object)qualifier, qualifierStringIndexes.size());
                }
                if (item instanceof BasicValueResourceItemBase && !sourceFileIndexes.containsKey((Object)(sourceFile = ((BasicValueResourceItemBase)item).getSourceFile()))) {
                    sourceFileIndexes.put((Object)sourceFile, sourceFileIndexes.size());
                }
                if (item instanceof ResourceValue) {
                    ResourceSerializationUtil.addToNamespaceResolverIndexes(((ResourceValue)item).getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                }
                if (item instanceof BasicStyleResourceItem) {
                    for (StyleItemResourceValue styleItem : ((BasicStyleResourceItem)item).getDefinedItems()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(styleItem.getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                    }
                } else if (item instanceof BasicStyleableResourceItem) {
                    for (AttrResourceValue attr : ((BasicStyleableResourceItem)item).getAllAttributes()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(attr.getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                    }
                }
                ++itemCount;
            }
        }
        ResourceSerializationUtil.writeStrings((Object2IntMap<String>)qualifierStringIndexes, stream);
        ResourceSerializationUtil.writeSourceFiles((Object2IntMap<ResourceSourceFile>)sourceFileIndexes, stream, (Object2IntMap<String>)qualifierStringIndexes);
        ResourceSerializationUtil.writeNamespaceResolvers((Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes, stream);
        stream.writeInt(itemCount);
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                ((BasicResourceItemBase)item).serialize(stream, (Object2IntMap<String>)qualifierStringIndexes, (Object2IntMap<ResourceSourceFile>)sourceFileIndexes, (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
            }
        }
    }

    private static void addToNamespaceResolverIndexes(ResourceNamespace.Resolver resolver, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) {
        if (!namespaceResolverIndexes.containsKey((Object)resolver)) {
            namespaceResolverIndexes.put((Object)resolver, namespaceResolverIndexes.size());
        }
    }

    public static void readResourcesFromStream(Base128InputStream stream, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache, LoadableResourceRepository repository2, Consumer<BasicResourceItem> resourceConsumer) throws IOException {
        stream.setStringCache(stringCache);
        int n = stream.readInt();
        if (n == 0) {
            return;
        }
        ArrayList<RepositoryConfiguration> configurations = new ArrayList<RepositoryConfiguration>(n);
        for (int i = 0; i < n; ++i) {
            String configQualifier = stream.readString();
            if (configQualifier == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForQualifierString((String)configQualifier);
            if (folderConfig == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            configurations.add(new RepositoryConfiguration(repository2, folderConfig));
        }
        n = stream.readInt();
        ArrayList<ResourceSourceFile> newSourceFiles = new ArrayList<ResourceSourceFile>(n);
        for (int i = 0; i < n; ++i) {
            ResourceSourceFile sourceFile = repository2.deserializeResourceSourceFile(stream, configurations);
            newSourceFiles.add(sourceFile);
        }
        n = stream.readInt();
        ArrayList<ResourceNamespace.Resolver> newNamespaceResolvers = new ArrayList<ResourceNamespace.Resolver>(n);
        for (int i = 0; i < n; ++i) {
            NamespaceResolver namespaceResolver = NamespaceResolver.deserialize(stream);
            if (namespaceResolverCache != null) {
                namespaceResolver = namespaceResolverCache.computeIfAbsent(namespaceResolver, Function.identity());
            }
            newNamespaceResolvers.add(namespaceResolver);
        }
        n = stream.readInt();
        int cancellationCheckInterval = 500;
        for (int i = 0; i < n; ++i) {
            if (i % cancellationCheckInterval == 0) {
                ProgressManagerAdapter.checkCanceled();
            }
            BasicResourceItemBase item = BasicResourceItemBase.deserialize(stream, configurations, newSourceFiles, newNamespaceResolvers);
            resourceConsumer.accept(item);
        }
    }

    public static byte[] getCacheFileHeader(Base128StreamWriter headerWriter) {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream((OutputStream)header);){
            headerWriter.write(stream);
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
        return header.toByteArray();
    }

    private static void deleteIgnoringErrors(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeStrings(Object2IntMap<String> qualifierStringIndexes, Base128OutputStream stream) throws IOException {
        String[] strings = new String[qualifierStringIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(qualifierStringIndexes)) {
            strings[entry.getIntValue()] = (String)entry.getKey();
        }
        stream.writeInt(strings.length);
        for (String str : strings) {
            stream.writeString(str);
        }
    }

    private static void writeSourceFiles(Object2IntMap<ResourceSourceFile> sourceFileIndexes, Base128OutputStream stream, Object2IntMap<String> qualifierStringIndexes) throws IOException {
        ResourceSourceFile[] sourceFiles = new ResourceSourceFile[sourceFileIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(sourceFileIndexes)) {
            sourceFiles[entry.getIntValue()] = (ResourceSourceFile)entry.getKey();
        }
        stream.writeInt(sourceFiles.length);
        for (ResourceSourceFile sourceFile : sourceFiles) {
            sourceFile.serialize(stream, qualifierStringIndexes);
        }
    }

    private static void writeNamespaceResolvers(Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes, Base128OutputStream stream) throws IOException {
        ResourceNamespace.Resolver[] resolvers = new ResourceNamespace.Resolver[namespaceResolverIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(namespaceResolverIndexes)) {
            resolvers[entry.getIntValue()] = (ResourceNamespace.Resolver)entry.getKey();
        }
        stream.writeInt(resolvers.length);
        for (ResourceNamespace.Resolver resolver : resolvers) {
            NamespaceResolver serializableResolver = resolver == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver;
            serializableResolver.serialize(stream);
        }
    }

    public static interface Base128StreamWriter {
        public void write(Base128OutputStream var1) throws IOException;
    }
}

