/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Objects;

public class BasicValueResourceItem
extends BasicValueResourceItemBase {
    private final String myValue;

    public BasicValueResourceItem(ResourceType type, String name, ResourceSourceFile sourceFile, ResourceVisibility visibility, String value) {
        super(type, name, sourceFile, visibility);
        this.myValue = value;
    }

    @Override
    public String getValue() {
        return this.myValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicValueResourceItem other = (BasicValueResourceItem)obj;
        return Objects.equals(this.myValue, other.myValue);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)Objects.hashCode(this.myValue));
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myValue);
        String rawXmlValue = this.getRawXmlValue();
        stream.writeString(Objects.equals(rawXmlValue, this.myValue) ? null : rawXmlValue);
        String renderingValue = this.getRenderingValue();
        stream.writeString(Objects.equals(renderingValue, this.myValue) ? null : renderingValue);
    }

    static BasicValueResourceItem deserialize(Base128InputStream stream, ResourceType resourceType, String name, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver) throws IOException {
        String value = stream.readString();
        String rawXmlValue = stream.readString();
        String renderingValue = stream.readString();
        BasicValueResourceItem item = rawXmlValue == null ? new BasicValueResourceItem(resourceType, name, sourceFile, visibility, value) : new BasicTextValueResourceItem(resourceType, name, sourceFile, visibility, value, rawXmlValue, renderingValue);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

