/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.resources.aar.FrameworkResourceRepository;
import com.android.utils.Base128OutputStream;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FrameworkResJarCreator {
    public static void main(String[] args) {
        if (args.length != 3) {
            FrameworkResJarCreator.printUsage(FrameworkResJarCreator.class.getName());
            System.exit(1);
        }
        Path resDirectory = Paths.get(args[0], new String[0]).toAbsolutePath().normalize();
        Path overlaysDirectory = Paths.get(args[1], new String[0]).toAbsolutePath().normalize();
        Path jarFile = Paths.get(args[2], new String[0]).toAbsolutePath().normalize();
        try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            FrameworkResJarCreator.createJar(resDirectory, zip, "");
            try (Stream<Path> overlays = Files.list(overlaysDirectory);){
                overlays.sorted().forEach(path -> {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        return;
                    }
                    String overlayName = path.getFileName().toString();
                    try {
                        FrameworkResJarCreator.createJar(path.resolve("res"), zip, "overlays/" + overlayName + "/");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void createJar(Path resDirectory, ZipOutputStream zip, String subDir) throws IOException {
        FrameworkResourceRepository repository2 = FrameworkResourceRepository.create(resDirectory, null, null, false);
        Set<String> languages = repository2.getLanguageGroups();
        for (String language : languages) {
            String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
            FrameworkResJarCreator.createZipEntry(subDir + entryName, FrameworkResJarCreator.getEncodedResources(repository2, language), zip);
        }
        Path parentDir = resDirectory.getParent();
        List<Path> files = FrameworkResJarCreator.getContainedFiles(resDirectory);
        for (Path file : files) {
            String relativePath = parentDir.relativize(file).toString().replace('\\', '/');
            if (relativePath.equals("res/version") || relativePath.equals("res/BUILD")) continue;
            FrameworkResJarCreator.createZipEntry(subDir + relativePath, Files.readAllBytes(file), zip);
        }
    }

    private static List<Path> getContainedFiles(Path resDirectory) throws IOException {
        final ArrayList<Path> files = new ArrayList<Path>();
        Files.walkFileTree(resDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                files.add(file);
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(files);
        return files;
    }

    private static void createZipEntry(String name, byte[] content, ZipOutputStream zip) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        zip.putNextEntry(entry);
        zip.write(content);
        zip.closeEntry();
    }

    private static byte[] getEncodedResources(FrameworkResourceRepository repository2, String language) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream((OutputStream)byteStream);){
            repository2.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config)));
        }
        return byteStream.toByteArray();
    }

    private static void printUsage(String programName) {
        System.out.printf("Usage: %s <base_res_directory> <overlays_directory> <jar_file>%n", programName);
    }
}

