/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.IsObsoleteCmd;
import com.android.jdwppacket.IsObsoleteReply;
import com.android.jdwppacket.LineTableCmd;
import com.android.jdwppacket.LineTableReply;
import com.android.jdwppacket.MessageReader;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetMethod
extends CmdSet {
    protected CmdSetMethod() {
        super(6, "METHOD");
        this.add(1, "LineTable", CmdSetMethod::parseLineTableCmd, CmdSetMethod::parseLineTableReply);
        this.add(2, "VariableTable");
        this.add(3, "Bytecodes");
        this.add(4, "IsObsolete", CmdSetMethod::parseIsObsoleteCmd, CmdSetMethod::parseIsObsoleteReply);
        this.add(5, "VariableTableWithGenerics");
    }

    private static Message parseIsObsoleteReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        IsObsoleteReply reply = IsObsoleteReply.parse(reader);
        message.addArg("isObsolete", Boolean.toString(reply.getObsolete()));
        return message;
    }

    private static Message parseIsObsoleteCmd(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        IsObsoleteCmd cmd = IsObsoleteCmd.parse(reader);
        message.addArg("refType", cmd.getRefType());
        message.addArg("methodID", cmd.getMethodID());
        return message;
    }

    private static Message parseLineTableReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        LineTableReply reply = LineTableReply.parse(reader);
        message.addArg("start", reply.getStart());
        message.addArg("end", reply.getEnd());
        JsonArray linesJson = new JsonArray();
        message.addArg("lines", (JsonElement)linesJson);
        for (LineTableReply.Line line : reply.getLines()) {
            JsonObject lineJson = new JsonObject();
            linesJson.add((JsonElement)lineJson);
            lineJson.addProperty("lineCodeIndex", (Number)line.getLineCodeIndex());
            lineJson.addProperty("lineNumber", (Number)line.getLineNumber());
        }
        return message;
    }

    private static Message parseLineTableCmd(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        LineTableCmd cmd = LineTableCmd.parse(reader);
        message.addArg("refType", cmd.getRefType());
        message.addArg("methodID", cmd.getMethodID());
        return message;
    }
}

