/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogCatHeaderParser {
    private static final Pattern EPOCH = Pattern.compile("(?<epoch>(?<epochSec>\\d+)\\.(?<epochMilli>\\d\\d\\d))");
    private static final Pattern DATE = Pattern.compile("(?<month>\\d\\d)-(?<day>\\d\\d)");
    private static final Pattern TIME = Pattern.compile("(?<hour>\\d\\d):(?<min>\\d\\d):(?<sec>\\d\\d)\\.(?<milli>\\d\\d\\d)");
    private static final Pattern PID = Pattern.compile("(?<pid>\\d+)");
    private static final Pattern TID = Pattern.compile("(?<tid>\\w+)");
    private static final Pattern PRIORITY = Pattern.compile("(?<priority>[VDIWEAF])");
    private static final Pattern TAG = Pattern.compile("(?<tag>.*?)");
    private static final String UNKNOWN_APP_NAME = "?";
    private static final Pattern HEADER = Pattern.compile(String.format("^\\[ +((%s +%s)|(%s)) +%s: *%s +%s/%s +]$", DATE, TIME, EPOCH, PID, TID, PRIORITY, TAG));
    private final int defaultYear;
    private final ZoneId defaultZoneId;

    public LogCatHeaderParser() {
        this(ZonedDateTime.now().getYear(), ZoneId.systemDefault());
    }

    public LogCatHeaderParser(int year, ZoneId id) {
        this.defaultYear = year;
        this.defaultZoneId = id;
    }

    public LogCatHeader parseHeader(String line, IDevice device2) {
        return this.parseHeader(line, (int pid) -> this.getPackageName(device2, pid));
    }

    public LogCatHeader parseHeader(String line, PidToPackageName pidToPackageName) {
        Matcher m = HEADER.matcher(line);
        if (!m.matches()) {
            return null;
        }
        String epoch = m.group("epoch");
        Instant timestamp = epoch != null ? Instant.ofEpochSecond(this.parseEpochSeconds(m.group("epochSec")), TimeUnit.MILLISECONDS.toNanos(Long.parseLong(m.group("epochMilli")))) : Instant.from(ZonedDateTime.of(this.defaultYear, Integer.parseInt(m.group("month")), Integer.parseInt(m.group("day")), Integer.parseInt(m.group("hour")), Integer.parseInt(m.group("min")), Integer.parseInt(m.group("sec")), (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(m.group("milli"))), this.defaultZoneId));
        int pid = this.parsePid(m.group("pid"));
        return new LogCatHeader(this.parsePriority(m.group("priority")), pid, this.parseThreadId(m.group("tid")), pidToPackageName.apply(pid), m.group("tag"), timestamp);
    }

    private Log.LogLevel parsePriority(String string2) {
        Log.LogLevel priority = Log.LogLevel.getByLetterString(string2);
        if (priority != null) {
            return priority;
        }
        if (!string2.equals("F")) {
            return Log.LogLevel.WARN;
        }
        return Log.LogLevel.ASSERT;
    }

    private int parseThreadId(String string2) {
        try {
            return Integer.decode(string2);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private int parsePid(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private long parseEpochSeconds(String string2) {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException exception) {
            return 0L;
        }
    }

    private String getPackageName(IDevice device2, int pid) {
        if (device2 == null) {
            return UNKNOWN_APP_NAME;
        }
        String clientName = device2.getClientName(pid);
        if (clientName == null || clientName.isEmpty()) {
            return UNKNOWN_APP_NAME;
        }
        return clientName;
    }

    @FunctionalInterface
    public static interface PidToPackageName {
        public String apply(int var1);
    }
}

