/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.AdbSocketUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@VisibleForTesting
public class DeviceListMonitorTask
implements Runnable {
    private static final String ADB_TRACK_DEVICES_COMMAND = "host:track-devices";
    private final byte[] mLengthBuffer = new byte[4];
    private final AndroidDebugBridge mBridge;
    private final UpdateListener mListener;
    private final boolean mEmitDeviceListUpdates;
    private volatile SocketChannel mAdbConnection = null;
    private boolean mMonitoring = false;
    private int mConnectionAttempt = 0;
    private int mRestartAttemptCount = 0;
    private Stopwatch mAdbDisconnectionStopwatch;
    private boolean mInitialDeviceListDone = false;
    private volatile boolean mQuit;

    DeviceListMonitorTask(AndroidDebugBridge bridge, UpdateListener listener2, boolean emitDeviceListUpdates) {
        this.mBridge = bridge;
        this.mListener = listener2;
        this.mEmitDeviceListUpdates = emitDeviceListUpdates;
    }

    @Override
    public void run() {
        do {
            if (this.mAdbConnection == null) {
                Log.d("DeviceMonitor", "Opening adb connection");
                try {
                    this.mAdbConnection = AndroidDebugBridge.openConnection();
                }
                catch (IOException exception) {
                    Log.d("DeviceMonitor", "Unable to open connection to ADB server: " + exception);
                }
                if (this.mAdbConnection == null) {
                    ++this.mConnectionAttempt;
                    if (this.mConnectionAttempt == 1) {
                        Log.e("DeviceMonitor", "Cannot reach ADB server, attempting to reconnect.");
                        this.mAdbDisconnectionStopwatch = Stopwatch.createStarted();
                        if (AndroidDebugBridge.isUserManagedAdbMode()) {
                            Log.i("DeviceMonitor", "Will not automatically restart the ADB server because ddmlib is in user managed mode");
                        }
                    }
                    if (!AndroidDebugBridge.isUserManagedAdbMode() && this.mConnectionAttempt > 10) {
                        if (!this.mBridge.startAdb(20000L, TimeUnit.MILLISECONDS)) {
                            ++this.mRestartAttemptCount;
                        } else {
                            Log.i("DeviceMonitor", "adb restarted");
                            this.mRestartAttemptCount = 0;
                        }
                    }
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                } else {
                    if (this.mConnectionAttempt > 0) {
                        Log.i("DeviceMonitor", "ADB connection re-established after " + this.mAdbDisconnectionStopwatch.elapsed(TimeUnit.SECONDS) + " seconds.");
                        this.mAdbDisconnectionStopwatch.reset();
                    } else {
                        Log.i("DeviceMonitor", "Connected to adb for device monitoring");
                    }
                    this.mConnectionAttempt = 0;
                }
            }
            try {
                if (this.mAdbConnection != null && !this.mMonitoring) {
                    this.mMonitoring = this.sendDeviceListMonitoringRequest();
                }
            }
            catch (AsynchronousCloseException exception) {
            }
            catch (TimeoutException | IOException ex) {
                this.handleExceptionInInitialDeviceListBuilding(ex, this.mListener::initializationError);
            }
            try {
                int length;
                if (this.mAdbConnection == null || !this.mMonitoring || (length = AdbSocketUtils.readLength(this.mAdbConnection, this.mLengthBuffer)) < 0) continue;
                this.processIncomingDeviceData(length);
                this.mInitialDeviceListDone = true;
            }
            catch (AsynchronousCloseException length) {
            }
            catch (IOException ex) {
                this.handleExceptionInInitialDeviceListBuilding(ex, this.mListener::listFetchError);
            }
        } while (!this.mQuit);
    }

    private boolean sendDeviceListMonitoringRequest() throws TimeoutException, IOException {
        byte[] request2 = AdbHelper.formAdbRequest(ADB_TRACK_DEVICES_COMMAND);
        try {
            AdbHelper.write(this.mAdbConnection, request2);
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(this.mAdbConnection, false);
            if (!resp.okay) {
                Log.e("DeviceMonitor", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (IOException e) {
            Log.e("DeviceMonitor", "Sending Tracking request failed!");
            this.mAdbConnection.close();
            throw e;
        }
    }

    private void handleExceptionInInitialDeviceListBuilding(Exception e, Consumer<Exception> errorHandler) {
        if (!this.mQuit) {
            if (e instanceof TimeoutException) {
                Log.e("DeviceMonitor", "Adb connection Error: timeout");
            } else {
                Log.e("DeviceMonitor", "Adb connection Error:" + e.getMessage());
            }
            this.mMonitoring = false;
            if (this.mAdbConnection != null) {
                this.closeConnection();
                this.mAdbConnection = null;
                errorHandler.accept(e);
            }
        }
    }

    private void processIncomingDeviceData(int length) throws IOException {
        Map<String, IDevice.DeviceState> result2;
        if (length <= 0) {
            result2 = Collections.emptyMap();
        } else {
            String response = AdbSocketUtils.read(this.mAdbConnection, new byte[length]);
            result2 = DeviceListMonitorTask.parseDeviceListResponse(response);
        }
        if (this.mEmitDeviceListUpdates) {
            this.mListener.deviceListUpdate(result2);
        }
    }

    @VisibleForTesting
    public static Map<String, IDevice.DeviceState> parseDeviceListResponse(String result2) {
        String[] devices2;
        HashMap deviceStateMap = Maps.newHashMap();
        for (String d : devices2 = result2 == null ? new String[]{} : result2.split("\n")) {
            String[] param = d.split("\t");
            if (param.length != 2) continue;
            deviceStateMap.put(param[0], IDevice.DeviceState.getState(param[1]));
        }
        return deviceStateMap;
    }

    boolean isMonitoring() {
        return this.mMonitoring;
    }

    boolean hasInitialDeviceList() {
        return this.mInitialDeviceListDone;
    }

    int getConnectionAttemptCount() {
        return this.mConnectionAttempt;
    }

    int getRestartAttemptCount() {
        return this.mRestartAttemptCount;
    }

    public void stop() {
        this.mQuit = true;
        this.closeConnection();
    }

    private void closeConnection() {
        SocketChannel adbConnection = this.mAdbConnection;
        if (adbConnection != null) {
            try {
                adbConnection.close();
            }
            catch (IOException e) {
                Log.i("DeviceMonitor", "Adb close connection Error: " + e.getMessage());
            }
        }
    }

    static interface UpdateListener {
        public void initializationError(Exception var1);

        public void listFetchError(Exception var1);

        public void deviceListUpdate(Map<String, IDevice.DeviceState> var1);
    }
}

