/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003J\u0016\u0010'\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006-"}, d2={"Lcom/android/adblib/utils/ResizableBuffer;", "", "initialCapacity", "", "maxCapacity", "<init>", "(II)V", "buffer", "Ljava/nio/ByteBuffer;", "position", "getPosition", "()I", "capacity", "getCapacity", "get", "", "index", "clear", "", "clearToPosition", "newPosition", "forChannelWrite", "forChannelRead", "length", "afterChannelRead", "useMarkedPosition", "", "appendBytes", "src", "", "appendString", "value", "", "charset", "Ljava/nio/charset/Charset;", "appendByte", "appendShort", "", "appendInt", "setInt", "ensureRoom", "order", "bo", "Ljava/nio/ByteOrder;", "Companion", "android.sdktools.adblib"})
public final class ResizableBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxCapacity;
    @NotNull
    private ByteBuffer buffer;

    public ResizableBuffer(int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        ByteBuffer byteBuffer = ByteBuffer.allocate(initialCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        this.buffer = byteBuffer;
    }

    public /* synthetic */ ResizableBuffer(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 256;
        }
        if ((n3 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        this(n, n2);
    }

    public final int getPosition() {
        return this.buffer.position();
    }

    public final int getCapacity() {
        return this.buffer.capacity();
    }

    public final byte get(int index2) {
        return this.buffer.get(index2);
    }

    public final void clear() {
        this.buffer.clear();
    }

    public final void clearToPosition(int newPosition) {
        this.buffer.clear();
        this.buffer.position(newPosition);
    }

    @NotNull
    public final ByteBuffer forChannelWrite() {
        if (this.buffer.limit() != this.buffer.capacity()) {
            throw new IllegalStateException("Buffer has not been reset and can't be used for a write operation");
        }
        this.buffer.flip();
        return this.buffer;
    }

    @NotNull
    public final ByteBuffer forChannelRead(int length) {
        boolean bl;
        if (length < 0) {
            throw new IllegalArgumentException("Length should be greater or equal to 0");
        }
        if (this.buffer.limit() != this.buffer.capacity()) {
            throw new IllegalStateException("Buffer has not been reset and can't be used for a read operation");
        }
        this.ensureRoom(length);
        this.buffer.limit(this.buffer.position() + length);
        this.buffer.mark();
        boolean bl2 = bl = this.buffer.remaining() == length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.buffer;
    }

    @NotNull
    public final ByteBuffer afterChannelRead(boolean useMarkedPosition) {
        try {
            if (useMarkedPosition) {
                int newLimit = this.buffer.position();
                this.buffer.reset();
                int mark = this.buffer.position();
                this.buffer.rewind();
                this.buffer.position(mark);
                v0 = this.buffer.limit(newLimit);
            } else {
                v0 = this.buffer.flip();
            }
        }
        catch (InvalidMarkException e) {
            throw new IllegalStateException("Buffer has not been prepared for a read operation", e);
        }
        return this.buffer;
    }

    public static /* synthetic */ ByteBuffer afterChannelRead$default(ResizableBuffer resizableBuffer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return resizableBuffer.afterChannelRead(bl);
    }

    public final void appendBytes(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.ensureRoom(src.length);
        this.buffer.put(src);
    }

    public final void appendBytes(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.ensureRoom(src.remaining());
        this.buffer.put(src);
    }

    public final void appendString(@NotNull String value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        ByteBuffer byteBuffer = charset.encode(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"encode(...)");
        this.appendBytes(byteBuffer);
    }

    public final void appendByte(byte value) {
        this.ensureRoom(1);
        this.buffer.put(value);
    }

    public final void appendShort(short value) {
        this.ensureRoom(2);
        this.buffer.putShort(value);
    }

    public final void appendInt(int value) {
        this.ensureRoom(4);
        this.buffer.putInt(value);
    }

    public final void setInt(int index2, int value) {
        this.buffer.putInt(index2, value);
    }

    private final void ensureRoom(int length) {
        this.buffer = Companion.growBuffer(this.buffer, length, this.maxCapacity);
    }

    @NotNull
    public final ResizableBuffer order(@NotNull ByteOrder bo) {
        Intrinsics.checkNotNullParameter((Object)bo, (String)"bo");
        this.buffer.order(bo);
        return this;
    }

    public ResizableBuffer() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/adblib/utils/ResizableBuffer$Companion;", "", "<init>", "()V", "growBuffer", "Ljava/nio/ByteBuffer;", "buffer", "length", "", "maxCapacity", "nextCapacity", "byteBuffer", "atLeastCapacity", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteBuffer growBuffer(@NotNull ByteBuffer buffer, int length, int maxCapacity) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            boolean bl3 = bl2 = buffer.limit() == buffer.capacity();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (maxCapacity < 0) {
                throw new IllegalArgumentException("Maximum capacity must be a positive value");
            }
            if (length < 0) {
                throw new IllegalArgumentException("Length must be a positive value");
            }
            if (buffer.remaining() >= length) {
                return buffer;
            }
            if (buffer.capacity() >= maxCapacity) {
                throw new IllegalArgumentException("Buffer cannot grow as it has reached maximum capacity");
            }
            if (buffer.position() + length > maxCapacity) {
                throw new IllegalArgumentException("Buffer cannot grow to additional requested capacity");
            }
            int newCapacity = this.nextCapacity(buffer, buffer.position() + length, maxCapacity);
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            newBuffer.order(buffer.order());
            buffer.flip();
            newBuffer.put(buffer);
            boolean bl4 = bl = newBuffer.limit() == newBuffer.capacity();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl5 = bl = newBuffer.remaining() >= length;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            Intrinsics.checkNotNull((Object)newBuffer);
            return newBuffer;
        }

        private final int nextCapacity(ByteBuffer byteBuffer, int atLeastCapacity, int maxCapacity) {
            int capacity;
            for (capacity = RangesKt.coerceAtLeast((int)byteBuffer.capacity(), (int)1); capacity < atLeastCapacity; capacity *= 2) {
            }
            return RangesKt.coerceAtMost((int)capacity, (int)maxCapacity);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

