/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0015J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/android/adblib/utils/CircularByteBuffer;", "", "size", "", "<init>", "(I)V", "buffer", "", "startOffset", "endOffset", "value", "getSize", "()I", "remaining", "getRemaining", "capacity", "getCapacity", "clear", "", "write", "sourceBuffer", "Ljava/nio/ByteBuffer;", "read", "targetBuffer", "writeNBytes", "count", "readNBytes", "incOffset", "offset", "android.sdktools.adblib"})
public final class CircularByteBuffer {
    @NotNull
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int size;

    public CircularByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public /* synthetic */ CircularByteBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        this(n);
    }

    public final int getSize() {
        return this.size;
    }

    public final int getRemaining() {
        return this.buffer.length - this.size;
    }

    public final int getCapacity() {
        return this.buffer.length;
    }

    public final void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.size = 0;
    }

    public final int write(@NotNull ByteBuffer sourceBuffer) {
        Intrinsics.checkNotNullParameter((Object)sourceBuffer, (String)"sourceBuffer");
        int copyLength = Math.min(this.getRemaining(), sourceBuffer.remaining());
        int copyLength1 = Math.min(copyLength, this.getCapacity() - this.endOffset);
        this.writeNBytes(sourceBuffer, copyLength1);
        int copyLength2 = copyLength - copyLength1;
        this.writeNBytes(sourceBuffer, copyLength2);
        return copyLength;
    }

    public final int read(@NotNull ByteBuffer targetBuffer) {
        Intrinsics.checkNotNullParameter((Object)targetBuffer, (String)"targetBuffer");
        int copyLength = Math.min(this.size, targetBuffer.remaining());
        int copyLength1 = Math.min(copyLength, this.getCapacity() - this.startOffset);
        this.readNBytes(targetBuffer, copyLength1);
        int copyLength2 = copyLength - copyLength1;
        this.readNBytes(targetBuffer, copyLength2);
        return copyLength;
    }

    private final void writeNBytes(ByteBuffer sourceBuffer, int count) {
        boolean bl;
        boolean bl2 = bl = count >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (count > 0) {
            sourceBuffer.get(this.buffer, this.endOffset, count);
            this.endOffset = this.incOffset(this.endOffset, count);
            this.size += count;
        }
    }

    private final void readNBytes(ByteBuffer targetBuffer, int count) {
        boolean bl;
        boolean bl2 = bl = count >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (count > 0) {
            targetBuffer.put(this.buffer, this.startOffset, count);
            this.startOffset = this.incOffset(this.startOffset, count);
            this.size -= count;
        }
    }

    private final int incOffset(int offset, int count) {
        boolean bl;
        boolean bl2 = bl = offset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = offset < this.getCapacity();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl4 = bl = count >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        boolean bl5 = bl = count <= this.getCapacity();
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        int result2 = offset + count;
        return result2 >= this.buffer.length ? result2 - this.buffer.length : result2;
    }

    public CircularByteBuffer() {
        this(0, 1, null);
    }
}

