/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.utils;

import com.android.adblib.tools.debugging.packets.JdwpPacketUtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0006\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/tools/debugging/utils/ByteBufferHolder;", "", "initialCapacity", "", "<init>", "(I)V", "buffer", "Ljava/nio/ByteBuffer;", "clear", "", "position", "value", "limit", "remaining", "slice", "put", "duplicate", "capacity", "ensureCapacity", "minCapacity", "nextCapacity", "copyBuffer", "android.sdktools.adblib.tools"})
public final class ByteBufferHolder {
    @NotNull
    private ByteBuffer buffer;

    public ByteBufferHolder(int initialCapacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(initialCapacity).limit(0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"limit(...)");
        this.buffer = byteBuffer;
    }

    public /* synthetic */ ByteBufferHolder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final void clear() {
        this.buffer.clear();
    }

    public final void position(int value) {
        this.buffer.position(value);
    }

    public final int position() {
        return this.buffer.position();
    }

    public final void limit(int value) {
        this.buffer.limit(value);
    }

    public final int limit() {
        return this.buffer.limit();
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    @NotNull
    public final ByteBuffer slice() {
        ByteBuffer byteBuffer = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    @NotNull
    public final ByteBuffer put(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = this.buffer.put(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"put(...)");
        return byteBuffer;
    }

    @NotNull
    public final ByteBuffer duplicate() {
        ByteBuffer byteBuffer = this.buffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
        return byteBuffer;
    }

    public final int capacity() {
        return this.buffer.capacity();
    }

    public final void ensureCapacity(int minCapacity) {
        if (!(minCapacity >= 0)) {
            boolean $i$a$-require-ByteBufferHolder$ensureCapacity$22 = false;
            String $i$a$-require-ByteBufferHolder$ensureCapacity$22 = "Capacity should be a positive value";
            throw new IllegalArgumentException($i$a$-require-ByteBufferHolder$ensureCapacity$22.toString());
        }
        int newCapacity = this.nextCapacity(minCapacity);
        if (newCapacity != this.buffer.capacity()) {
            boolean bl;
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            newBuffer.order(this.buffer.order());
            boolean bl2 = bl = this.buffer.position() == this.buffer.limit();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.buffer.position(0);
            newBuffer.put(this.buffer);
            boolean bl3 = bl = this.buffer.position() == this.buffer.limit();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            newBuffer.position(this.buffer.limit());
            newBuffer.limit(this.buffer.limit());
            Intrinsics.checkNotNull((Object)newBuffer);
            this.buffer = newBuffer;
        }
    }

    private final int nextCapacity(int minCapacity) {
        int newCapacity;
        for (newCapacity = this.buffer.capacity(); newCapacity < minCapacity; newCapacity *= 2) {
        }
        return newCapacity;
    }

    @NotNull
    public final ByteBuffer copyBuffer() {
        return JdwpPacketUtilsKt.copy(this.buffer);
    }

    public ByteBufferHolder() {
        this(0, 1, null);
    }
}

