/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl.channels;

import com.android.adblib.AdbInputChannel;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/adblib/impl/channels/ByteBufferAdbInputChannelImpl;", "Lcom/android/adblib/AdbInputChannel;", "sourceBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "closed", "", "readBuffer", "", "buffer", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "android.sdktools.adblib"})
public final class ByteBufferAdbInputChannelImpl
implements AdbInputChannel {
    @NotNull
    private final ByteBuffer sourceBuffer;
    private boolean closed;

    public ByteBufferAdbInputChannelImpl(@NotNull ByteBuffer sourceBuffer) {
        Intrinsics.checkNotNullParameter((Object)sourceBuffer, (String)"sourceBuffer");
        this.sourceBuffer = sourceBuffer;
    }

    @Override
    @Nullable
    public Object readBuffer(@NotNull ByteBuffer buffer, long timeout, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> $completion) {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.sourceBuffer.remaining() == 0) {
            return Unit.INSTANCE;
        }
        int count = Integer.min(this.sourceBuffer.remaining(), buffer.remaining());
        int savedLimit = this.sourceBuffer.limit();
        this.sourceBuffer.limit(this.sourceBuffer.position() + count);
        buffer.put(this.sourceBuffer);
        this.sourceBuffer.limit(savedLimit);
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    @Nullable
    public Object readExactly(@NotNull ByteBuffer buffer, long timeout, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> $completion) {
        return AdbInputChannel.super.readExactly(buffer, timeout, unit, $completion);
    }
}

