/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.ddmlibcompatibility.debugging;

import com.android.adblib.ShellCollector;
import com.android.ddmlib.IShellOutputReceiver;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/adblib/ddmlibcompatibility/debugging/ShellCollectorToIShellOutputReceiver;", "Lcom/android/adblib/ShellCollector;", "", "receiver", "Lcom/android/ddmlib/IShellOutputReceiver;", "<init>", "(Lcom/android/ddmlib/IShellOutputReceiver;)V", "buf", "Lcom/android/adblib/ddmlibcompatibility/debugging/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "getBuf", "()Lcom/android/adblib/ddmlibcompatibility/debugging/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "start", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collect", "stdout", "Ljava/nio/ByteBuffer;", "(Lkotlinx/coroutines/flow/FlowCollector;Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "end", "ByteArrayFromByteBuffer", "android.sdktools.adblib.ddmlibcompatibility"})
public final class ShellCollectorToIShellOutputReceiver
implements ShellCollector<Unit> {
    @NotNull
    private final IShellOutputReceiver receiver;
    @NotNull
    private final ByteArrayFromByteBuffer buf;

    public ShellCollectorToIShellOutputReceiver(@NotNull IShellOutputReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        this.receiver = receiver;
        this.buf = new ByteArrayFromByteBuffer();
    }

    @NotNull
    public final ByteArrayFromByteBuffer getBuf() {
        return this.buf;
    }

    @Override
    @Nullable
    public Object start(@NotNull FlowCollector<? super Unit> collector, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object collect(@NotNull FlowCollector<? super Unit> collector, @NotNull ByteBuffer stdout2, @NotNull Continuation<? super Unit> $completion) {
        if (this.receiver.isCancelled()) {
            throw new CancellationException("IShellOutputReceiver was cancelled during shell command execution");
        }
        this.buf.convert(stdout2);
        this.receiver.addOutput(this.buf.getBytes(), this.buf.getOffset(), this.buf.getCount());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object end(@NotNull FlowCollector<? super Unit> collector, @NotNull Continuation<? super Unit> $completion) {
        this.receiver.flush();
        Object object = collector.emit((Object)Unit.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/android/adblib/ddmlibcompatibility/debugging/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "", "<init>", "()V", "bytes", "", "getBytes", "()[B", "setBytes", "([B)V", "offset", "", "getOffset", "()I", "setOffset", "(I)V", "count", "getCount", "setCount", "convert", "", "buffer", "Ljava/nio/ByteBuffer;", "android.sdktools.adblib.ddmlibcompatibility"})
    public static final class ByteArrayFromByteBuffer {
        @NotNull
        private byte[] bytes = new byte[0];
        private int offset;
        private int count;

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        public final void setBytes(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.bytes = byArray;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final void convert(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (buffer.hasArray()) {
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                this.bytes = byArray;
                this.offset = buffer.position();
                this.count = buffer.remaining();
            } else {
                this.offset = 0;
                this.count = buffer.remaining();
                byte[] bytes = new byte[this.count];
                buffer.get(bytes);
                this.bytes = bytes;
            }
        }
    }
}

