/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";

    @Nullable
    public static AndroidFacet getInstance(@NotNull VirtualFile file, @NotNull Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        return AndroidFacet.getInstance(module);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        return AndroidFacet.findAndroidFacet(context.getModule());
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        return AndroidFacet.findAndroidFacet(AndroidPsiUtils.getModuleSafely(element));
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        return AndroidFacet.findAndroidFacet(element.getModule());
    }

    @Nullable
    private static AndroidFacet findAndroidFacet(@Nullable Module module) {
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        return !module.isDisposed() ? (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID) : null;
    }

    public AndroidFacet(@NotNull Module module, @NotNull String name, @NotNull AndroidFacetConfiguration configuration) {
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        return (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
    }

    @NotNull
    public AndroidFacetProperties getProperties() {
        return ((AndroidFacetConfiguration)this.getConfiguration()).getState();
    }
}

