/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gservices;

import com.android.tools.idea.gservices.DevServicesDeprecationData;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u001a\u001a\u00020\nH&J\b\u0010\u001b\u001a\u00020\nH&J\b\u0010\u001c\u001a\u00020\nH&J\b\u0010\u001d\u001a\u00020\nH&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gservices/DeprecationBanner;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "deprecationData", "Lcom/android/tools/idea/gservices/DevServicesDeprecationData;", "moveActions", "", "closeAction", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/gservices/DevServicesDeprecationData;ZLkotlin/jvm/functions/Function0;)V", "getDeprecationData", "()Lcom/android/tools/idea/gservices/DevServicesDeprecationData;", "getCorrectedPreferredHeight", "", "getPreferredFullHeight", "Ljavax/swing/JComponent;", "moveActionLabels", "paintBorder", "g", "Ljava/awt/Graphics;", "scaled", "getScaled", "(I)I", "trackUserNotified", "trackUpdateClicked", "trackMoreInfoClicked", "trackBannerDismissed", "intellij.android.common"})
public abstract class DeprecationBanner
extends EditorNotificationPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final DevServicesDeprecationData deprecationData;
    private final boolean moveActions;
    @NotNull
    private final Function0<Unit> closeAction;

    public DeprecationBanner(@NotNull Project project, @NotNull DevServicesDeprecationData deprecationData, boolean moveActions, @NotNull Function0<Unit> closeAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deprecationData, (String)"deprecationData");
        Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
        super(deprecationData.isDeprecated() ? EditorNotificationPanel.Status.Warning : EditorNotificationPanel.Status.Error);
        this.project = project;
        this.deprecationData = deprecationData;
        this.moveActions = moveActions;
        this.closeAction = closeAction;
        this.setText("<html>" + this.deprecationData.getDescription() + "</html>");
        this.setOpaque(true);
        boolean hasAction = false;
        if (this.deprecationData.getShowUpdateAction()) {
            hasAction = true;
            this.createActionLabel("Update Android Studio", () -> DeprecationBanner._init_$lambda$1(this));
        }
        if (((CharSequence)this.deprecationData.getMoreInfoUrl()).length() > 0) {
            hasAction = true;
            this.createActionLabel("More info", () -> DeprecationBanner._init_$lambda$2(this));
        }
        if (this.moveActions && hasAction) {
            this.moveActionLabels();
        }
        this.setCloseAction(() -> DeprecationBanner._init_$lambda$3(this));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setPreferredSize((Dimension)new JBDimension(UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)((Object)this))), this.getCorrectedPreferredHeight()));
            }
        });
        EventQueue.invokeLater(() -> DeprecationBanner._init_$lambda$4(this));
    }

    public /* synthetic */ DeprecationBanner(Project project, DevServicesDeprecationData devServicesDeprecationData, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = DeprecationBanner::_init_$lambda$0;
        }
        this(project, devServicesDeprecationData, bl, (Function0<Unit>)function0);
    }

    @NotNull
    public final DevServicesDeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    public final int getCorrectedPreferredHeight() {
        int n;
        if (this.moveActions) {
            JLabel jLabel = this.myLabel;
            Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"myLabel");
            int n2 = this.getPreferredFullHeight(jLabel);
            JPanel jPanel = this.myLinksPanel;
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"myLinksPanel");
            n = n2 + this.getPreferredFullHeight(jPanel) + this.getScaled(20);
        } else {
            JLabel jLabel = this.myLabel;
            Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"myLabel");
            n = this.getPreferredFullHeight(jLabel) + this.getScaled(20);
        }
        return n;
    }

    private final int getPreferredFullHeight(JComponent $this$getPreferredFullHeight) {
        return UiSizeUtilKt.getPreferredHeight((JComponent)$this$getPreferredFullHeight) + $this$getPreferredFullHeight.getInsets().top + $this$getPreferredFullHeight.getInsets().bottom;
    }

    private final void moveActionLabels() {
        Container parent = this.myLinksPanel.getParent();
        if (parent.getLayout() instanceof BorderLayout) {
            this.myLabel.setVerticalTextPosition(1);
            parent.add((Component)this.myLinksPanel, "South");
            this.myLinksPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)(this.myLabel.getIcon().getIconWidth() + this.myLabel.getIconTextGap() - 2), (int)0, (int)0));
        }
    }

    protected void paintBorder(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintBorder(g);
        Graphics2D $this$paintBorder_u24lambda_u245 = (Graphics2D)g;
        boolean bl = false;
        Color color = this.deprecationData.isDeprecated() ? JBUI.CurrentTheme.Banner.WARNING_BORDER_COLOR : JBUI.CurrentTheme.Banner.ERROR_BORDER_COLOR;
        $this$paintBorder_u24lambda_u245.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        $this$paintBorder_u24lambda_u245.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)g).setColor(color);
        $this$paintBorder_u24lambda_u245.drawRect(this.getScaled(-5), 0, this.getWidth() + this.getScaled(10), this.getHeight() - this.getScaled(1));
    }

    private final int getScaled(int $this$scaled) {
        return JBUI.scale((int)$this$scaled);
    }

    public abstract void trackUserNotified();

    public abstract void trackUpdateClicked();

    public abstract void trackMoreInfoClicked();

    public abstract void trackBannerDismissed();

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(DeprecationBanner this$0) {
        UpdateChecker.updateAndShowResult$default((Project)this$0.project, null, (int)2, null);
        this$0.trackUpdateClicked();
    }

    private static final void _init_$lambda$2(DeprecationBanner this$0) {
        BrowserUtil.browse((String)this$0.deprecationData.getMoreInfoUrl());
        this$0.trackMoreInfoClicked();
    }

    private static final void _init_$lambda$3(DeprecationBanner this$0) {
        this$0.setVisible(false);
        this$0.closeAction.invoke();
        this$0.trackBannerDismissed();
    }

    private static final void _init_$lambda$4(DeprecationBanner this$0) {
        this$0.trackUserNotified();
    }
}

