/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.resources.ResourceType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContext;

public class AndroidPsiUtils {
    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull Project project, @NotNull VirtualFile file) {
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        });
    }

    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull SmartPsiElementPointer<PsiFile> psiFilePointer) {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> (PsiFile)psiFilePointer.getElement());
        if (psiFile == null || !psiFile.isValid()) {
            return null;
        }
        return psiFile;
    }

    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull Project project, @NotNull Document document) {
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        });
    }

    @Nullable
    public static Module getModuleSafely(@NotNull PsiElement element) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Module getModuleSafely(@NotNull Project project, @NotNull VirtualFile file) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        });
    }

    @Nullable
    public static XmlTag getRootTagSafely(@NotNull XmlFile file) {
        if (file.getProject().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return file.getRootTag();
        }
        return (XmlTag)ApplicationManager.getApplication().runReadAction(() -> ((XmlFile)file).getRootTag());
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(@NotNull Project project, @NotNull VirtualFile dir) {
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return PsiManager.getInstance((Project)project).findDirectory(dir);
        });
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(@NotNull PsiFile file) {
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction(() -> ((PsiFile)file).getParent());
    }

    @Nullable
    public static PsiElement getPsiParentSafely(@NotNull PsiElement element) {
        return (PsiElement)ApplicationManager.getApplication().runReadAction(() -> ((PsiElement)element).getParent());
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable PsiElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement parentElement = PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)strict);
        if (parentElement != null) {
            return (T)parentElement;
        }
        for (PsiElement psiElement = element; psiElement != null; psiElement = psiElement.getParent()) {
            T parentPsiElement;
            UElement uElement = ((UastContext)element.getProject().getService(UastContext.class)).convertElementWithParent(psiElement, UElement.class);
            if (uElement == null || (parentPsiElement = AndroidPsiUtils.getPsiParentOfType(uElement, parentClass, strict && psiElement == element)) == null) continue;
            return parentPsiElement;
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Sequence<T> getPsiParentsOfType(@NotNull PsiElement element, @NotNull Class<T> parentClass, boolean strict) {
        return SequencesKt.generateSequence(AndroidPsiUtils.getPsiParentOfType(element, parentClass, strict), e -> AndroidPsiUtils.getPsiParentOfType(e, parentClass, true));
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable UElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getUastParent();
        }
        while (element != null) {
            PsiElement psiElement = UElementKt.getAsJavaPsiElement((UElement)element, parentClass);
            if (psiElement != null) {
                return (T)((PsiElement)parentClass.cast(psiElement));
            }
            element = element.getUastParent();
        }
        return null;
    }

    public static boolean isResourceReference(@NotNull PsiElement element) {
        return AndroidPsiUtils.getResourceReferenceType(element) != ResourceReferenceType.NONE;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(@NotNull PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element);
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element.getParent());
        }
        return ResourceReferenceType.NONE;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiElement element) {
        PsiReferenceExpression refExp;
        String name;
        assert (AndroidPsiUtils.isResourceReference(element));
        if (element instanceof PsiReferenceExpression && (name = (refExp = (PsiReferenceExpression)element).getReferenceName()) != null) {
            return name;
        }
        return element.getText();
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(PsiReferenceExpression element) {
        PsiElement resolvedElement = element.resolve();
        if (resolvedElement == null) {
            return ResourceReferenceType.NONE;
        }
        PsiElement elementType = resolvedElement.getParent();
        if (!(elementType instanceof PsiClass)) {
            return ResourceReferenceType.NONE;
        }
        PsiElement elementPackage = elementType.getParent();
        if (!(elementPackage instanceof PsiClass)) {
            return ResourceReferenceType.NONE;
        }
        if ("R".equals(((PsiClass)elementPackage).getName())) {
            PsiElement elemParent3 = elementPackage.getParent();
            if (elemParent3 instanceof PsiClassOwner && "android".equals(((PsiClassOwner)elemParent3).getPackageName())) {
                return ResourceReferenceType.FRAMEWORK;
            }
            return ResourceReferenceType.APP;
        }
        return ResourceReferenceType.NONE;
    }

    @Nullable
    public static ResourceType getResourceType(PsiElement resourceRefElement) {
        if (!AndroidPsiUtils.isResourceReference(resourceRefElement)) {
            return null;
        }
        PsiReferenceExpression exp = resourceRefElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)resourceRefElement : (PsiReferenceExpression)resourceRefElement.getParent();
        PsiElement resolvedElement = exp.resolve();
        if (resolvedElement == null) {
            return null;
        }
        PsiElement elemParent = resolvedElement.getParent();
        if (!(elemParent instanceof PsiClass)) {
            return null;
        }
        return ResourceType.fromClassName((String)((PsiClass)elemParent).getName());
    }

    @Nullable
    public static String getQualifiedNameSafely(@NotNull PsiClass psiClass) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return psiClass.getQualifiedName();
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> ((PsiClass)psiClass).getQualifiedName());
    }

    @Nullable
    public static String getAttributeSafely(@NotNull XmlTag tag, @Nullable String namespace, @NotNull String name) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.getAttributeValue(name, namespace);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> tag.getAttributeValue(name, namespace));
    }

    public static boolean isValid(@NotNull XmlTag tag) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.isValid();
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)tag).isValid());
    }

    @NotNull
    public static ModificationTracker getXmlPsiModificationTracker(@NotNull Project project) {
        PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
        return psiTracker.forLanguage((Language)XMLLanguage.INSTANCE);
    }

    @NotNull
    public static ModificationTracker getPsiModificationTrackerIgnoringXml(@NotNull Project project) {
        PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
        return psiTracker.forLanguages(lang -> !lang.is((Language)XMLLanguage.INSTANCE) && !lang.is(Language.ANY));
    }

    @Nullable
    public static PsiType toPsiType(@NotNull PsiClass clazz) {
        return JavaPsiFacade.getElementFactory((Project)clazz.getProject()).createType(clazz);
    }

    @Nullable
    public static PsiReferenceExpression getPreviousInQualifiedChain(PsiReferenceExpression referenceExpression) {
        PsiExpression expression = referenceExpression.getQualifierExpression();
        return expression instanceof PsiReferenceExpression ? (PsiReferenceExpression)expression : null;
    }

    @NotNull
    public static PsiClass[] resolveClasses(@NotNull Project project, @NotNull String className) {
        PsiClass[] psiClasses = AndroidPsiUtils.getPsiClassesForOuterClass(project, className);
        if (psiClasses.length == 0) {
            return psiClasses;
        }
        String[] classNameComponents = className.split("\\$");
        if (classNameComponents.length == 1) {
            return psiClasses;
        }
        block0: for (int psiClassIndex = 0; psiClassIndex < psiClasses.length; ++psiClassIndex) {
            for (int i = 1; i < classNameComponents.length; ++i) {
                String innerClassName = classNameComponents[i];
                if (AndroidPsiUtils.startsWithInteger(innerClassName)) {
                    int innerClassIndex = AndroidPsiUtils.convertToClassIndex(innerClassName);
                    if (innerClassIndex < 0) {
                        AndroidPsiUtils.getLog().info("Attempted to resolve mismatched class name in hprof file: " + className);
                        continue block0;
                    }
                    CountDownAnonymousClassVisitor visitor = new CountDownAnonymousClassVisitor(innerClassIndex);
                    psiClasses[psiClassIndex].accept((PsiElementVisitor)visitor);
                    PsiAnonymousClass anonymousClass = visitor.getAnonymousClass();
                    if (anonymousClass == null) continue block0;
                    psiClasses[psiClassIndex] = anonymousClass;
                    continue;
                }
                PsiClass innerClass = psiClasses[psiClassIndex].findInnerClassByName(innerClassName, false);
                if (innerClass == null) continue block0;
                psiClasses[psiClassIndex] = innerClass;
            }
        }
        return psiClasses;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(AndroidPsiUtils.class);
    }

    @NotNull
    private static PsiClass[] getPsiClassesForOuterClass(@NotNull Project project, @NotNull String className) {
        String outerClassName = AndroidPsiUtils.getOuterClassName(className);
        if (outerClassName == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.projectScope((Project)project));
        if (psiClasses.length == 0) {
            psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.allScope((Project)project));
        }
        block0: for (int i = 0; i < psiClasses.length; ++i) {
            PsiClass[] sourcePsiClasses;
            PsiElement fileElement;
            PsiClass psiClass = psiClasses[i];
            if (psiClass.getQualifiedName() == null || !(psiClass instanceof PsiCompiledElement) || (fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement || !(fileElement instanceof PsiJavaFile)) continue;
            for (PsiClass sourcePsiClass : sourcePsiClasses = ((PsiJavaFile)fileElement).getClasses()) {
                if (!psiClass.getQualifiedName().equals(sourcePsiClass.getQualifiedName())) continue;
                psiClasses[i] = sourcePsiClass;
                continue block0;
            }
        }
        return psiClasses;
    }

    @Nullable
    private static String getOuterClassName(@NotNull String className) {
        int innerClassSymbolIndex = className.indexOf(36);
        if (innerClassSymbolIndex > 0) {
            return className.substring(0, innerClassSymbolIndex);
        }
        if (innerClassSymbolIndex == 0) {
            AndroidPsiUtils.getLog().warn("Invalid class name: starts with '$'");
            return null;
        }
        return className;
    }

    private static int convertToClassIndex(@NotNull String innerClassNameString) {
        try {
            return Integer.parseInt(innerClassNameString) - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean startsWithInteger(@NotNull String target) {
        return !target.isEmpty() && Character.isDigit(target.charAt(0));
    }

    public static enum ResourceReferenceType {
        NONE,
        APP,
        FRAMEWORK;

    }

    private static class CountDownAnonymousClassVisitor
    extends JavaRecursiveElementVisitor {
        @Nullable
        private PsiAnonymousClass myAnonymousClass;
        private int myAnonymousClassIndex;

        public CountDownAnonymousClassVisitor(int anonymousClassIndex) {
            this.myAnonymousClassIndex = anonymousClassIndex;
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (this.myAnonymousClassIndex == 0) {
                this.myAnonymousClass = aClass;
            }
            --this.myAnonymousClassIndex;
        }

        @Nullable
        public PsiAnonymousClass getAnonymousClass() {
            return this.myAnonymousClass;
        }
    }
}

