/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCExplicitSpecifier;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCDocUtil {
    private static final EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static final EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEXPR);
    private static final String[] structTypes = new String[]{"struct", "class", "union", "enum"};
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = symbol -> StringUtil.escapeXmlEntities((String)symbol.getPresentableName());

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(0);
        }
        return OCDocUtil.parameterSignature(type, param, null);
    }

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param, @Nullable String defValue) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param) && !param.isEmpty();
        sb.append(type);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        String string = sb.toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String delimiter(@NotNull String type) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(3);
        }
        return OCDocUtil.delimiter(type, " ");
    }

    @NlsSafe
    @NotNull
    public static String delimiter(@NotNull String type, @NotNull String del) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(4);
        }
        if (del == null) {
            OCDocUtil.$$$reportNull$$$0(5);
        }
        if (!(type.endsWith("*") || type.endsWith("&") || type.endsWith("&amp;"))) {
            String string = del;
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        return "";
    }

    private static void appendExplicitSpecifier(@NotNull OCFunctionDeclaration functionDeclaration, @NotNull HtmlBuilder sb) {
        OCCondition explicitCond;
        OCExplicitSpecifier explicitSpecifier;
        if (functionDeclaration == null) {
            OCDocUtil.$$$reportNull$$$0(7);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(8);
        }
        if ((explicitSpecifier = functionDeclaration.getExplicitSpecifier()) != null && (explicitCond = explicitSpecifier.getCondition()) != null) {
            sb.append("(").append(explicitCond.getTextWithMacros()).append(")");
        }
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull HtmlBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(9);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(10);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append(attr.toString()).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @Nullable OCFunctionDeclaration functionDeclaration, HtmlBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(11);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append(attr.toString());
            if (attr == OCSymbolAttribute.EXPLICIT && functionDeclaration != null) {
                OCDocUtil.appendExplicitSpecifier(functionDeclaration, sb);
            }
            sb.append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull HtmlBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(12);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(13);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append(attr.toString()).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCLexerTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull HtmlBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(14);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(15);
        }
        if (symbol.isConst()) {
            sb.append(" ").append(OCLexerTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append(attr.toString());
        }
    }

    @NotNull
    @NlsSafe
    public static String getParametersSignatureHtml(@NotNull OCFunctionSymbol symbol, boolean useSubstitution, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(17);
        }
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingPsiFile(context.getProject())));
                typeText = OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context);
            } else {
                typeText = param.getType().getCanonicalName(context);
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                OCInitializerSymbol init = Objects.requireNonNull(param.getInitializer());
                answer.append(" = ").append(init.getSignature(context.getProject()));
            }
            isFirst = false;
        }
        String string = answer.append(')').toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getCanonicalNameHtml(@NotNull OCType type, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context) {
        OCType ptrType;
        CVQualifiers qualifiers;
        OCType referenceType;
        OCType terminalType;
        OCType resolvedType;
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(19);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(21);
        }
        if (!((resolvedType = (terminalType = type.getTerminalType()).resolve(context)) instanceof OCStructType)) {
            String string = StringUtil.escapeXmlEntities((String)type.getCanonicalName(context));
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        OCQualifiedName originalName = terminalType instanceof OCReferenceType ? ((OCReferenceType)terminalType).getReference().getQualifiedName() : null;
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context.getElement(), (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        OCResolveContext fileContext = OCResolveContext.forPsi((PsiElement)context.getFile());
        String name = OCDocUtil.replaceAnonymousInQualifiedName(new OCTypeNameVisitor(OCType.Presentation.BEST, false, true, fileContext, 0).getName(resolvedType.resolve(fileContext)));
        OCType oCType = referenceType = parent == null ? null : OCElementFactory.typeElementFromText(name, (PsiElement)parent).getType();
        if (!(referenceType instanceof OCReferenceType)) {
            String string = StringUtil.escapeXmlEntities((String)type.getCanonicalName(context));
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        StringBuilder res = new StringBuilder();
        OCQualifiedName qualifiedName = ((OCReferenceType)referenceType).getReference().getQualifiedName();
        if (originalName != null && OCElementUtil.getQualifiedNameComplexity(originalName, 0, 1) > OCElementUtil.getQualifiedNameComplexity(qualifiedName, 0, 1)) {
            qualifiedName = originalName;
        }
        OCQualifiedName droppedPrefix = null;
        OCQualifiedName suffix = qualifiedName;
        for (OCSymbolWithQualifiedName ns : contextNamespace) {
            String qualifier = suffix.getLeftmostQualifier();
            if (qualifier == null || !qualifier.equals(ns.getName())) continue;
            droppedPrefix = OCQualifiedName.with(droppedPrefix, qualifier);
            suffix = suffix.dropSuperQualifier();
        }
        while (qualifiedName != null && !qualifiedName.equals(droppedPrefix)) {
            OCSymbol struct;
            HtmlBuilder part = new HtmlBuilder();
            List<OCSymbol> symbols = OCSymbolReference.getLocalReference(qualifiedName, context.getElement(), new OCSymbolReference.TrueSymbolFilter()).resolveToSymbols(context);
            if (symbols.isEmpty()) {
                symbols = OCSymbolReference.getLocalReference(qualifiedName.dropArguments(), context.getElement(), new OCSymbolReference.TrueSymbolFilter()).resolveToSymbols(context);
            }
            if ((struct = (OCSymbol)ContainerUtil.find(symbols, s -> s instanceof OCStructSymbol)) != null) {
                part.append(OCDocUtil.wrapSymbolName(struct));
            } else {
                if (!symbols.isEmpty() && symbols.get(0) instanceof OCFunctionSymbol) break;
                part.append(StringUtil.notNullize((String)qualifiedName.getName()));
            }
            if (qualifiedName instanceof OCQualifiedNameWithArguments) {
                OCDocUtil.wrapTemplateArgs(((OCQualifiedNameWithArguments)qualifiedName).getArguments(), contextNamespace, context, part);
            }
            if (!res.isEmpty()) {
                part.append("::");
            }
            res.insert(0, part);
            qualifiedName = qualifiedName.getQualifier();
        }
        CVQualifiers cVQualifiers = qualifiers = type instanceof OCCppReferenceType || type instanceof OCPointerType ? type.getTerminalType().getCVQualifiers() : type.getCVQualifiers();
        if (qualifiers.isVolatile()) {
            res.insert(0, OCLexerTokenTypes.VOLATILE_KEYWORD.getName() + " ");
        }
        if (qualifiers.isConst()) {
            res.insert(0, OCLexerTokenTypes.CONST_KEYWORD.getName() + " ");
        }
        if (type instanceof OCCppReferenceType) {
            OCCppReferenceType refType = (OCCppReferenceType)type;
            if (refType.isRvalueRef()) {
                res.append(" &amp;&amp;");
            } else {
                res.append(" &amp;");
            }
        }
        if ((ptrType = type) instanceof OCPointerType) {
            res.append(" ");
        }
        while (ptrType instanceof OCPointerType) {
            res.append("*");
            ptrType = ((OCPointerType)ptrType).getRefType();
        }
        String string = res.toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(25);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(26);
        }
        String string = StringUtil.join(OCDocUtil.getParents(symbol, context), TO_NAME, (String)"::");
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getCanonicalPrefixHtml(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(28);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(29);
        }
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, context);
        List structParents = ContainerUtil.filter(chain, s -> s.getKind().isStructLike());
        List namespace = ContainerUtil.filter(chain, s -> s.getKind() == OCSymbolKind.NAMESPACE);
        if (!structParents.isEmpty()) {
            OCSymbolWithQualifiedName parent = (OCSymbolWithQualifiedName)structParents.get(structParents.size() - 1);
            String prefix = OCDocUtil.getCanonicalNameHtml(parent.getType(), namespace, context);
            return OCDocUtil.replaceAnonymous(prefix);
        }
        return "";
    }

    @NotNull
    @NlsSafe
    public static String replaceAnonymous(@NlsSafe @NotNull String canonicalName) {
        if (canonicalName == null) {
            OCDocUtil.$$$reportNull$$$0(30);
        }
        canonicalName = canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
        for (String type : structTypes) {
            canonicalName = canonicalName.replace(type + " null", "<i>(anonymous)</i>" + type).replace(type + "__anonymous", "<i>(anonymous)</i>" + type);
        }
        String string = canonicalName;
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String replaceAnonymousInQualifiedName(@NotNull String canonicalName) {
        if (canonicalName == null) {
            OCDocUtil.$$$reportNull$$$0(32);
        }
        for (String type : structTypes) {
            canonicalName = canonicalName.replace("anonymous " + type, type + "__anonymous");
        }
        String string = canonicalName;
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(35);
        }
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(context, symbol, OCSymbolKind.NAMESPACE);
        chain.remove(symbol);
        List<OCSymbolWithQualifiedName> list = chain;
        if (list == null) {
            OCDocUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCResolveContext context, @NotNull OCSymbolWithQualifiedName symbol, OCSymbolKind ... filter) {
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(37);
        }
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(38);
        }
        if (filter == null) {
            OCDocUtil.$$$reportNull$$$0(39);
        }
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, symbol.getDefaultArgumentsRemovalStrategy(), false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> {
            for (OCSymbolKind kind : filter) {
                if (parent.getKind() != kind) continue;
                parents.add((OCSymbolWithQualifiedName)parent);
            }
        }));
        ArrayList<OCSymbolWithQualifiedName> arrayList = parents;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(41);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(42);
        }
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, symbol.getDefaultArgumentsRemovalStrategy(), false, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parents::add));
        parents.remove(symbol);
        ArrayList<OCSymbolWithQualifiedName> arrayList = parents;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    private static HtmlBuilder wrapSymbolName(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(44);
        }
        HtmlBuilder sb = new HtmlBuilder();
        if (!(symbol instanceof OCStructSymbol)) {
            sb.append(HtmlChunk.text((String)symbol.getPresentableName()));
        } else {
            OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        }
        HtmlBuilder htmlBuilder = sb;
        if (htmlBuilder == null) {
            OCDocUtil.$$$reportNull$$$0(45);
        }
        return htmlBuilder;
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull HtmlBuilder sb) {
        String name;
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(46);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(47);
        }
        boolean hasName = !"<unnamed>".equals(name = symbol.getName());
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append((HtmlChunk)HtmlChunk.link((String)link, (String)name));
        } else {
            sb.append(symbol.getPresentableName());
        }
    }

    @NotNull
    public static String getLinkHtml(@NotNull OCSymbol symbol) {
        String name;
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(48);
        }
        boolean hasName = !"<unnamed>".equals(name = symbol.getPresentableName());
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            String string = "<a href=\"" + link + "\">" + StringUtil.escapeXmlEntities((String)name) + "</a>";
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        String string = StringUtil.escapeXmlEntities((String)symbol.getPresentableName());
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context, @NotNull HtmlBuilder answer) {
        String templateArgumentsStr;
        if (templateArguments == null) {
            OCDocUtil.$$$reportNull$$$0(51);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(52);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(53);
        }
        if (answer == null) {
            OCDocUtil.$$$reportNull$$$0(54);
        }
        if (!(templateArgumentsStr = StringUtil.join(templateArguments, templateArgument -> {
            if (templateArgument instanceof OCType) {
                return OCDocUtil.getCanonicalNameHtml((OCType)templateArgument, contextNamespace, context);
            }
            if (templateArgument instanceof OCExpressionTypeArgument) {
                return ((OCExpressionTypeArgument)templateArgument).getSymbol().getPresentableName();
            }
            return "";
        }, (String)", ")).isEmpty()) {
            answer.append("<").appendRaw(templateArgumentsStr).append(">");
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @NotNull OCResolveContext context, @NotNull HtmlBuilder answer) {
        if (templateParams == null) {
            OCDocUtil.$$$reportNull$$$0(55);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(56);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(57);
        }
        if (answer == null) {
            OCDocUtil.$$$reportNull$$$0(58);
        }
        String templateParamsStr = StringUtil.join(templateParams, param -> {
            StringBuilder sb = new StringBuilder();
            if (param instanceof OCTypeParameterValueSymbol) {
                String type = param.getType().getName();
                sb.append(type).append(OCDocUtil.delimiter(type));
            }
            if (param.isVariadic()) {
                sb.append("...");
            }
            sb.append(param.getName());
            Object value = param.getDefaultValue();
            if (value != null) {
                sb.append(" = ");
                if (value instanceof OCType) {
                    sb.append(OCDocUtil.getCanonicalNameHtml((OCType)value, contextNamespace, context));
                } else if (value instanceof OCExpressionTypeArgument) {
                    sb.append(((OCExpressionTypeArgument)value).getSymbol().getPresentableName());
                }
            }
            return sb.toString();
        }, (String)", ");
        answer.append("template<").appendRaw(templateParamsStr).append(">");
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(59);
        }
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(file.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithParent> getSuperSymbols(@NotNull PsiElement element) {
        Object symbol;
        if (element == null) {
            OCDocUtil.$$$reportNull$$$0(60);
        }
        ArrayList<OCSymbolWithParent> supers = new ArrayList<OCSymbolWithParent>();
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCSymbolWithParent) {
            OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)((Processor)s -> {
                supers.add((OCSymbolWithParent)s);
                return true;
            }), true, element.getProject());
        }
        ArrayList<OCSymbolWithParent> arrayList = supers;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 18, 22, 23, 24, 27, 31, 33, 36, 40, 43, 45, 49, 50, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 45: 
            case 49: 
            case 50: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCDocUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "del";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDeclaration";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 17: 
            case 21: 
            case 26: 
            case 29: 
            case 35: 
            case 37: 
            case 42: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextNamespace";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateArguments";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParams";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCDocUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "delimiter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersSignatureHtml";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNameHtml";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAnonymous";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAnonymousInQualifiedName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 40: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedSymbolChain";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapSymbolName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkHtml";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parameterSignature";
                break;
            }
            case 2: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 45: 
            case 49: 
            case 50: 
            case 61: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "delimiter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendExplicitSpecifier";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractModifiers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractFuncPostModifiers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParametersSignatureHtml";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNameHtml";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPrefixHtml";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceAnonymous";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceAnonymousInQualifiedName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedSymbolChain";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "wrapSymbolName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "wrapStruct";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLinkHtml";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "wrapTemplateArgs";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "wrapTemplateParams";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildLinkSymbol";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 18, 22, 23, 24, 27, 31, 33, 36, 40, 43, 45, 49, 50, 61 -> new IllegalStateException(string);
        };
    }
}

