/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.ImpatientDeferredException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProcessingDependencyGraph<Item> {
    private final Map<Thread, Item> myThreadToAwaitingItem = new HashMap<Thread, Item>();
    private final Map<Item, Context> myItemToProcessingContext = CollectionFactory.createSmallMemoryFootprintMap();

    ProcessingDependencyGraph() {
    }

    synchronized boolean isAlreadyProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Context currentProcessingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(0);
        }
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(1);
        }
        return (currentProcessingContext = this.myItemToProcessingContext.get(item)) != null && ProcessingDependencyGraph.isRecursive(currentThread, currentProcessingContext.getThread());
    }

    @NotNull
    synchronized State startProcessing(@NotNull Item item, @NotNull Thread currentThread, @Nullable Runnable reschedule) throws ImpatientDeferredException {
        Context currentProcessingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(2);
        }
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(3);
        }
        if ((currentProcessingContext = this.myItemToProcessingContext.get(item)) == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            State state = State.ACQUIRED;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(4);
            }
            return state;
        }
        Thread currentProcessingThread = currentProcessingContext.getThread();
        if (ProcessingDependencyGraph.isRecursive(currentThread, currentProcessingThread)) {
            State state = State.RECURSIVE;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(5);
            }
            return state;
        }
        if (reschedule != null) {
            currentProcessingContext.add(reschedule);
            throw new ImpatientDeferredException();
        }
        if (this.isDeadlock(currentThread, currentProcessingThread)) {
            State state = State.DEADLOCK;
            if (state == null) {
                ProcessingDependencyGraph.$$$reportNull$$$0(6);
            }
            return state;
        }
        this.myThreadToAwaitingItem.put(currentThread, item);
        State state = State.WAIT;
        if (state == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(7);
        }
        return state;
    }

    synchronized boolean retryStartProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Thread currentProcessingThread;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(8);
        }
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(9);
        }
        if ((currentProcessingThread = this.getCurrentProcessingThread(item)) == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            this.myThreadToAwaitingItem.remove(currentThread);
            return true;
        }
        return false;
    }

    synchronized void stopWaiting(@NotNull Thread currentThread) {
        if (currentThread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(10);
        }
        this.myThreadToAwaitingItem.remove(currentThread);
    }

    synchronized void finishProcessing(@NotNull Item item) {
        Context processingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(11);
        }
        if (!OCLog.LOG.assertTrue((processingContext = this.myItemToProcessingContext.remove(item)) != null, (Object)"Current processing context not found")) {
            return;
        }
        Iterator iterator2 = processingContext.iterator();
        while (iterator2.hasNext()) {
            Runnable reschedule = (Runnable)iterator2.next();
            reschedule.run();
        }
    }

    private static boolean isRecursive(@NotNull Thread context, @NotNull Thread thread) {
        if (context == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(12);
        }
        if (thread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(13);
        }
        return context == thread;
    }

    private boolean isDeadlock(@NotNull Thread context, @NotNull Thread thread) {
        if (context == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(14);
        }
        if (thread == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(15);
        }
        Item lock;
        while ((lock = this.myThreadToAwaitingItem.get(thread)) != null) {
            Thread next = this.getCurrentProcessingThread(lock);
            if (next == null || next == thread) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    @Nullable
    private Thread getCurrentProcessingThread(@NotNull Item item) {
        Context currentProcessingContext;
        if (item == null) {
            ProcessingDependencyGraph.$$$reportNull$$$0(16);
        }
        return (currentProcessingContext = this.myItemToProcessingContext.get(item)) != null ? currentProcessingContext.getThread() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyProcessing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startProcessing";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "retryStartProcessing";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stopWaiting";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finishProcessing";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeadlock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentProcessingThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static final class Context
    extends SmartList<Runnable> {
        @NotNull
        private final Thread myThread;

        Context(@NotNull Thread thread) {
            if (thread == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myThread = thread;
        }

        @NotNull
        Thread getThread() {
            Thread thread = this.myThread;
            if (thread == null) {
                Context.$$$reportNull$$$0(1);
            }
            return thread;
        }

        public boolean equals(@Nullable Object o) {
            throw new AssertionError();
        }

        public int hashCode() {
            throw new AssertionError();
        }

        public String toString() {
            return "ProcessingContext{thread=" + String.valueOf(this.myThread) + "} " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ProcessingDependencyGraph$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static enum State {
        DEADLOCK,
        RECURSIVE,
        ACQUIRED,
        WAIT;

    }
}

