/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.PeriodicBackgroundTask;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/PeriodicSerializationTask;", "Lcom/jetbrains/cidr/lang/symbols/symtable/PeriodicBackgroundTask;", "cache", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;", "project", "Lcom/intellij/openapi/project/Project;", "map", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/ConcurrentMap;Lkotlinx/coroutines/CoroutineScope;)V", "runInBackground", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldStop", "", "shouldRun", "intellij.c.core"})
public final class PeriodicSerializationTask
extends PeriodicBackgroundTask {
    @NotNull
    private final FileSymbolTablesCache cache;
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> map;

    public PeriodicSerializationTask(@NotNull FileSymbolTablesCache cache, @NotNull Project project, @NotNull ConcurrentMap<VirtualFile, FileSymbolTablesPack> map2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(coroutineScope);
        this.cache = cache;
        this.project = project;
        this.map = map2;
    }

    @Override
    @Nullable
    protected Object runInBackground(@NotNull Continuation<? super Unit> $completion) {
        ReadAction.computeCancellable(() -> PeriodicSerializationTask.runInBackground$lambda$1(this));
        return Unit.INSTANCE;
    }

    @Override
    protected boolean shouldStop() {
        return !this.project.isOpen() || this.project.isDisposed();
    }

    @Override
    protected boolean shouldRun() {
        return super.shouldRun() && FileSymbolTablesCache.isSerializationEnabled() && !DumbService.Companion.isDumb(this.project) && this.cache.isUpToDate();
    }

    private static final Unit runInBackground$lambda$1$lambda$0(PeriodicSerializationTask this$0, String $projectHash, ArrayList $fs) {
        this$0.cache.serializeTables($projectHash, $fs, ProgressIndicatorProvider.getGlobalProgressIndicator());
        return Unit.INSTANCE;
    }

    private static final Unit runInBackground$lambda$1(PeriodicSerializationTask this$0) {
        if (this$0.shouldStop() || !this$0.shouldRun()) {
            return Unit.INSTANCE;
        }
        ArrayList<VirtualFile> fs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this$0.map.keySet()) {
            ProgressManager.checkCanceled();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)this$0.map.get(file);
            if (pack == null || !pack.shouldSerialize()) continue;
            fs.add(file);
        }
        if (fs.isEmpty()) {
            return Unit.INSTANCE;
        }
        ProgressManager.checkCanceled();
        String string = this$0.project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        String projectHash = string;
        CoroutinesKt.blockingContextToIndicator(() -> PeriodicSerializationTask.runInBackground$lambda$1$lambda$0(this$0, projectHash, fs));
        return Unit.INSTANCE;
    }
}

