/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return element instanceof OCDeclarator || element instanceof OCMethodSelectorPart || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        return element instanceof OCDeclarator && (((OCDeclarator)element).getInitializer() != null || element.getParent().getParent() instanceof OCForeachStatement);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(4);
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        if (expression == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(5);
        }
        if (expression instanceof OCReferenceElement || expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression || expression instanceof OCArraySelectionExpression || expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCLexerTokenTypes.MUL) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{OCReferenceExpression.class, OCParenthesizedExpression.class});
            OCElementType operator = null;
            if (parent instanceof OCConstructorFieldInitializer) {
                OCSymbol symbol;
                OCReferenceElement element = ((OCConstructorFieldInitializer)parent).getReferenceElement();
                OCSymbol oCSymbol = symbol = element != null ? element.resolveToSymbol() : null;
                if (symbol != null && symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                    ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                    if (access == null) {
                        OCReadWriteAccessDetector.$$$reportNull$$$0(6);
                    }
                    return access;
                }
            }
            if (parent instanceof OCAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((OCAssignmentExpression)parent).getReceiverExpression(), (PsiElement)expression, (boolean)false)) {
                ReadWriteAccessDetector.Access access = ((OCAssignmentExpression)parent).getOperationSign() == OCLexerTokenTypes.EQ ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.ReadWrite;
                if (access == null) {
                    OCReadWriteAccessDetector.$$$reportNull$$$0(7);
                }
                return access;
            }
            if (parent instanceof OCPrefixExpression) {
                operator = ((OCPrefixExpression)parent).getOperationSign();
            } else if (parent instanceof OCPostfixExpression) {
                operator = ((OCPostfixExpression)parent).getOperationSign();
            }
            if (parent instanceof OCArraySelectionExpression && PsiTreeUtil.isAncestor((PsiElement)((OCArraySelectionExpression)parent).getArrayExpression(), (PsiElement)expression, (boolean)false)) {
                ReadWriteAccessDetector.Access access = this.getExpressionAccess(parent);
                if (access == null) {
                    OCReadWriteAccessDetector.$$$reportNull$$$0(8);
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = operator == OCLexerTokenTypes.PLUSPLUS || operator == OCLexerTokenTypes.MINUSMINUS ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                OCReadWriteAccessDetector.$$$reportNull$$$0(9);
            }
            return access;
        }
        if (expression instanceof OCSendMessageExpression) {
            ReadWriteAccessDetector.Access access = ((OCSendMessageExpression)expression).getMessageSelector().endsWith(":") ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                OCReadWriteAccessDetector.$$$reportNull$$$0(10);
            }
            return access;
        }
        if (expression instanceof OCDesignatedInitializer || expression instanceof OCQualifiedDesignator) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
            if (access == null) {
                OCReadWriteAccessDetector.$$$reportNull$$$0(11);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            OCReadWriteAccessDetector.$$$reportNull$$$0(12);
        }
        return access;
    }

    public boolean canBeConstReference(PsiElement expression, boolean checkPointerType) {
        OCType receiverType;
        OCType expectedType;
        PsiElement parent = expression.getParent();
        if (expression instanceof OCReferenceElement) {
            expression = parent;
            parent = expression.getParent();
        }
        while (parent instanceof OCParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof OCQualifiedExpression) {
            if (this.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
                return false;
            }
            if (parent.getParent() instanceof OCCallExpression) {
                OCSymbol function = ((OCQualifiedExpression)parent).resolveToSymbol();
                if (function instanceof OCFunctionSymbol && !((OCFunctionSymbol)function).isConst() && !((OCFunctionSymbol)function).resolveIsFriendOrStatic(OCResolveContext.forPsi(expression))) {
                    return false;
                }
            } else {
                return this.canBeConstReference(parent, checkPointerType);
            }
        }
        if (expression instanceof OCExpression && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)expression, OCResolveContext.forPsi(expression))) instanceof OCCppReferenceType && !((OCCppReferenceType)expectedType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getSourceExpression() == expression && (receiverType = ((OCAssignmentExpression)parent).getReceiverExpression().getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        if (checkPointerType && parent instanceof OCDeclarator && (receiverType = ((OCDeclarator)parent).getResolvedType()) instanceof OCPointerType && !((OCPointerType)receiverType).getRefType().isConst()) {
            return false;
        }
        if (parent instanceof OCUnaryExpression && ((OCUnaryExpression)parent).getOperationSign() == OCLexerTokenTypes.MUL && this.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
            return false;
        }
        if (parent instanceof OCForeachStatement) {
            return false;
        }
        if (parent instanceof OCArgumentList && parent.getParent() instanceof OCCallExpression) {
            OCType type = ((OCCallExpression)parent.getParent()).getCalleeType(OCResolveContext.forPsi(expression));
            int index = ((OCArgumentList)parent).getArguments().indexOf(expression);
            if (type instanceof OCFunctionType) {
                OCType paramType;
                List<OCType> paramTypes = ((OCFunctionType)type).getParameterTypes();
                if (index >= 0 && index < paramTypes.size() && ((paramType = paramTypes.get(index)) instanceof OCPointerType || paramType instanceof OCStructType) && !paramType.getTerminalType().isConst()) {
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/usages/OCReadWriteAccessDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/usages/OCReadWriteAccessDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

