/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSourcesScopeProvider
extends CustomScopesProviderEx {
    private final List<NamedScope> myScopes = List.of(new SourceFilesScope(), new NonSourceFilesScope());

    @NotNull
    public List<NamedScope> getCustomScopes() {
        List<NamedScope> list = this.myScopes;
        if (list == null) {
            ProjectSourcesScopeProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/ProjectSourcesScopeProvider", "getCustomScopes"));
    }

    public static class SourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Source Files";

        @NotNull
        @Nls
        public static String presentableName() {
            String string = OCBundle.message("search.scope.project.source.files", new Object[0]);
            if (string == null) {
                SourceFilesScope.$$$reportNull$$$0(0);
            }
            return string;
        }

        public SourceFilesScope() {
            super(NAME, () -> SourceFilesScope.presentableName(), AllIcons.Modules.SourceRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return OCSearchScope.isInProjectSources(project, file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/search/scopes/ProjectSourcesScopeProvider$SourceFilesScope$1";
                    objectArray[2] = "contains";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/ProjectSourcesScopeProvider$SourceFilesScope", "presentableName"));
        }
    }

    public static class NonSourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Non-Source Files";

        public NonSourceFilesScope() {
            super(NAME, () -> OCBundle.message("search.scope.project.non.source.files", new Object[0]), AllIcons.Modules.ResourcesRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return OCSearchScope.isInProjectNonSources(project, file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/search/scopes/ProjectSourcesScopeProvider$NonSourceFilesScope$1";
                    objectArray[2] = "contains";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }
}

