/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.resolve.references.OCStatefulReference;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCOperatorReference
extends OCPolyVariantReferenceImpl<OCSymbol>
implements OCStatefulReference {
    private final PsiElement myElement;
    private final String mySign;
    private final OperatorPlacement myPlacement;
    protected final List<? extends OCTypeOwner> myArguments;
    private final List<OCType> myParamTypes;
    private final PsiElement mySignElement;
    private static final Key<MyResolver>[] RESOLVER_KEYS = new Key[]{Key.create((String)"RESOLVER_KEY1"), Key.create((String)"RESOLVER_KEY2")};

    public OCOperatorReference(@NotNull PsiElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, OCExpression ... arguments) {
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(0);
        }
        if (sign == null) {
            OCOperatorReference.$$$reportNull$$$0(1);
        }
        if (placement == null) {
            OCOperatorReference.$$$reportNull$$$0(2);
        }
        this(element, sign, placement, signElement, Arrays.asList(arguments), null);
    }

    public OCOperatorReference(@NotNull PsiElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, @Nullable List<? extends OCTypeOwner> arguments, @Nullable List<OCType> paramTypes) {
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(3);
        }
        if (sign == null) {
            OCOperatorReference.$$$reportNull$$$0(4);
        }
        if (placement == null) {
            OCOperatorReference.$$$reportNull$$$0(5);
        }
        this.myElement = element;
        this.mySign = sign;
        this.myPlacement = placement;
        this.myArguments = arguments;
        this.myParamTypes = paramTypes;
        this.mySignElement = signElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            OCOperatorReference.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.mySignElement != null ? OCElementUtil.getRangeInParent(this.mySignElement) : TextRange.EMPTY_RANGE;
        if (textRange == null) {
            OCOperatorReference.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @Override
    public boolean isValid() {
        return !(!this.myElement.isValid() || this.mySignElement != null && !this.mySignElement.isValid() || this.myArguments != null && !ContainerUtil.and(this.myArguments, owner -> !(owner instanceof OCExpression) || ((OCExpression)owner).isValid()));
    }

    @Override
    public PsiElement resolve() {
        return ExternalResolveUtils.findCombined(this, ref -> {
            OCSymbol clangSymbol = ExternalResolveUtils.resolveSymbol(ref);
            if (clangSymbol != null) {
                PsiElement clangElement = clangSymbol.locateDefinition(this.getElement().getProject());
                ExternalResolveUtils.assertFoundSameElement(clangElement, () -> super.resolve());
                return clangElement;
            }
            return null;
        }, ref -> super.resolve());
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(8);
        }
        if (element instanceof OCSymbolDeclarator) {
            return ExternalResolveUtils.findCombined(this, ref -> {
                OCSymbol clangSymbol = ExternalResolveUtils.resolveSymbol(this);
                return clangSymbol != null ? Boolean.valueOf(clangSymbol.isSameSymbol((OCSymbol)((OCSymbolDeclarator)element).getSymbol(), element.getProject())) : null;
            }, ref -> super.isReferenceTo(element));
        }
        return super.isReferenceTo(element);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbolsViaClang() {
        List list = ExternalResolveUtils.findCombined(this, ref -> ExternalResolveUtils.resolveSymbols(ref), ref -> this.resolveToSymbols());
        if (list == null) {
            OCOperatorReference.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean isSoft() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCOperatorReference reference = (OCOperatorReference)o;
        if (this.myElement != null ? !this.myElement.equals(reference.myElement) : reference.myElement != null) {
            return false;
        }
        if (this.mySignElement != null ? !this.mySignElement.equals(reference.mySignElement) : reference.mySignElement != null) {
            return false;
        }
        return !(this.mySign != null ? !this.mySign.equals(reference.mySign) : reference.mySign != null);
    }

    public int hashCode() {
        int result = this.myElement != null ? this.myElement.hashCode() : 0;
        result = 31 * result + (this.mySign != null ? this.mySign.hashCode() : 0);
        result = 31 * result + (this.mySignElement != null ? this.mySignElement.hashCode() : 0);
        return result;
    }

    @Nullable
    public List<? extends OCTypeOwner> getArgumentExpressions() {
        return this.myArguments;
    }

    @NotNull
    public String getCanonicalText() {
        if (this.mySignElement != null) {
            String string = this.mySignElement.getText();
            if (string == null) {
                OCOperatorReference.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.mySign;
        if (string == null) {
            OCOperatorReference.$$$reportNull$$$0(11);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            OCOperatorReference.$$$reportNull$$$0(12);
        }
        if (this.mySignElement != null) {
            OCElementUtil.replaceWithIdentifier(this.mySignElement, newElementName, this.getElement());
        }
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCOperatorReference.$$$reportNull$$$0(13);
        }
        return this.handleElementRename(symbol.getName());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol;
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(14);
        }
        return (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> types, @Nullable List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        if (sign == null) {
            OCOperatorReference.$$$reportNull$$$0(15);
        }
        if (placement == null) {
            OCOperatorReference.$$$reportNull$$$0(16);
        }
        if (types == null) {
            OCOperatorReference.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCOperatorReference.$$$reportNull$$$0(18);
        }
        if (context.getElement() == null) {
            return null;
        }
        OCOperatorReference reference = new OCOperatorReference(context.getElement(), sign, placement, null, arguments, types);
        List<OCSymbol> symbols = new MyResolver((boolean)true, (boolean)true, (OCResolveContext)context).resolve((OCOperatorReference)reference, (OCResolveContext)context).symbols;
        OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem(symbols);
        return symbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull OCElement element, @NotNull OCStructType struct) {
        OCResolveContext context;
        OCSymbol symbol;
        if (sign == null) {
            OCOperatorReference.$$$reportNull$$$0(19);
        }
        if (placement == null) {
            OCOperatorReference.$$$reportNull$$$0(20);
        }
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(21);
        }
        if (struct == null) {
            OCOperatorReference.$$$reportNull$$$0(22);
        }
        return (symbol = (OCSymbol)ContainerUtil.getFirstItem(new MyResolver(true, true, context = OCResolveContext.forPsi(element)).doResolveOperator(sign, placement, Collections.singletonList(struct), null, context, element))) instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveDerefOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        if (element == null) {
            OCOperatorReference.$$$reportNull$$$0(23);
        }
        if (struct == null) {
            OCOperatorReference.$$$reportNull$$$0(24);
        }
        return OCOperatorReference.resolveOperator(OCTokenTypes.DEREF.getName(), OperatorPlacement.INFIX, element, struct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<OCSymbol> resolveToSymbols(@NotNull MyResolver resolver) {
        if (resolver == null) {
            OCOperatorReference.$$$reportNull$$$0(25);
        }
        MyResolveResult result = null;
        ResolveCache resolveCache = ResolveCache.getInstance((Project)this.myElement.getProject());
        if (resolveCache != null) {
            try {
                ExternalResolveUtils.prohibitClangResolve();
                result = (MyResolveResult)resolveCache.resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)resolver, false, false);
            }
            finally {
                ExternalResolveUtils.allowClangResolve();
            }
        }
        List list = result != null ? ContainerUtil.filter(result.symbols, symbol -> !(symbol instanceof OCFunctionGroupSymbol) || ((OCFunctionGroupSymbol)symbol).getCause() != OCFunctionGroupSymbol.Cause.NoViable) : Collections.emptyList();
        if (list == null) {
            OCOperatorReference.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads) {
        return this.resolveToSymbols(MyResolver.getInstance(resolveOverloads));
    }

    @TestOnly
    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads, boolean filterAmbigs) {
        MyResolveResult result = new MyResolver(resolveOverloads, filterAmbigs).resolve(this, false);
        List<OCSymbol> list = result.symbols;
        if (list == null) {
            OCOperatorReference.$$$reportNull$$$0(27);
        }
        return list;
    }

    public boolean hasMagicOperands() {
        try {
            ExternalResolveUtils.prohibitClangResolve();
            MyResolveResult result = (MyResolveResult)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.getInstance(true), false, false);
            boolean bl = result != null && result.hasMagicOperands;
            return bl;
        }
        finally {
            ExternalResolveUtils.allowClangResolve();
        }
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return new ArrayList<OCSymbol>(this.resolveToSymbols(true));
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            OCOperatorReference.$$$reportNull$$$0(28);
        }
        List<OCSymbol> list = this.resolveToSymbols(true, context);
        if (list == null) {
            OCOperatorReference.$$$reportNull$$$0(29);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean resolveOverloads, @NotNull OCResolveContext context) {
        MyResolver resolver;
        if (context == null) {
            OCOperatorReference.$$$reportNull$$$0(30);
        }
        Key<MyResolver> key = RESOLVER_KEYS[resolveOverloads ? 1 : 0];
        OCResolveContext oCResolveContext = context;
        synchronized (oCResolveContext) {
            resolver = (MyResolver)context.getUserData(key);
            if (resolver == null) {
                resolver = new MyResolver(resolveOverloads, false, context);
                context.putUserData(key, resolver);
            }
        }
        return this.resolveToSymbols(resolver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10, 11, 26, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 18: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbolsViaClang";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "bindToSymbol";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveOperator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveDerefOperator";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10, 11, 26, 27, 29 -> new IllegalStateException(string);
        };
    }

    public static enum OperatorPlacement {
        PREFIX,
        INFIX,
        POSTFIX;

    }

    private static final class MyResolver
    implements ResolveCache.AbstractResolver<OCOperatorReference, MyResolveResult> {
        private final boolean myResolveOverloads;
        private final boolean myFilterAmbigs;
        private OCResolveContext myContext;
        private static final MyResolver[] INSTANCES = new MyResolver[]{new MyResolver(false, true), new MyResolver(true, true)};

        public static MyResolver getInstance(boolean resolveOverloads) {
            return resolveOverloads ? INSTANCES[1] : INSTANCES[0];
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs, @NotNull OCResolveContext context) {
            if (context == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
            this.myContext = context;
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
        }

        @NotNull
        public MyResolveResult resolve(@NotNull OCOperatorReference reference, boolean incompleteCode) {
            if (reference == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            MyResolveResult myResolveResult = this.resolve(reference, this.myContext != null ? this.myContext : OCResolveContext.forPsi(reference.getElement()));
            if (myResolveResult == null) {
                MyResolver.$$$reportNull$$$0(2);
            }
            return myResolveResult;
        }

        @NotNull
        public MyResolveResult resolve(@NotNull OCOperatorReference reference, @NotNull OCResolveContext context) {
            if (reference == null) {
                MyResolver.$$$reportNull$$$0(3);
            }
            if (context == null) {
                MyResolver.$$$reportNull$$$0(4);
            }
            if (reference.myArguments != null) {
                return this.resolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, reference.myArguments, context, reference.getElement());
            }
            List<OCSymbol> symbols = this.doResolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, null, context, reference.getElement());
            MyResolveResult myResolveResult = MyResolveResult.create(symbols, false);
            if (myResolveResult == null) {
                MyResolver.$$$reportNull$$$0(5);
            }
            return myResolveResult;
        }

        @NotNull
        private MyResolveResult resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @Nullable List<OCType> paramTypes, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            if (sign == null) {
                MyResolver.$$$reportNull$$$0(6);
            }
            if (placement == null) {
                MyResolver.$$$reportNull$$$0(7);
            }
            if (arguments == null) {
                MyResolver.$$$reportNull$$$0(8);
            }
            if (context == null) {
                MyResolver.$$$reportNull$$$0(9);
            }
            if (localContext == null) {
                MyResolver.$$$reportNull$$$0(10);
            }
            if (OCUDLiteralExpression.isUDLOperator(sign)) {
                return this.resolveUDLOperator(sign, placement, arguments, context, localContext);
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            boolean hasCppStructType = false;
            boolean wasNonLiteral = false;
            boolean hasMagicParameter = false;
            for (OCTypeOwner oCTypeOwner : arguments) {
                if (oCTypeOwner instanceof OCLiteralExpression || oCTypeOwner instanceof OCLiteralExpressionSymbol) continue;
                wasNonLiteral = true;
                break;
            }
            if (!wasNonLiteral) {
                MyResolveResult myResolveResult = MyResolveResult.EMPTY;
                if (myResolveResult == null) {
                    MyResolver.$$$reportNull$$$0(11);
                }
                return myResolveResult;
            }
            for (int i = 0; i < arguments.size(); ++i) {
                OCType derefType;
                OCTypeOwner oCTypeOwner = arguments.get(i);
                OCType type = paramTypes != null && i < paramTypes.size() ? paramTypes.get(i).resolve(context) : oCTypeOwner.getResolvedType(context);
                args.add(oCTypeOwner);
                OCType oCType = derefType = type instanceof OCCppReferenceType ? ((OCCppReferenceType)type).getRefType() : type;
                if (derefType instanceof OCMagicType) {
                    hasMagicParameter = true;
                }
                if (TypeProperties.isRecordType(derefType)) {
                    hasCppStructType = true;
                } else if (i == 0 && sign.equals("()")) {
                    MyResolveResult myResolveResult = MyResolveResult.create(Collections.emptyList(), hasMagicParameter);
                    if (myResolveResult == null) {
                        MyResolver.$$$reportNull$$$0(12);
                    }
                    return myResolveResult;
                }
                types.add(type);
            }
            if (hasCppStructType) {
                List<OCSymbol> symbols;
                MyResolveResult myResolveResult = MyResolveResult.create(symbols, !(symbols = this.doResolveOperator(sign, placement, types, args, context, localContext)).isEmpty() && hasMagicParameter);
                if (myResolveResult == null) {
                    MyResolver.$$$reportNull$$$0(13);
                }
                return myResolveResult;
            }
            MyResolveResult myResolveResult = MyResolveResult.create(Collections.emptyList(), hasMagicParameter);
            if (myResolveResult == null) {
                MyResolver.$$$reportNull$$$0(14);
            }
            return myResolveResult;
        }

        @NotNull
        private MyResolveResult resolveUDLOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            OCTypeOwner oCTypeOwner;
            if (sign == null) {
                MyResolver.$$$reportNull$$$0(15);
            }
            if (placement == null) {
                MyResolver.$$$reportNull$$$0(16);
            }
            if (arguments == null) {
                MyResolver.$$$reportNull$$$0(17);
            }
            if (context == null) {
                MyResolver.$$$reportNull$$$0(18);
            }
            if (localContext == null) {
                MyResolver.$$$reportNull$$$0(19);
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            if (arguments.size() == 1 && (oCTypeOwner = arguments.get(0)) instanceof OCLiteralExpression) {
                List<OCSymbol> symbols;
                boolean numericLiteral;
                OCType type;
                OCLiteralExpression literal = (OCLiteralExpression)oCTypeOwner;
                IElementType elementType = OCElementUtil.getElementType(literal.getFirstChild());
                if (elementType == OCLexerTokenTypes.INTEGER_LITERAL) {
                    type = OCIntType.ULONGLONG;
                    numericLiteral = true;
                } else if (elementType == OCLexerTokenTypes.FLOAT_LITERAL) {
                    type = OCRealType.LONG_DOUBLE;
                    numericLiteral = true;
                } else {
                    type = literal.getResolvedType(context);
                    numericLiteral = false;
                }
                args.add(literal);
                types.add(type);
                if (literal.isStringLiteral()) {
                    types.add(OCIntType.SIZE_T);
                    args.add(null);
                }
                if (!(symbols = this.doResolveOperator(sign, placement, types, args, context, localContext)).isEmpty()) {
                    MyResolveResult myResolveResult = MyResolveResult.create(symbols, false);
                    if (myResolveResult == null) {
                        MyResolver.$$$reportNull$$$0(20);
                    }
                    return myResolveResult;
                }
                if (numericLiteral) {
                    args.clear();
                    types.clear();
                    types.add(OCPointerType.to(OCIntType.CHAR_CONST));
                    args.add(null);
                    List<OCSymbol> rawChars = this.doResolveOperator(sign, placement, types, args, context, localContext);
                    types.clear();
                    List<OCSymbol> template = this.doResolveOperator(sign, placement, types, null, context, localContext);
                    if (template.isEmpty()) {
                        symbols = rawChars;
                    } else if (rawChars.isEmpty()) {
                        symbols = template;
                    } else {
                        List<OCFunctionSymbol> functionSymbols = Stream.concat(rawChars.stream(), template.stream()).map(symbol -> (OCFunctionSymbol)symbol).toList();
                        symbols = Collections.singletonList(new OCFunctionGroupSymbol(functionSymbols, null, OCFunctionGroupSymbol.Cause.Ambiguous, null));
                    }
                    if (!symbols.isEmpty()) {
                        MyResolveResult myResolveResult = MyResolveResult.create(symbols, false);
                        if (myResolveResult == null) {
                            MyResolver.$$$reportNull$$$0(21);
                        }
                        return myResolveResult;
                    }
                }
            }
            MyResolveResult myResolveResult = MyResolveResult.EMPTY;
            if (myResolveResult == null) {
                MyResolver.$$$reportNull$$$0(22);
            }
            return myResolveResult;
        }

        @NotNull
        private List<OCSymbol> doResolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> argTypes, @Nullable List<OCTypeOwner> args, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            if (sign == null) {
                MyResolver.$$$reportNull$$$0(23);
            }
            if (placement == null) {
                MyResolver.$$$reportNull$$$0(24);
            }
            if (argTypes == null) {
                MyResolver.$$$reportNull$$$0(25);
            }
            if (context == null) {
                MyResolver.$$$reportNull$$$0(26);
            }
            if (localContext == null) {
                MyResolver.$$$reportNull$$$0(27);
            }
            String name = OCLexerTokenTypes.OPERATOR_CPP_KEYWORD.getName() + sign;
            OCType leftType = argTypes.isEmpty() ? null : argTypes.get(0);
            OCExprValueCategory leftValueCategory = args == null || args.isEmpty() ? null : OCExprValueCategory.classify(args.get(0), leftType, context);
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new LinkedHashSet());
            if (leftType instanceof OCCppReferenceType) {
                leftType = ((OCCppReferenceType)leftType).getRefType();
            }
            if (leftType instanceof OCStructType) {
                List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)leftType, name, null, context, true);
                ContainerUtil.process(members, (Processor)collector);
            }
            OCSymbolReference.getLocalReference(name, localContext).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            for (OCType type : argTypes) {
                OCType terminalType = type.getTerminalType();
                if (!(terminalType instanceof OCStructType)) continue;
                OCSymbolWithQualifiedName parent = ((OCStructType)terminalType).getSymbol().getParent();
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(OCQualifiedName.with(name), parent, OCElementUtil.getVirtualFile(localContext), OCSymbolOffsetUtil.getComplexOffset(localContext));
                reference.processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            if (!this.myResolveOverloads) {
                return new ArrayList<OCSymbol>(collector.getResults());
            }
            Collection<OCSymbol> symbols = args != null && args.get(0) instanceof OCExpression ? OCArgumentDepLookupAccumulator.doArgDepLookup(collector.getResults(), argTypes, args, OCQualifiedName.with(name), context) : collector.getResults();
            if (OCUDLiteralExpression.isUDLOperator(sign)) {
                return MyResolver.getUDLSymbols(placement, argTypes, context, localContext, symbols);
            }
            OCArgumentsList<OCTypeOwner> arguments = new OCArgumentsList<OCTypeOwner>(argTypes, args);
            OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(symbols, arguments, leftType, leftValueCategory, placement, true, this.myFilterAmbigs, context, localContext);
            List list = ContainerUtil.createMaybeSingletonList((Object)result);
            if (list == null) {
                MyResolver.$$$reportNull$$$0(28);
            }
            return list;
        }

        @NotNull
        private static List<OCSymbol> getUDLSymbols(@NotNull OperatorPlacement placement, @NotNull List<OCType> argTypes, @NotNull OCResolveContext context, @NotNull PsiElement localContext, @NotNull Collection<OCSymbol> symbols) {
            if (placement == null) {
                MyResolver.$$$reportNull$$$0(29);
            }
            if (argTypes == null) {
                MyResolver.$$$reportNull$$$0(30);
            }
            if (context == null) {
                MyResolver.$$$reportNull$$$0(31);
            }
            if (localContext == null) {
                MyResolver.$$$reportNull$$$0(32);
            }
            if (symbols == null) {
                MyResolver.$$$reportNull$$$0(33);
            }
            ArrayList<OCSymbol> directCandidates = new ArrayList<OCSymbol>();
            ArrayList<OCSymbol> fallbackCandidates = new ArrayList<OCSymbol>();
            for (OCSymbol symbol : symbols) {
                List<OCSymbol> symbolList;
                OCType valueType;
                OCTypeParameterSymbol maybeVariadicCharTValues;
                if (!(symbol instanceof OCFunctionSymbol)) continue;
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                List<OCTypeParameterSymbol> opTemplParams = functionSymbol.getTemplateParameters();
                List<OCType> opParamTypes = OCResolveOverloadsUtil.getParameterTypes(functionSymbol, placement, context, localContext, CVQualifiers.EMPTY);
                if (opTemplParams.isEmpty() && (argTypes.size() == 1 || argTypes.size() == 2) && argTypes.size() == opParamTypes.size() && opParamTypes.get(0).equalsAfterResolving(argTypes.get(0).transformType(OCArrayToPointerChanger.INSTANCE), context) && (argTypes.size() == 1 || OCIntType.SIZE_T.isCompatible(opParamTypes.get(1).resolve(context), context))) {
                    directCandidates.add(symbol);
                }
                if (argTypes.size() == 1 && argTypes.get(0) instanceof OCNumericType) {
                    CTypeId id = ((OCNumericType)argTypes.get(0)).getCTypeId();
                    if (id != CTypeId.LONG_LONG && id != CTypeId.LONG_DOUBLE) continue;
                    if (opTemplParams.isEmpty() && opParamTypes.size() == 1 && OCPointerType.to(OCIntType.CHAR_CONST).equalsAfterResolving(opParamTypes.get(0), context)) {
                        fallbackCandidates.add(0, symbol);
                        continue;
                    }
                    if (opTemplParams.size() != 1 || !opParamTypes.isEmpty() || !((maybeVariadicCharTValues = opTemplParams.get(0)) instanceof OCTypeParameterValueSymbol) || !maybeVariadicCharTValues.isVariadic() || !OCIntType.CHAR.equalsAfterResolving(valueType = ((OCVariadicType)maybeVariadicCharTValues.getType()).getUnderlyingType(), context)) continue;
                    fallbackCandidates.add(symbol);
                    continue;
                }
                if (argTypes.size() != 2 || !opParamTypes.isEmpty() || opTemplParams.size() != 2) continue;
                OCTypeParameterSymbol maybeCharT = opTemplParams.get(0);
                maybeVariadicCharTValues = opTemplParams.get(1);
                if (!(maybeCharT instanceof OCTypeParameterTypeSymbol) || !(maybeVariadicCharTValues instanceof OCTypeParameterValueSymbol) || !maybeVariadicCharTValues.isVariadic() || !((valueType = ((OCVariadicType)maybeVariadicCharTValues.getType()).getUnderlyingType()) instanceof OCReferenceType) || (symbolList = ((OCReferenceType)valueType).getReference(context).resolveToSymbols(context)).size() != 1 || !symbolList.get(0).equals(maybeCharT)) continue;
                fallbackCandidates.add(symbol);
            }
            if (!directCandidates.isEmpty()) {
                ArrayList<OCSymbol> arrayList = directCandidates;
                if (arrayList == null) {
                    MyResolver.$$$reportNull$$$0(34);
                }
                return arrayList;
            }
            if (!fallbackCandidates.isEmpty()) {
                ArrayList<OCSymbol> arrayList = fallbackCandidates;
                if (arrayList == null) {
                    MyResolver.$$$reportNull$$$0(35);
                }
                return arrayList;
            }
            List<OCSymbol> list = Collections.emptyList();
            if (list == null) {
                MyResolver.$$$reportNull$$$0(36);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 11, 12, 13, 14, 20, 21, 22, 28, 34, 35, 36 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 2: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 20: 
                case 21: 
                case 22: 
                case 28: 
                case 34: 
                case 35: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver";
                    break;
                }
                case 6: 
                case 15: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 7: 
                case 16: 
                case 24: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placement";
                    break;
                }
                case 8: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 10: 
                case 19: 
                case 27: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localContext";
                    break;
                }
                case 25: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argTypes";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveOperator";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveUDLOperator";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doResolveOperator";
                    break;
                }
                case 34: 
                case 35: 
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUDLSymbols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 20: 
                case 21: 
                case 22: 
                case 28: 
                case 34: 
                case 35: 
                case 36: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveOperator";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveUDLOperator";
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "doResolveOperator";
                    break;
                }
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "getUDLSymbols";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 11, 12, 13, 14, 20, 21, 22, 28, 34, 35, 36 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyResolveResult {
        static final MyResolveResult EMPTY = new MyResolveResult(Collections.emptyList(), false);
        static final MyResolveResult EMPTY_MAGIC = new MyResolveResult(Collections.emptyList(), true);
        @NotNull
        final List<OCSymbol> symbols;
        final boolean hasMagicOperands;

        MyResolveResult(@NotNull List<OCSymbol> symbols, boolean hasMagicOperands) {
            if (symbols == null) {
                MyResolveResult.$$$reportNull$$$0(0);
            }
            this.symbols = symbols;
            this.hasMagicOperands = hasMagicOperands;
        }

        @NotNull
        static MyResolveResult create(@NotNull List<OCSymbol> symbols, boolean hasMagicOperands) {
            if (symbols == null) {
                MyResolveResult.$$$reportNull$$$0(1);
            }
            if (symbols.isEmpty()) {
                MyResolveResult myResolveResult = hasMagicOperands ? EMPTY_MAGIC : EMPTY;
                if (myResolveResult == null) {
                    MyResolveResult.$$$reportNull$$$0(2);
                }
                return myResolveResult;
            }
            return new MyResolveResult(symbols, hasMagicOperands);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyResolveResult result = (MyResolveResult)o;
            return this.hasMagicOperands == result.hasMagicOperands && this.symbols.equals(result.symbols);
        }

        public int hashCode() {
            return 31 * this.symbols.hashCode() + (this.hasMagicOperands ? 1 : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbols";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolveResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

