/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OCTargetClass<C extends PsiElement, S extends OCSymbol> {
    protected Project myProject;
    protected String myName;
    protected C myPsi;
    protected S mySymbol;
    protected S mySourceSymbol;
    protected final Set<VirtualFile> myFiles;
    protected OCElementsMover myMover = new OCElementsMover(false);
    protected OCMemberInfoStorage myStorage;
    protected Map<OCMemberInfo, PsiElement> myMembersMap = new HashMap<OCMemberInfo, PsiElement>();

    public OCTargetClass(String name, Set<VirtualFile> files, @Nullable S symbol, S sourceSymbol, Project project) {
        PsiElement element;
        this.myProject = project;
        this.myName = name;
        this.mySymbol = symbol;
        this.myFiles = files;
        this.mySourceSymbol = sourceSymbol;
        PsiElement psiElement = element = symbol != null ? symbol.locateDefinition(project) : null;
        if (element != null) {
            this.myPsi = element;
            this.myStorage = new OCMemberInfoStorage((PsiElement)this.myPsi, true);
            this.myStorage.getClassMemberInfos((PsiElement)this.myPsi);
        }
    }

    public C getPsi() {
        return this.myPsi;
    }

    public S getSymbol() {
        return this.mySymbol;
    }

    public String getDisplayName() {
        return this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, this.myProject));
    }

    public Set<VirtualFile> getFiles() {
        return this.myFiles;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Nullable
    public OCMemberInfoStorage getMemberStorage() {
        return this.myStorage;
    }

    public PsiElement getMemberElement(OCMemberInfo info) {
        return this.myMembersMap.get((Object)info);
    }

    public void locateTargetClass(boolean underWriteAction) {
        for (VirtualFile file : this.myFiles) {
            OCFile psiFile = (OCFile)PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null || !psiFile.isHeader()) continue;
            OCSymbolDeclarator curClass = psiFile.findClass(this.myName);
            if (curClass == null) break;
            this.myPsi = curClass;
            break;
        }
        assert (this.myPsi != null);
        this.mySymbol = ((OCSymbolDeclarator)this.myPsi).getSymbol();
        assert (this.mySymbol != null);
        this.myStorage = new OCMemberInfoStorage((PsiElement)this.myPsi, true);
        this.myMembersMap.clear();
        for (OCMemberInfo info : this.myStorage.getClassMemberInfos((PsiElement)this.myPsi)) {
            PsiElement element = info.getSymbol().locateDefinition(this.myProject);
            if (element == null) continue;
            this.myMembersMap.put(info, element);
        }
    }

    @Nullable
    protected abstract OCSymbolDeclarator addMember(@Nullable PsiElement var1, OCSymbol var2, @Nullable OCVisibility var3);

    @Nullable
    protected abstract VirtualFile getTargetFile(PsiElement var1, OCSymbol var2);
}

