/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.CommonBundle;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureDialog;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolder;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.EnumSet;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureActionHandler
implements ChangeSignatureHandler {
    public static final DataKey<OCCallableKind> CALLABLE_KIND = DataKey.create((String)"callable_kind");
    public static final Key<Boolean> FORCE_ADD_EXPLICIT_KEYWORD = Key.create((String)"FORCE_ADD_EXPLICIT_KEYWORD");

    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiElement targetMember;
        if (element == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(0);
        }
        return (targetMember = OCElementUtil.findRenameTargetDefinition(element, true)) != null ? targetMember.getOriginalElement() : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        OCChangeSignatureActionHandler.invoke(project, editor, this.findTargetMember(file, editor), (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(3);
        }
        OCChangeSignatureActionHandler.invoke(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), elements[0], (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return OCBundle.message("changeSignature.targetNotFound", new Object[0]);
    }

    private static void invoke(Project project, Editor editor, PsiElement element, OCCallableKind callableKind) {
        OCFunctionSymbol funcSym;
        OCSymbolHolderVirtualPsiElement symbolHolder;
        Object symbol;
        String title = RefactoringBundle.message((String)"changeSignature.refactoring.name");
        if (element instanceof OCSymbolHolderVirtualPsiElement && (symbol = (symbolHolder = (OCSymbolHolderVirtualPsiElement)element).getSymbol()) instanceof OCFunctionGroupSymbol) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)title, null);
            return;
        }
        if (!(element instanceof OCCallable)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("changeSignature.targetNotFound", new Object[0]), (String)title, null);
            return;
        }
        OCCallable callable = (OCCallable)element;
        if (!OCCodeInsightUtil.isValid(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)title, null);
            return;
        }
        symbol = callable.getSymbol();
        if (symbol instanceof OCFunctionSymbol && (funcSym = (OCFunctionSymbol)symbol).isCppDestructor()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("refactoring.changeSignature.destructor", new Object[0]), (String)title, null);
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, element);
        if (OCChangeSignatureActionHandler.checkVariableArguments(project, editor, handler)) {
            return;
        }
        if (callableKind != null) {
            if (((OCCallable)element).getBody() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("change.signature.convert.action", new Object[]{callableKind}), (String)title, null);
                return;
            }
            handler.setCallableKind(callableKind);
        }
        handler.invoke();
    }

    public static boolean checkVariableArguments(Project project, Editor editor, OCChangeSignatureHandler handler) {
        OCFunctionSymbol functionSymbol;
        OCMethodSymbol methodSymbol;
        OCMethodDescriptor methodDescriptor = handler.getMethodDescriptor();
        if (methodDescriptor == null) {
            return false;
        }
        OCSymbol symbol = methodDescriptor.getMethodSymbol();
        if (symbol instanceof OCMethodSymbol && (methodSymbol = (OCMethodSymbol)symbol).isVararg() || symbol instanceof OCFunctionSymbol && (functionSymbol = (OCFunctionSymbol)symbol).isVararg()) {
            String message = OCRefactoringBundle.message("dialog.message.can.t.refactor.with.variable.arguments", symbol.getKind().getNameLowercase());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
            return true;
        }
        return false;
    }

    public static EnumSet<ChangeSignatureFlags> getDefaultFlags(boolean silentMode) {
        return EnumSet.of(silentMode ? ChangeSignatureFlags.SilentMode : ChangeSignatureFlags.AskForSuperMethods);
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable<?> callable, @NotNull PsiElement context) {
        if (callable == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(5);
        }
        return OCChangeSignatureActionHandler.getHandler(callable, context, OCChangeSignatureActionHandler.getDefaultFlags(ApplicationManager.getApplication().isUnitTestMode()));
    }

    @Nullable
    private static OCSymbol adjustSymbolIfConstructor(@Nullable OCSymbol symbol, @NotNull Project project) {
        OCFunctionSymbol assocFunc;
        OCSymbol assocSymbol;
        OCFunctionSymbol funcSym;
        if (project == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(6);
        }
        if (symbol instanceof OCFunctionSymbol && (funcSym = (OCFunctionSymbol)symbol).isCppConstructor() && !funcSym.isPredeclaration() && (assocSymbol = funcSym.getAssociatedSymbol(project)) instanceof OCFunctionSymbol && (assocFunc = (OCFunctionSymbol)assocSymbol).isCppConstructor() && assocFunc.isPredeclaration()) {
            return assocSymbol;
        }
        return symbol;
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable<?> callable, @NotNull PsiElement context, @NotNull EnumSet<ChangeSignatureFlags> flags) {
        OCFunctionSymbol functionSymbol;
        if (callable == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(8);
        }
        if (flags == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(9);
        }
        OCSymbol symbol = callable.getSymbol();
        Project project = callable.getProject();
        boolean refactorAncestors = false;
        if (symbol instanceof OCSymbolWithParent) {
            OCSearchUtil.Ancestor ancestor;
            OCSymbolWithParent symbolWithParent = (OCSymbolWithParent)symbol;
            OCSearchUtil.Ancestor ancestor2 = ancestor = flags.contains((Object)ChangeSignatureFlags.IgnoreOutOfProjectAncestors) ? OCSearchUtil.findSomeInProjectAncestor(symbolWithParent, project) : OCSearchUtil.findSomeAncestor(symbolWithParent, project);
            if (ancestor != null) {
                String subject = symbol.getKind().getNameLowercase();
                OCCompilationContext compilationContext = OCCompilationContext.create(symbol, project);
                String message = OCRefactoringBundle.message("dialog.message.overrides.in.choice.which.out.project", symbol.getNameWithKindUppercase(compilationContext), subject, Objects.requireNonNull(ancestor.getSymbol().getParent()).getNameWithKindLowercase(compilationContext), ancestor.isOutOfProject() ? 0 : 1);
                if (ancestor.isOutOfProject()) {
                    int result;
                    if (flags.contains((Object)ChangeSignatureFlags.AskForSuperMethods) && (result = Messages.showYesNoDialog((Project)project, (String)(message + " " + OCRefactoringBundle.message("dialog.message.do.you.want.to.proceed.refactoring", new Object[0])), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon())) != 0) {
                        return new OCEmptyChangeSignatureHandler(project);
                    }
                } else {
                    int result;
                    if (flags.contains((Object)ChangeSignatureFlags.AskForSuperMethods)) {
                        result = Messages.showYesNoCancelDialog((Project)project, (String)(message + " " + OCRefactoringBundle.message("dialog.message.do.you.want.to.refactor.base.s", subject)), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon());
                    } else {
                        int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 1;
                    }
                    if (result == 0) {
                        if (OCChangeSignatureActionHandler.delegateToOtherChangeSignatureHandler(project, ancestor.getSymbol())) {
                            return new OCEmptyChangeSignatureHandler(project);
                        }
                        refactorAncestors = true;
                    } else if (result != 1) {
                        return new OCEmptyChangeSignatureHandler(project);
                    }
                }
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, callable)) {
            return new OCEmptyChangeSignatureHandler(project);
        }
        if (!callable.getContainingOCFile().getKind().isObjC()) {
            flags.remove((Object)ChangeSignatureFlags.IsChangeCallableKindPossible);
        }
        OCMethodDescriptor methodDescriptor = OCMethodDescriptor.createMethodDescriptor(callable);
        methodDescriptor.setChangeCallableKindPossible(flags.contains((Object)ChangeSignatureFlags.IsChangeCallableKindPossible));
        methodDescriptor.setSureIsConstructor(flags.contains((Object)ChangeSignatureFlags.SureThatConstructor));
        methodDescriptor.setWillBeMemberFunction(flags.contains((Object)ChangeSignatureFlags.WillBeMemberFunction));
        OCSymbol adjustedCtorSymbol = OCChangeSignatureActionHandler.adjustSymbolIfConstructor(symbol, project);
        methodDescriptor.setAddExplicitKeyword(adjustedCtorSymbol instanceof OCFunctionSymbol && (functionSymbol = (OCFunctionSymbol)adjustedCtorSymbol).isExplicit() || context.getContainingFile().getUserData(FORCE_ADD_EXPLICIT_KEYWORD) == Boolean.TRUE);
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol funcSym = (OCFunctionSymbol)symbol;
            methodDescriptor.setAddConstQualifier(funcSym.isConst());
            methodDescriptor.setAddConstexprSpecifier(funcSym.isConstexpr());
            methodDescriptor.setAddNoexceptSpecifier(funcSym.getType().getExceptionSpecification().isNoexcept());
        }
        OCChangeSignatureHandlerImpl handler = flags.contains((Object)ChangeSignatureFlags.SilentMode) ? new OCChangeSignatureHandlerImpl(methodDescriptor, context, true) : new OCChangeSignatureDialog(project, methodDescriptor, context).getHandler();
        handler.setChangeAncestors(refactorAncestors);
        return handler;
    }

    private static boolean delegateToOtherChangeSignatureHandler(@NotNull Project project, @Nullable OCSymbol ancestorSymbol) {
        PsiElement definition;
        if (project == null) {
            OCChangeSignatureActionHandler.$$$reportNull$$$0(10);
        }
        if (ancestorSymbol instanceof OCForeignSymbol && (definition = ancestorSymbol.locateDefinition(project)) instanceof OCSymbolHolder) {
            ChangeSignatureHandler handler;
            definition = definition.getOriginalElement();
            RefactoringSupportProvider provider2 = LanguageRefactoringSupport.getInstance().forContext(definition);
            if (provider2 != null && (handler = provider2.getChangeSignatureHandler()) != null) {
                handler.invoke(project, new PsiElement[]{definition}, null);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSymbolIfConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "delegateToOtherChangeSignatureHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ChangeSignatureFlags {
        IsChangeCallableKindPossible,
        SilentMode,
        AskForSuperMethods,
        IgnoreOutOfProjectAncestors,
        SureThatConstructor,
        WillBeMemberFunction;

    }
}

