/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClazyCheckForLine
extends SuppressIntentionAction {
    private final String mySuppressOption;
    private static final Pattern EXCLUDE_PATTERN = Pattern.compile(".*?(clazy:exclude=.*?\\s).*");

    public OCSuppressClazyCheckForLine(@Nullable OCSuppressionGroup suppressionGroup) {
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.suppress.for", (Object[])new Object[]{"line"});
        if (string == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static int getChecksEndOffset(@Nullable PsiElement element) {
        if (element == null) {
            return -1;
        }
        PsiFile file = element.getContainingFile();
        int offset = element.getTextOffset();
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return -1;
        }
        int line = document.getLineNumber(offset);
        @Nullable PsiElement eolElement = file.findElementAt(document.getLineEndOffset(line) - 1);
        if (eolElement == null || !OCLexerTokenTypes.COMMENTS.contains(OCElementUtil.getElementType(eolElement))) {
            return -1;
        }
        String commentText = eolElement.getText() + " ";
        Matcher match = EXCLUDE_PATTERN.matcher(commentText);
        if (!match.matches()) {
            return -1;
        }
        return eolElement.getTextOffset() + match.end(1) - 1;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file;
        Document document;
        if (project == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(1);
        }
        if (element == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(2);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(file = (OCFile)element.getContainingFile()).getProject()).getDocument((PsiFile)file)) == null) {
            return;
        }
        int offset = OCSuppressClazyCheckForLine.getChecksEndOffset(element);
        if (offset != -1) {
            document.insertString(offset, (CharSequence)("," + this.mySuppressOption.replace("-Wclazy-", "")));
        } else {
            offset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
            document.insertString(document.getLineEndOffset(document.getLineNumber(offset)), (CharSequence)("// clazy:exclude=" + this.mySuppressOption.replace("-Wclazy-", "")));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(4);
        }
        return element.isValid() && this.mySuppressOption != null;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.suppress.option.for", (Object[])new Object[]{this.mySuppressOption, "line"});
        if (string == null) {
            OCSuppressClazyCheckForLine.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClazyCheckForLine";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClazyCheckForLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

