/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class OCFileUtil {
    @Nullable
    public static PsiFile getOriginalFile(@Nullable PsiFile file) {
        PsiFile physical;
        if (file == null) {
            return null;
        }
        PsiFile original = OCLanguageUtils.asFileWithOCResolve(file.getOriginalFile());
        if (original == null) {
            return null;
        }
        if (original.isPhysical()) {
            return original;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        return OCLanguageUtils.asFileWithOCResolve(physical != null ? physical.getContainingFile() : null);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiFile file) {
        PsiFile prevOriginalFile;
        if (file == null) {
            return null;
        }
        PsiFile originalFile = file;
        do {
            prevOriginalFile = originalFile;
        } while ((originalFile = originalFile.getOriginalFile()) != prevOriginalFile);
        VirtualFile vFile = originalFile.getVirtualFile();
        if (vFile != null) {
            return vFile;
        }
        return originalFile.getViewProvider().getVirtualFile();
    }
}

