/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public final class OCStatementWithoutBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCStatementWithoutBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.add.braces.statement.family", (Object[])new Object[0]);
        if (string == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.add.braces.statement", (Object[])new Object[]{this.getStatementName()});
        if (string == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement;
        if (project == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((statement = OCStatementWithoutBracesIntentionAction.getParentStatement(element)) != null);
        PsiElement bodyElement = this.getBodyElement(statement, element);
        LOG.assertTrue(bodyElement != null);
        int moveCaretBy = OCStatementWithoutBracesIntentionAction.getCaretAdjustment(bodyElement, editor);
        OCBlockStatement newBodyElement = OCStatementWithoutBracesIntentionAction.surroundByBracesAndReplace(bodyElement);
        LOG.assertTrue(newBodyElement.getStatements().size() == 1);
        OCStatementWithoutBracesIntentionAction.adjustCaret(newBodyElement, editor, moveCaretBy);
        OCStatementWithoutBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCExpression nextExpr;
        PsiElement nextSibling;
        PsiElement expr;
        if (statement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(5);
        }
        if ((expr = this.getBodyElement(statement, element)) == null) {
            return false;
        }
        if (expr.getPrevSibling() instanceof OCMacroCall && (nextSibling = statement.getNextSibling()) instanceof OCExpressionStatement && OCElementUtil.isPartOfMacroSubstitution(nextExpr = ((OCExpressionStatement)nextSibling).getExpression())) {
            return false;
        }
        return !(expr instanceof OCBlockStatement);
    }

    @NotNull
    private static OCBlockStatement surroundByBracesAndReplace(@NotNull PsiElement bodyElement) {
        if (bodyElement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(6);
        }
        PsiElement leftMostSibling = OCStatementWithoutBracesIntentionAction.getLeftMostMacroCallOrWhiteSpaceSibling(bodyElement);
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", bodyElement);
        PsiElement rightMostSibling = OCStatementWithoutBracesIntentionAction.getRightMostMacroCallOrWhiteSpaceSibling(bodyElement);
        blockStatement.addRangeAfter(leftMostSibling, rightMostSibling, blockStatement.getOpeningBrace());
        if (leftMostSibling != bodyElement) {
            bodyElement.getParent().deleteChildRange(leftMostSibling, bodyElement.getPrevSibling());
        }
        if (rightMostSibling != bodyElement) {
            bodyElement.getParent().deleteChildRange(bodyElement.getNextSibling(), rightMostSibling);
        }
        OCBlockStatement oCBlockStatement = (OCBlockStatement)bodyElement.replace((PsiElement)blockStatement);
        if (oCBlockStatement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(7);
        }
        return oCBlockStatement;
    }

    private static int getCaretAdjustment(@NotNull PsiElement bodyElement, @NotNull Editor editor) {
        if (bodyElement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(9);
        }
        PsiElement prevSibling = bodyElement.getPrevSibling();
        PsiElement nestedExpr = OCStatementWithoutBracesIntentionAction.getMacroOrElement(bodyElement, prevSibling);
        CaretModel caretModel = editor.getCaretModel();
        return OCStatementWithoutBracesIntentionAction.getCaretAdjustment(caretModel, nestedExpr);
    }

    private static void adjustCaret(@NotNull OCBlockStatement newElement, @NotNull Editor editor, int moveCaretBy) {
        if (newElement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(11);
        }
        PsiElement bodyElement = newElement.getStatements().get(0);
        PsiElement caretAnchor = OCStatementWithoutBracesIntentionAction.getMacroOrElement(bodyElement);
        OCStatementWithoutBracesIntentionAction.moveCaret(editor.getCaretModel(), moveCaretBy, caretAnchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCStatementWithoutBracesIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCStatementWithoutBracesIntentionAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundByBracesAndReplace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "surroundByBracesAndReplace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAdjustment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

