/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCRemoveUnnecessaryParenthesesIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCParenthesizedExpression expression;
        if (project == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(1);
        }
        if ((expression = (OCParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class)) == null || OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression.getOperand()) && !(expression.getParent() instanceof OCParenthesizedExpression)) {
            return false;
        }
        this.setText(this.getFamilyName());
        PsiElement parent = expression.getParent();
        if (parent instanceof OCParenthesizedExpression) {
            return true;
        }
        OCExpression child = expression.getOperand();
        if (child instanceof OCParenthesizedExpression || child instanceof OCSendMessageExpression) {
            return true;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(child, false))) {
                return true;
            }
            if (parentPrecedence < destPrecedence) {
                return false;
            }
            if (parent instanceof OCBinaryExpression && expression == ((OCBinaryExpression)parent).getRight()) {
                return !OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, child);
            }
            if (parent instanceof OCAssignmentExpression && expression == ((OCAssignmentExpression)parent).getReceiverExpression()) {
                return !OCParenthesesUtils.isParenthesesNeededInLeftArgument((OCAssignmentExpression)parent, child);
            }
            return true;
        }
        return true;
    }

    private static boolean isAssignmentInCondition(OCExpression parent) {
        return parent instanceof OCAssignmentExpression && OCRemoveUnnecessaryParenthesesIntention.isExpectedBool(parent);
    }

    private static boolean isExpectedBool(@NotNull OCExpression parent) {
        if (parent == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(2);
        }
        OCResolveContext context = OCResolveContext.forPsi(parent);
        return OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(parent, context), context);
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.remove.unnecessary.parentheses", (Object[])new Object[0]);
        if (string == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression;
        if (project == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(5);
        }
        if ((expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class)) == null) {
            return;
        }
        OCExpression parent = expression;
        OCParenthesizedExpression prevParent = (OCParenthesizedExpression)expression;
        while (parent instanceof OCParenthesizedExpression) {
            prevParent = (OCParenthesizedExpression)parent;
            parent = parent.getParent();
        }
        while (expression instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expression)) {
            expression = ((OCParenthesizedExpression)expression).getOperand();
        }
        if (OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression) && expression.getParent() instanceof OCExpression) {
            expression = (OCExpression)expression.getParent();
        }
        if (expression == null) {
            return;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence(parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(expression, false)) || expression instanceof OCSendMessageExpression) {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
            } else if (parentPrecedence < destPrecedence) {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
            } else if (parent instanceof OCBinaryExpression && prevParent == ((OCBinaryExpression)parent).getRight()) {
                if (OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, expression)) {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
                } else {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
                }
            } else if (parent instanceof OCAssignmentExpression && prevParent == ((OCAssignmentExpression)parent).getReceiverExpression()) {
                if (OCParenthesesUtils.isParenthesesNeededInLeftArgument((OCAssignmentExpression)parent, expression)) {
                    OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, true);
                }
            } else {
                OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
            }
        } else {
            OCRemoveUnnecessaryParenthesesIntention.replaceExpression(prevParent, expression, false);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parent);
    }

    private static void replaceExpression(@NotNull PsiElement topmostParenthesesElement, @NotNull OCExpression expression, boolean appendParentheses) {
        if (topmostParenthesesElement == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(7);
        }
        SmartList elementsToPreserveBefore = new SmartList();
        SmartList elementsToPreserveAfter = new SmartList();
        for (OCExpression parentElement = expression; parentElement != topmostParenthesesElement; parentElement = parentElement.getParent()) {
            elementsToPreserveBefore.addAll(0, OCRemoveUnnecessaryParenthesesIntention.getElementsToPreserveBefore(parentElement));
            elementsToPreserveAfter.addAll(OCRemoveUnnecessaryParenthesesIntention.getElementsToPreserveAfter(parentElement));
        }
        if (appendParentheses) {
            OCParenthesizedExpression targetExpression = OCParenthesesUtils.appendParentheses(expression);
            OCExpression targetExpressionOperand = OCParenthesesUtils.diveIntoParentheses(targetExpression);
            if (targetExpressionOperand != null) {
                OCRemoveUnnecessaryParenthesesIntention.copyElementsBefore((List<PsiElement>)elementsToPreserveBefore, targetExpressionOperand);
                OCRemoveUnnecessaryParenthesesIntention.copyElementsAfter((List<PsiElement>)elementsToPreserveAfter, targetExpressionOperand);
            }
            OCChangeUtil.replaceHandlingMacros(topmostParenthesesElement, targetExpression);
        } else {
            OCRemoveUnnecessaryParenthesesIntention.copyElementsBefore((List<PsiElement>)elementsToPreserveBefore, topmostParenthesesElement);
            OCRemoveUnnecessaryParenthesesIntention.copyElementsAfter((List<PsiElement>)elementsToPreserveAfter, topmostParenthesesElement);
            OCChangeUtil.replaceHandlingMacros(topmostParenthesesElement, expression);
        }
    }

    private static List<PsiElement> getElementsToPreserveBefore(@NotNull PsiElement element) {
        PsiElement prevSibling;
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(8);
        }
        SmartList elements = new SmartList();
        PsiElement elementBefore = element;
        while ((prevSibling = elementBefore.getPrevSibling()) != null && OCLexerTokenTypes.LPAR != prevSibling.getNode().getElementType()) {
            if (OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prevSibling.getNode().getElementType())) {
                elements.add(prevSibling);
            }
            elementBefore = prevSibling;
        }
        return elements;
    }

    private static List<PsiElement> getElementsToPreserveAfter(@NotNull PsiElement element) {
        PsiElement nextSibling;
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(9);
        }
        SmartList elements = new SmartList();
        PsiElement elementAfter = element;
        while ((nextSibling = elementAfter.getNextSibling()) != null && OCLexerTokenTypes.RPAR != nextSibling.getNode().getElementType()) {
            if (OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(nextSibling.getNode().getElementType())) {
                elements.add(nextSibling);
            }
            elementAfter = nextSibling;
        }
        return elements;
    }

    private static void copyElementsBefore(@NotNull List<PsiElement> beforeElements, @NotNull PsiElement targetElement) {
        if (beforeElements == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(10);
        }
        if (targetElement == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(11);
        }
        for (PsiElement beforeElement : beforeElements) {
            targetElement.getParent().addBefore(beforeElement, targetElement);
        }
    }

    private static void copyElementsAfter(@NotNull List<PsiElement> afterElements, @NotNull PsiElement targetElement) {
        if (afterElements == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(12);
        }
        if (targetElement == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(13);
        }
        for (int i = afterElements.size() - 1; i >= 0; --i) {
            targetElement.getParent().addAfter(afterElements.get(i), targetElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCRemoveUnnecessaryParenthesesIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topmostParenthesesElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeElements";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCRemoveUnnecessaryParenthesesIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedBool";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToPreserveBefore";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToPreserveAfter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyElementsBefore";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyElementsAfter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

