/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.TextRangeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.intentions.OCDeMorganIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCControlFlowUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.util.OCSimplifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInvertIfConditionIntentionAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCInvertIfConditionIntentionAction.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.invert.if.condition", (Object[])new Object[0]);
        if (string == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        IElementType elementType;
        OCIfStatement ifStatement;
        if (project == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(3);
        }
        if ((ifStatement = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class, (boolean)false)) == null) {
            return false;
        }
        if (ifStatement.getCondition() == null || ifStatement.getThenBranch() == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!ifStatement.getCondition().getTextRange().contains(offset) && (elementType = element.getNode().getElementType()) != OCLexerTokenTypes.IF_KEYWORD && elementType != OCLexerTokenTypes.ELSE_KEYWORD) {
            return false;
        }
        return OCInvertIfConditionIntentionAction.canInvertCondition(ifStatement.getCondition()) && OCInvertIfConditionIntentionAction.canBuildControlFlow(ifStatement);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCIfStatement ifStatement;
        if (project == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((ifStatement = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class)) != null);
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCCallable.class);
        LOG.assertTrue(callable != null);
        OCControlFlowGraph controlFlowGraph = OCControlFlowUtil.buildControlFlowGraph(callable);
        OCNode ifNode = OCControlFlowUtil.findNodeForElement(controlFlowGraph, ifStatement);
        LOG.assertTrue(ifNode != null);
        List<OCNode> jumpTargets = ifNode.getJumpTargets();
        LOG.assertTrue(jumpTargets != null && jumpTargets.size() == 2);
        OCNode thenNode = jumpTargets.get(0);
        OCNode elseNode = OCControlFlowUtil.getSignificantNode(jumpTargets.get(1));
        OCInvertIfConditionIntentionAction.invertCondition(project, editor, ifStatement);
        ifStatement = OCInvertIfConditionIntentionAction.invertBranches(callable, ifStatement, thenNode, elseNode);
        OCInvertIfConditionIntentionAction.reformat(project, editor.getDocument(), ifStatement);
    }

    private static OCIfStatement invertBranches(@NotNull OCCallable callable, @NotNull OCIfStatement ifStatement, @NotNull OCNode thenNode, @NotNull OCNode elseNode) {
        boolean hasElseBranch;
        OCCondition condition;
        if (callable == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(6);
        }
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(7);
        }
        if (thenNode == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(8);
        }
        if (elseNode == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(9);
        }
        LOG.assertTrue((condition = ifStatement.getCondition()) != null);
        OCStatement thenBranch = ifStatement.getThenBranch();
        LOG.assertTrue(thenBranch != null);
        OCStatement elseBranch = ifStatement.getElseBranch();
        boolean bl = hasElseBranch = elseBranch != null;
        if (hasElseBranch) {
            OCStatement elseBranchCopy = (OCStatement)OCChangeUtil.copyHandlingMacros(elseBranch);
            ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
            ifStatement.setThen(OCInvertIfConditionIntentionAction.surroundByBracesOptional(elseBranchCopy));
            return ifStatement;
        }
        PsiElement elementToJump = OCControlFlowUtil.getFirstPsiElement(elseNode);
        if (elementToJump == null) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(callable);
            if (OCCallableUtil.hasVoidReturnType(callable, resolveContext)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen(OCElementFactory.statementFromText("return;", ifStatement));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, null, callable);
                return ifStatement;
            }
        } else {
            if (OCInvertIfConditionIntentionAction.backwardJumpToLoop(elementToJump, ifStatement)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen(OCElementFactory.statementFromText("continue;", ifStatement));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, null, callable);
                return ifStatement;
            }
            if (OCInvertIfConditionIntentionAction.isControlFlowStatement(elementToJump)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen((OCStatement)OCChangeUtil.copyHandlingMacros(elementToJump));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, elementToJump, callable);
                return ifStatement;
            }
            if (!OCControlFlowUtil.isNodeReachableFrom(thenNode, elseNode, false)) {
                PsiElement firstSibling;
                PsiElement psiElement = firstSibling = ifStatement.getParent() instanceof OCCaseStatement ? OCElementUtil.getNextSiblingOrParentSibling(ifStatement) : ifStatement.getNextSibling();
                if (firstSibling != null) {
                    PsiElement lastSibling = firstSibling;
                    for (PsiElement nextSibling = lastSibling.getNextSibling(); nextSibling != null && nextSibling.getNode().getElementType() != OCLexerTokenTypes.RBRACE && !(nextSibling instanceof OCCaseStatement); nextSibling = nextSibling.getNextSibling()) {
                        lastSibling = nextSibling;
                    }
                    OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", ifStatement);
                    blockStatement.addRangeAfter(firstSibling, lastSibling, blockStatement.getOpeningBrace());
                    firstSibling.getParent().deleteChildRange(firstSibling, lastSibling);
                    ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
                    ifStatement.setThen(blockStatement);
                    OCInvertIfConditionIntentionAction.optimizeElseBranch(ifStatement);
                    return ifStatement;
                }
            }
        }
        ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
        ifStatement.setThen(OCElementFactory.statementFromText("{}", ifStatement));
        return ifStatement;
    }

    private static OCStatement surroundByBracesOptional(@NotNull OCStatement element) {
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(10);
        }
        if (element instanceof OCExpressionStatement || OCInvertIfConditionIntentionAction.isControlFlowStatement(element)) {
            return element;
        }
        return OCElementFactory.surroundByBraces(element);
    }

    private static void renameNestedDeclaratorsWithCollisions(@NotNull OCIfStatement ifStatement, @NotNull OCCallable callable) {
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(11);
        }
        if (callable == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(12);
        }
        Set<PsiNamedElement> nestedDeclarators = OCCodeInsightUtil.collectDeclarators(ifStatement);
        Set<PsiNamedElement> declarators = OCCodeInsightUtil.collectDeclarators(callable);
        declarators.removeAll(nestedDeclarators);
        Set declaratorNames = declarators.stream().map(declarator -> declarator.getName()).collect(Collectors.toSet());
        for (PsiNamedElement nestedDeclarator : nestedDeclarators) {
            OCSymbol nestedDeclaratorSymbol;
            if (!declaratorNames.contains(nestedDeclarator.getName()) || (nestedDeclaratorSymbol = ((OCDeclarator)nestedDeclarator).getSymbol()) == null) continue;
            List<PsiElement> nestedDeclaratorUsages = OCCodeInsightUtil.getReferences(nestedDeclarator);
            String newNestedDeclaratorName = OCUniqueNameGenerator.suggestUniqueName(nestedDeclaratorSymbol, ifStatement, callable.getProject());
            OCCodeInsightUtil.renameDeclaratorAndUsages(nestedDeclarator, newNestedDeclaratorName, nestedDeclaratorUsages);
        }
    }

    private static boolean isControlFlowStatement(@NotNull PsiElement element) {
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(13);
        }
        if (element instanceof OCExpressionStatement) {
            OCExpression expression = ((OCExpressionStatement)element).getExpression();
            return expression instanceof OCThrowExpression;
        }
        return element instanceof OCReturnStatement || element instanceof OCContinueStatement || element instanceof OCBreakStatement || element instanceof OCGotoStatement;
    }

    private static boolean backwardJumpToLoop(@NotNull PsiElement elementToJump, @NotNull OCIfStatement ifStatement) {
        OCLoopStatement loopStatement;
        if (elementToJump == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(14);
        }
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(15);
        }
        if (elementToJump instanceof OCLoopStatement) {
            loopStatement = (OCLoopStatement)elementToJump;
        } else {
            loopStatement = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToJump, OCLoopStatement.class);
            if (loopStatement == null) {
                return false;
            }
            ASTNode leftParenth = loopStatement.getLParenth();
            ASTNode rightParenth = loopStatement.getRParenth();
            if (leftParenth == null || rightParenth == null) {
                return false;
            }
            TextRange loopConditionTextRange = TextRangeUtil.getEnclosingTextRange(Arrays.asList(leftParenth.getTextRange(), rightParenth.getTextRange()));
            if (!loopConditionTextRange.contains(elementToJump.getTextOffset())) {
                return false;
            }
        }
        return PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)ifStatement, (boolean)true);
    }

    private static void reformat(@NotNull Project project, @NotNull Document document, @NotNull OCIfStatement ifStatement) {
        if (project == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(16);
        }
        if (document == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(17);
        }
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(18);
        }
        RangeMarker adjustRange = null;
        if (ifStatement.getElseBranch() != null) {
            adjustRange = document.createRangeMarker(ifStatement.getTextRange().getStartOffset(), ifStatement.getParent().getTextRange().getEndOffset());
        }
        RangeMarker formatRange = document.createRangeMarker(ifStatement.getTextRange().getStartOffset(), ifStatement.getTextRange().getEndOffset());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        OCFile file = ifStatement.getContainingOCFile();
        OCChangeUtil.processPostponedFormatIfNeed(file);
        if (formatRange.isValid()) {
            codeStyleManager.reformatText((PsiFile)file, formatRange.getStartOffset(), formatRange.getEndOffset());
            if (adjustRange != null && adjustRange.isValid()) {
                codeStyleManager.adjustLineIndent((PsiFile)file, adjustRange.getTextRange());
            }
        }
    }

    private static void invertCondition(@NotNull Project project, @NotNull Editor editor, @NotNull OCIfStatement ifStatement) {
        OCCondition condition;
        if (project == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(20);
        }
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(21);
        }
        LOG.assertTrue((condition = ifStatement.getCondition()) != null && condition.getExpression() != null);
        OCExpression conditionExpression = condition.getExpression();
        OCExpression expressionToInvert = OCParenthesesUtils.getPrecedence(conditionExpression, false) > 4 ? OCParenthesesUtils.appendParentheses(conditionExpression) : conditionExpression;
        ifStatement.setCondition(OCElementFactory.unaryExpression(expressionToInvert, (OCElementType)OCLexerTokenTypes.EXCL));
        OCInvertIfConditionIntentionAction.simplify(ifStatement.getCondition(), editor, project);
        if (!(ifStatement.getCondition().getExpression() instanceof OCUnaryExpression)) {
            return;
        }
        OCExpression operand = OCParenthesesUtils.diveIntoParentheses(((OCUnaryExpression)ifStatement.getCondition().getExpression()).getOperand());
        OCDeMorganIntentionAction deMorganIntentionAction = new OCDeMorganIntentionAction();
        if (operand != null && deMorganIntentionAction.isAvailable(project, editor, operand)) {
            deMorganIntentionAction.invoke(project, editor, operand);
        }
    }

    private static void simplify(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        IntentionAction simplifyFix;
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(23);
        }
        if (project == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(24);
        }
        if ((simplifyFix = OCSimplifyUtil.getSimplifyFix(element)) != null) {
            simplifyFix.invoke(project, editor, element.getContainingFile());
        }
    }

    private static boolean canInvertCondition(@NotNull OCCondition condition) {
        if (condition == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(25);
        }
        return condition.getDeclaration() == null && condition.getExpression() != null;
    }

    private static void optimizeRedundantStatements(@NotNull OCIfStatement ifStatement, @Nullable PsiElement elementToJump, @NotNull OCCallable callable) {
        OCStatement lastStatement;
        List<OCStatement> statements;
        OCLoopStatement loopStatement;
        OCControlFlowGraph controlFlowGraph;
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(26);
        }
        if (callable == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(27);
        }
        if (elementToJump != null && OCControlFlowUtil.isUnreachable(controlFlowGraph = OCInvertIfConditionIntentionAction.buildLocalControlFlowGraph(elementToJump, callable), elementToJump)) {
            OCChangeUtil.delete(elementToJump);
        }
        if ((loopStatement = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCLoopStatement.class)) != null && loopStatement.getBody() instanceof OCBlockStatement && !(statements = ((OCBlockStatement)loopStatement.getBody()).getStatements()).isEmpty()) {
            lastStatement = statements.get(statements.size() - 1);
            if (statements.contains(ifStatement) && lastStatement instanceof OCContinueStatement) {
                OCChangeUtil.delete(lastStatement);
            }
        }
        if (callable.getBody() != null && !(statements = callable.getBody().getStatements()).isEmpty()) {
            lastStatement = statements.get(statements.size() - 1);
            if (statements.contains(ifStatement) && OCInvertIfConditionIntentionAction.isEmptyReturn(lastStatement)) {
                OCChangeUtil.delete(lastStatement);
            }
        }
    }

    private static void optimizeElseBranch(@NotNull OCIfStatement ifStatement) {
        List<OCStatement> elseStatements;
        OCStatement elseBranch;
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(28);
        }
        if ((elseBranch = ifStatement.getElseBranch()) == null || !OCInvertIfConditionIntentionAction.isLastStatement(ifStatement)) {
            return;
        }
        List<OCStatement> list = elseStatements = elseBranch instanceof OCBlockStatement ? ((OCBlockStatement)elseBranch).getStatements() : Collections.singletonList(elseBranch);
        if (elseStatements.isEmpty()) {
            return;
        }
        OCStatement lastElseStatement = elseStatements.get(elseStatements.size() - 1);
        boolean canOptimize = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCLoopStatement.class) != null) {
            if (lastElseStatement instanceof OCContinueStatement) {
                canOptimize = true;
            }
        } else if (OCInvertIfConditionIntentionAction.isEmptyReturn(lastElseStatement)) {
            canOptimize = true;
        }
        if (!canOptimize) {
            return;
        }
        if (elseStatements.size() == 1) {
            ASTNode ifStatementNode = ifStatement.getNode();
            ifStatementNode.removeRange(ifStatement.getElseKeyword(), elseBranch.getNode().getTreeNext());
        } else {
            OCChangeUtil.delete(lastElseStatement);
        }
    }

    private static boolean isEmptyReturn(@NotNull PsiElement element) {
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(29);
        }
        return element instanceof OCReturnStatement && ((OCReturnStatement)element).getExpression() == null;
    }

    private static boolean isLastStatement(@NotNull OCStatement statement) {
        if (statement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(30);
        }
        PsiElement parentStatement = statement.getParent();
        while (!(parentStatement instanceof OCLoopStatement) && !(parentStatement instanceof OCCallable)) {
            List<OCStatement> statements;
            if (parentStatement instanceof OCBlockStatement && !(statements = ((OCBlockStatement)parentStatement).getStatements()).isEmpty() && !PsiTreeUtil.isAncestor((PsiElement)statements.get(statements.size() - 1), (PsiElement)statement, (boolean)false)) {
                return false;
            }
            parentStatement = parentStatement.getParent();
        }
        return true;
    }

    private static boolean canBuildControlFlow(@NotNull OCIfStatement ifStatement) {
        if (ifStatement == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(31);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCCallable.class) != null;
    }

    @NotNull
    private static OCControlFlowGraph buildLocalControlFlowGraph(@NotNull PsiElement element, @NotNull OCCallable callable) {
        PsiElement scopeElement;
        if (element == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(32);
        }
        if (callable == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(33);
        }
        if ((scopeElement = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class)) == null) {
            scopeElement = callable;
        }
        OCControlFlowGraph oCControlFlowGraph = OCControlFlowUtil.buildControlFlowGraph(scopeElement, callable);
        if (oCControlFlowGraph == null) {
            OCInvertIfConditionIntentionAction.$$$reportNull$$$0(34);
        }
        return oCControlFlowGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCInvertIfConditionIntentionAction";
                break;
            }
            case 2: 
            case 4: 
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 22: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 12: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToJump";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCInvertIfConditionIntentionAction";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLocalControlFlowGraph";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invertBranches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "surroundByBracesOptional";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "renameNestedDeclaratorsWithCollisions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isControlFlowStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "backwardJumpToLoop";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invertCondition";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canInvertCondition";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "optimizeRedundantStatements";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "optimizeElseBranch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyReturn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isLastStatement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canBuildControlFlow";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildLocalControlFlowGraph";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> new IllegalArgumentException(string);
        };
    }
}

