/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
        if (string == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(1);
        }
        assert (editor != null);
        OCFunctionSymbol function = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, psiFile);
        if (function == null) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Boolean result = (Boolean)OCLongActionUtil.runReadActionInBackgroundAndWait(() -> OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project), (long)1000L);
            return result != null ? result : true;
        }
        return OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(2);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCFunctionSymbol symbol = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, psiFile);
        if (symbol == null) {
            return;
        }
        new OCGenerateDefinitionActionHandler(project, psiFile, symbol, OCCppDefinitionsUtil.InlinePolicy.get(this.isInline()), true).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findSuitableFunction(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement at;
        OCFunctionDeclaration function;
        OCSymbolWithQualifiedName symbol;
        OCFunctionSymbol functionSymbol;
        if (editor == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(4);
        }
        if ((functionSymbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)(symbol = (function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)(at = file.findElementAt(editor.getCaretModel().getOffset())), OCFunctionDeclaration.class)) != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null), OCFunctionSymbol.class)) == null || functionSymbol.getParent() instanceof OCStructSymbol) {
            return null;
        }
        if (functionSymbol.getQualifier() != null) {
            return null;
        }
        return functionSymbol;
    }

    private static boolean shouldGenerateDefinitionFor(OCFunctionSymbol function, @NotNull Project project) {
        if (project == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(5);
        }
        return function != null && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function, true, project) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.POSSIBLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCGenerateDefinitionsIntentionActionBase";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCGenerateDefinitionsIntentionActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateDefinitionFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

