/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCQNGroup;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNamesNodeProvider
implements Grouper,
FileStructureNodeProvider<OCStructureViewElement>,
PropertyOwner {
    @NonNls
    public static final String QUALIFIED_NAMES_PROVIDER_PROPERTY = "qualified.names.node.provider";
    @NonNls
    public static final String ACTION_ID = "QUALIFIED_NAMES";
    private static final Logger LOG = Logger.getInstance(OCQualifiedNamesNodeProvider.class);
    private String mySeparator = "::";

    @NotNull
    public String getCheckBoxText() {
        String string = OCBundle.message("action.CIDR.Lang.QualifiedNames.text", new Object[0]);
        if (string == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Shortcut @NotNull [] getShortcut() {
        Shortcut[] shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)(ClientSystemInfo.isMac() ? "meta F11" : "control F11"))};
        if (shortcutArray == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(1);
        }
        return shortcutArray;
    }

    @NotNull
    public Collection<OCStructureViewElement> provideNodes(@NotNull TreeElement node) {
        if (node == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(2);
        }
        List<OCStructureViewElement> list = Collections.emptyList();
        if (list == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(OCBundle.message("action.CIDR.Lang.QualifiedNames.text", new Object[0]), OCBundle.message("action.CIDR.Lang.QualifiedNames.description", new Object[0]), CidrLangIcons.ActionQualifiedNames);
    }

    @NotNull
    public String getName() {
        return ACTION_ID;
    }

    @NotNull
    public String getPropertyName() {
        return QUALIFIED_NAMES_PROVIDER_PROPERTY;
    }

    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        int parentPrefixLength;
        String parentPrefix;
        if (parent == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(4);
        }
        if (children == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(5);
        }
        ArrayList<Key> keys = new ArrayList<Key>();
        if (parent.getValue() instanceof OCQNGroup) {
            parentPrefix = ((OCQNGroup)parent.getValue()).getPrefix();
            parentPrefixLength = OCQualifiedNamesNodeProvider.splitAccurate(parentPrefix, this.mySeparator).size();
        } else {
            parentPrefix = "";
            parentPrefixLength = 0;
        }
        for (TreeElement element : children) {
            boolean expected;
            String text = OCQualifiedNamesNodeProvider.getFullQNIfAny(element);
            if (text == null) continue;
            boolean bl = expected = text.startsWith(parentPrefix) || text.startsWith(this.mySeparator);
            if (!expected) {
                LOG.error("unexpected text: " + text + "; parentPrefix=" + parentPrefix + "; mySeparator=" + this.mySeparator);
            }
            List<String> words = OCQualifiedNamesNodeProvider.splitAccurate(text, this.mySeparator);
            keys.add(new Key(words, element));
        }
        if (keys.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                OCQualifiedNamesNodeProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        keys.sort((k1, k2) -> {
            List<String> o1 = k1.words;
            List<String> o2 = k2.words;
            for (int i = 0; i < Math.max(o1.size(), o2.size()); ++i) {
                String s2;
                if (i == o1.size()) {
                    return 1;
                }
                if (i == o2.size()) {
                    return -1;
                }
                String s1 = o1.get(i);
                int res = s1.compareTo(s2 = o2.get(i));
                if (res == 0) continue;
                return res;
            }
            return 0;
        });
        ArrayList<Group> groups = new ArrayList<Group>();
        int groupStart = 0;
        for (int i = 0; i <= keys.size(); ++i) {
            if (!OCQualifiedNamesNodeProvider.isEndOfGroup(i, keys, parentPrefixLength)) continue;
            List firstKey = groupStart == keys.size() ? Collections.emptyList() : ((Key)keys.get((int)groupStart)).words;
            SmartList groupChildren = new SmartList();
            groupChildren.add(((Key)keys.get((int)groupStart)).node);
            int prefixLen = firstKey.size();
            for (int j = groupStart + 1; j < i; ++j) {
                List<String> prevKey = ((Key)keys.get((int)(j - 1))).words;
                List<String> nextKey = ((Key)keys.get((int)j)).words;
                for (int k = parentPrefixLength; k < prefixLen; ++k) {
                    String wordInPrevKey;
                    String word = k < nextKey.size() ? nextKey.get(k) : null;
                    String string = wordInPrevKey = k < prevKey.size() ? prevKey.get(k) : null;
                    if (Comparing.strEqual((String)word, (String)wordInPrevKey)) continue;
                    prefixLen = k;
                    break;
                }
                groupChildren.add(((Key)keys.get((int)j)).node);
            }
            String[] strings = firstKey.subList(0, prefixLen).toArray(new String[prefixLen]);
            String prefix = StringUtil.join((String[])strings, (String)this.mySeparator);
            String presentableName = prefix.substring(parentPrefix.length());
            if (!(presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator)).isEmpty()) {
                groups.add(new OCQNGroup((Collection<TreeElement>)groupChildren, prefix, presentableName, this.mySeparator));
            } else if (groupStart != keys.size()) {
                TreeElement node = ((Key)keys.get((int)groupStart)).node;
                ((OCStructureViewElement)node).setPresentableQN(presentableName);
            }
            groupStart = i;
        }
        ArrayList<Group> arrayList = groups;
        if (arrayList == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean isEndOfGroup(int i, @NotNull List<Key> keys, int parentPrefixLength) {
        if (keys == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(8);
        }
        if (i == keys.size()) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        List<String> words = keys.get((int)i).words;
        List<String> prevWords = keys.get((int)(i - 1)).words;
        if (prevWords.size() == parentPrefixLength) {
            return true;
        }
        if (words.size() == parentPrefixLength) {
            return true;
        }
        return !Comparing.strEqual((String)words.get(parentPrefixLength), (String)prevWords.get(parentPrefixLength));
    }

    @Nullable
    private static String getFullQNIfAny(@NotNull TreeElement element) {
        if (element == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(9);
        }
        if (element instanceof OCStructureViewElement) {
            return ((OCStructureViewElement)element).getFullQN();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<String> splitAccurate(@NotNull String qName, @NotNull String separator) {
        if (qName == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(10);
        }
        if (separator == null) {
            OCQualifiedNamesNodeProvider.$$$reportNull$$$0(11);
        }
        List plain = StringUtil.split((String)qName, (String)separator);
        ArrayList<String> res = new ArrayList<String>();
        int currentPlainPart = 0;
        while (true) {
            Object qnCandidate;
            block17: {
                if (currentPlainPart >= plain.size()) {
                    ArrayList<String> arrayList = res;
                    if (arrayList == null) {
                        OCQualifiedNamesNodeProvider.$$$reportNull$$$0(12);
                    }
                    return arrayList;
                }
                qnCandidate = (String)plain.get(currentPlainPart);
                int braceCount = 0;
                int posInCandidate = 0;
                Stack<Character> braces = new Stack<Character>();
                while (true) {
                    block18: {
                        if (posInCandidate >= ((String)qnCandidate).length()) break block18;
                        char ch = ((String)qnCandidate).charAt(posInCandidate);
                        switch (ch) {
                            case '(': 
                            case '[': {
                                braces.push(Character.valueOf(ch));
                                break;
                            }
                            case ')': {
                                if (!braces.isEmpty() && ((Character)braces.pop()).equals(Character.valueOf('('))) break;
                                braceCount = -1;
                                break;
                            }
                            case ']': {
                                if (!braces.isEmpty() && ((Character)braces.pop()).equals(Character.valueOf('['))) break;
                                braceCount = -1;
                                break;
                            }
                            case '<': {
                                if (!braces.isEmpty()) break;
                                ++braceCount;
                                break;
                            }
                            case '>': {
                                if (braces.isEmpty()) {
                                    --braceCount;
                                }
                                if (braceCount < 0) break block18;
                            }
                        }
                        ++posInCandidate;
                        continue;
                    }
                    if (braceCount <= 0) break;
                    if (++currentPlainPart < plain.size()) {
                        qnCandidate = (String)qnCandidate + separator + (String)plain.get(currentPlainPart);
                        continue;
                    }
                    break block17;
                    break;
                }
                if (braceCount < 0) {
                    ++currentPlainPart;
                    while (currentPlainPart < plain.size()) {
                        qnCandidate = (String)qnCandidate + separator + (String)plain.get(currentPlainPart);
                        ++currentPlainPart;
                    }
                }
            }
            res.add((String)qnCandidate);
            ++currentPlainPart;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCQualifiedNamesNodeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcut";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCQualifiedNamesNodeProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "splitAccurate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEndOfGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFullQNIfAny";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "splitAccurate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static class Key {
        final List<String> words;
        final TreeElement node;

        Key(List<String> words, TreeElement node) {
            this.words = words;
            this.node = node;
        }

        @Contract(pure=true)
        @NotNull
        public String toString() {
            String string = "Key{words=" + String.valueOf(this.words) + ", node=" + String.valueOf(this.node) + "}";
            if (string == null) {
                Key.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCQualifiedNamesNodeProvider$Key", "toString"));
        }
    }
}

