/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementMethodsHandlerBase
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCOverrideImplementActionContext> {
    @Override
    @NlsContexts.Command
    @NotNull
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("override.implement.methods.handler.action.title", new Object[0]);
        if (string == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(1);
        }
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCMethodSymbol> methods, @NotNull OCOverrideImplementActionContext context) {
        if (element == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(2);
        }
        if (methods == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(4);
        }
        assert (element instanceof OCImplementation);
        StringBuilder result = new StringBuilder();
        for (OCMethodSymbol baseMethod : methods) {
            result.append(this.generateMethodText(baseMethod, element.getLastChild(), context));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        String string = result.toString();
        if (string == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected Condition<OCMethodSymbol> getCandidatesFilter(@NotNull OCOverrideImplementActionContext context) {
        if (context == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(6);
        }
        HashSet ownMethods = new HashSet();
        context.getImplementationSymbol().processMembers(OCMethodSymbol.class, symbol -> {
            ownMethods.add(symbol.getSignature(context.getProject()));
            return true;
        });
        Condition condition = method -> !ownMethods.contains(method.getSignature(context.getProject()));
        if (condition == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(7);
        }
        return condition;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> methods, OCOverrideImplementActionContext actionContext) {
        OCMethodSymbol firstMethod = methods.get(0);
        OCClassDeclaration declaration = (OCClassDeclaration)element;
        if ((at == null || caretOffset < declaration.getMethodsStartOffset(true)) && (at = declaration.getBestMemberPlace(firstMethod)) != null) {
            caretOffset = at.getTextRange().getStartOffset();
        }
        return declaration.getMethodsInsertPosition(methods.size() == 1 && firstMethod.getName().startsWith("init"), at, caretOffset);
    }

    protected abstract String generateMethodText(OCMethodSymbol var1, PsiElement var2, OCOverrideImplementActionContext var3);

    @Override
    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        if (body == null) {
            OCOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementMethodsHandlerBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementMethodsHandlerBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFilter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

