/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class HtmlHelper {
    @Nls
    @NotNull
    public static String bold(@Nls @NotNull String arg) {
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(0);
        }
        return HtmlHelper.wrapWithTag("b", arg);
    }

    @Nls
    @NotNull
    public static String code(@Nls @NotNull String arg) {
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(1);
        }
        return HtmlHelper.wrapWithTag("code", arg);
    }

    @Nls
    @NotNull
    public static String pre(@Nls @NotNull String arg) {
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(2);
        }
        return HtmlHelper.wrapWithTag("pre", arg);
    }

    @Nls
    @NotNull
    public static String paragraph(@Nls @NotNull String arg) {
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(3);
        }
        return HtmlHelper.wrapWithTag("p", arg);
    }

    @Contract(pure=true)
    @Nls
    @NotNull
    public static String newLine(@Nls @NotNull String arg) {
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(4);
        }
        String string = "<br/>" + arg;
        if (string == null) {
            HtmlHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String wrapWithTag(@NlsSafe @NotNull String tag, @Nls @NotNull String arg) {
        if (tag == null) {
            HtmlHelper.$$$reportNull$$$0(6);
        }
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        HtmlHelper.wrapWithTag(sb, tag, arg);
        String string = sb.toString();
        if (string == null) {
            HtmlHelper.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void wrapWithTag(@NotNull StringBuilder sb, @NlsSafe @NotNull String tagWithAttrsAtNewLines, @Nls @NotNull String arg) {
        if (sb == null) {
            HtmlHelper.$$$reportNull$$$0(9);
        }
        if (tagWithAttrsAtNewLines == null) {
            HtmlHelper.$$$reportNull$$$0(10);
        }
        if (arg == null) {
            HtmlHelper.$$$reportNull$$$0(11);
        }
        String[] strings = StringUtil.splitByLines((String)tagWithAttrsAtNewLines);
        sb.append("<").append(StringUtil.join((String[])strings, (String)" "));
        sb.append(">").append(arg).append("</").append(strings[0]).append(">");
    }

    public static void renderSections(@NotNull StringBuilder sb, @NotNull String key, @NotNull String value) {
        if (sb == null) {
            HtmlHelper.$$$reportNull$$$0(12);
        }
        if (key == null) {
            HtmlHelper.$$$reportNull$$$0(13);
        }
        if (value == null) {
            HtmlHelper.$$$reportNull$$$0(14);
        }
        sb.append("<table class='sections'>");
        sb.append("<tr><td valign='top' class='section'><p>").append(key).append("</td><td valign='top'>").append(value).append("</td>");
        sb.append("</table>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/documentation/HtmlHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagWithAttrsAtNewLines";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/documentation/HtmlHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bold";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "code";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pre";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "paragraph";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newLine";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithTag";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderSections";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }

    public static class TableRow
    extends HtmlItem {
        @NotNull
        public static TableRow withData(@Nls @NotNull String arg) {
            if (arg == null) {
                TableRow.$$$reportNull$$$0(0);
            }
            TableRow raw = new TableRow();
            raw.addData(arg);
            TableRow tableRow = raw;
            if (tableRow == null) {
                TableRow.$$$reportNull$$$0(1);
            }
            return tableRow;
        }

        public void addData(@Nls @NotNull String arg) {
            if (arg == null) {
                TableRow.$$$reportNull$$$0(2);
            }
            HtmlHelper.wrapWithTag(this.sb, "td", arg);
        }

        @Nls
        public String toString() {
            return "<tr valign=\"top\">" + String.valueOf(this.sb) + "</tr>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/documentation/HtmlHelper$TableRow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/documentation/HtmlHelper$TableRow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withData";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class Table
    extends HtmlItem {
        public void addRow(@NotNull TableRow element) {
            if (element == null) {
                Table.$$$reportNull$$$0(0);
            }
            this.sb.append(element.toString());
        }

        public String toString() {
            return HtmlHelper.wrapWithTag("table", this.sb.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/documentation/HtmlHelper$Table", "addRow"));
        }
    }

    public static class HtmlDoc
    extends HtmlItem {
        public void addText(@NotNull String arg) {
            if (arg == null) {
                HtmlDoc.$$$reportNull$$$0(0);
            }
            this.sb.append(arg);
        }

        public void addItem(@NotNull HtmlItem arg) {
            if (arg == null) {
                HtmlDoc.$$$reportNull$$$0(1);
            }
            this.sb.append(arg.toString());
        }

        public String toString() {
            return this.sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "arg";
            objectArray2[1] = "com/jetbrains/cidr/lang/documentation/HtmlHelper$HtmlDoc";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HtmlItem {
        protected final StringBuilder sb = new StringBuilder();
    }
}

