/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class OCQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        if (element == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCSymbolWithParent) {
                return ((OCSymbolWithParent)symbol).getNameWithParent(OCResolveContext.forPsi(element));
            }
            if (symbol != null) {
                return symbol.getName();
            }
        }
        return null;
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        OCSymbol clazz;
        if (fqn == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return null;
        }
        Pattern pattern = Pattern.compile(".\\[([^ ]*) ([^ ]*)\\]");
        Matcher matcher = pattern.matcher(fqn);
        if (!matcher.matches()) {
            pattern = Pattern.compile("([^.]*).([^.]*)]");
            matcher = pattern.matcher(fqn);
        }
        if (matcher.matches() && (clazz = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, matcher.group(1), null, null)) instanceof OCClassSymbol) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCClassSymbol)clazz).processMembersInAllCategories(matcher.group(2), OCMemberSymbol.class, finder, false, project);
            return finder.isFound() ? ((OCMemberSymbol)finder.getFoundValue()).locateDefinition(project) : null;
        }
        OCSymbol symbol = OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project, fqn, null, null);
        return symbol != null ? symbol.locateDefinition(project) : null;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        if (fqn == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCQualifiedNameProvider.$$$reportNull$$$0(7);
        }
        Object string = fqn;
        if (element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                string = "@selector(" + symbol.getName() + ")";
            } else if (symbol instanceof OCPropertySymbol) {
                string = String.valueOf(((OCPropertySymbol)symbol).getParent()) + "." + symbol.getName();
            } else if (symbol instanceof OCInstanceVariableSymbol) {
                string = String.valueOf(((OCInstanceVariableSymbol)symbol).getParent()) + "->" + symbol.getName();
            }
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/OCQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

