/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util.events.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.jetbrains.cidr.util.events.CidrEventTracer;
import com.jetbrains.cidr.util.events.impl.ArrayListBackedEventTracer;
import com.jetbrains.cidr.util.events.impl.NoopEventTracer;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/util/events/impl/ChromeTracingEventTracer;", "", "<init>", "()V", "impl", "Lcom/jetbrains/cidr/util/events/CidrEventTracer;", "getImpl", "()Lcom/jetbrains/cidr/util/events/CidrEventTracer;", "setImpl", "(Lcom/jetbrains/cidr/util/events/CidrEventTracer;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "begin", "Ljava/util/function/BiConsumer;", "", "eventCategory", "eventName", "Lkotlin/Function0;", "details", "threadName", "end", "", "write", "out", "Ljava/io/Writer;", "startTracing", "stopTracing", "Companion", "intellij.cidr.util.execution"})
public final class ChromeTracingEventTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile CidrEventTracer impl = new NoopEventTracer();
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final CidrEventTracer getImpl() {
        return this.impl;
    }

    public final void setImpl(@NotNull CidrEventTracer cidrEventTracer) {
        Intrinsics.checkNotNullParameter((Object)cidrEventTracer, (String)"<set-?>");
        this.impl = cidrEventTracer;
    }

    @NotNull
    public final BiConsumer<String, Object> begin(@NonNls @NotNull String eventCategory, @NonNls @NotNull Function0<String> eventName, @NonNls @NotNull Function0<String> details, @NonNls @NotNull String threadName) {
        Intrinsics.checkNotNullParameter((Object)eventCategory, (String)"eventCategory");
        Intrinsics.checkNotNullParameter(eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        return this.impl.begin(eventCategory, eventName, details, threadName);
    }

    public final void end(@NonNls @NotNull String threadName) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        this.impl.end(threadName);
    }

    public final void write(@NotNull Writer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.impl.write(out);
    }

    public final void startTracing() {
        if (this.connection != null) {
            return;
        }
        MessageBusConnection messageBusConnection = this.connection = ApplicationManager.getApplication().getMessageBus().connect();
        if (messageBusConnection != null) {
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new AnActionListener(){
                private final HashMap<AnActionEvent, CidrEventSpan> eventToSpan;
                {
                    this.eventToSpan = new HashMap<K, V>();
                }

                public final HashMap<AnActionEvent, CidrEventSpan> getEventToSpan() {
                    return this.eventToSpan;
                }

                public void beforeActionPerformed(AnAction action, AnActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!((Map)this.eventToSpan).containsKey(event)) {
                        String string = action.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String description = string;
                        String context = event.getDataContext().toString();
                        ((Map)this.eventToSpan).put(event, new CidrEventSpan("action", description, context, null, 8, null));
                    }
                }

                public void afterActionPerformed(AnAction action, AnActionEvent event, AnActionResult result) {
                    block0: {
                        CidrEventSpan span;
                        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                        CidrEventSpan cidrEventSpan = span = this.eventToSpan.remove(event);
                        if (cidrEventSpan == null) break block0;
                        cidrEventSpan.close();
                    }
                }
            });
        }
        this.impl = new ArrayListBackedEventTracer();
        LOG.info("Chrome tracing started");
    }

    public final void stopTracing() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
        this.impl = new NoopEventTracer();
        LOG.info("Chrome tracing stopped");
    }

    @JvmStatic
    @NotNull
    public static final ChromeTracingEventTracer getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.cidr.util");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/util/events/impl/ChromeTracingEventTracer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/cidr/util/events/impl/ChromeTracingEventTracer;", "intellij.cidr.util.execution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChromeTracingEventTracer getInstance() {
            Object object = ApplicationManager.getApplication().getService(ChromeTracingEventTracer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ChromeTracingEventTracer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

